﻿using System;
using System.Data.Services;
using System.Collections.Generic;
using System.Linq;
using System.ServiceModel.Web;
//源码下载及讨论地址：http://www.51aspx.com/CV/DynamicData
using VS2008SP1.Business;
using System.Linq.Expressions;

// DataService<T> - ADO.NET 数据服务的主入口点。 T 为数据源类名
public class Service : DataService<VS2008SP1.Business.NorthwindEntities>
{
    // 初始化涉及服务范围的策略（仅调用一次）
    public static void InitializeService(IDataServiceConfiguration config)
    {
        /*
         * IDataServiceConfiguration.SetEntitySetAccessRule(string name, EntitySetRights rights) - 为指定实体集设置访问规则
         *     name - 实体集名称（* 为全部）
         *     rights - 设置对指定实体集的操作权限 [System.Data.Services.EntitySetRights 枚举]
         * EntitySetRights.None - 权限为：无任何权限  
         * EntitySetRights.All - 权限为：全部权限  
         * EntitySetRights.ReadSingle - 权限为：只能读取数据集内的某一条数据
         * EntitySetRights.ReadMultiple - 权限为：可读取数据集内的全部数据
         * EntitySetRights.WriteAppend - 权限为：插入  
         * EntitySetRights.WriteReplace - 权限为：更新  
         * EntitySetRights.WriteDelete - 权限为：删除
         * EntitySetRights.WriteMerge - 权限为：合并数据  
         * EntitySetRights.AllRead - 权限为：全部可读  
         * EntitySetRights.AllWrite - 权限为：全部可写  
         */
        config.SetEntitySetAccessRule("*", EntitySetRights.All);
        
        // config.SetEntitySetAccessRule("*", EntitySetRights.AllRead | EntitySetRights.AllWrite);
    }

    /*
     *  QueryInterceptorAttribute - 声明在方法上的查询拦截器
     *      方法名任意（不带参数），返回值必须为一个 Expression<Func<T, bool>> 表达式，T 为需要过滤的实体集类名
     */
    [QueryInterceptor("Orders")]
    public Expression<Func<Orders, bool>> FilterOrders()
    {
        // 本例为无论在任何情况下，返回的 Orders 都是 ContactName 为 Paul Henriot 的 Orders
        return o => o.Customers.ContactName == "Paul Henriot";
    }
}