﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Specialized;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml.Linq;
using System.Web.DynamicData;

public partial class Decimal_MyEditField : System.Web.DynamicData.FieldTemplateUserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        TextBox1.ToolTip = Column.Description;

        SetUpValidator(RequiredFieldValidator1);
        SetUpValidator(CompareValidator1);
        SetUpValidator(RegularExpressionValidator1);
        SetUpValidator(RangeValidator1);
        SetUpValidator(DynamicValidator1);
    }

    protected override void ExtractValues(IOrderedDictionary dictionary)
    {
        dictionary[Column.Name] = ConvertEditedValue(TextBox1.Text);
    }

    public override Control DataControl
    {
        get
        {
            return TextBox1;
        }
    }

    protected void TextBox1_DataBinding(object sender, EventArgs e)
    {
        // 当前显示的值
        decimal currentValue = (decimal)FieldValue;
        
        // 如果当前值小于 30 则以红色显示
        if (currentValue < 30)
        {
            TextBox1.ForeColor = System.Drawing.Color.Red;
        }
    }
}
