﻿<%@ Application Language="C#" %>
<%@ Import Namespace="System.Web.Routing" %>
<%@ Import Namespace="System.Web.DynamicData" %>

<script runat="server">
    
    public static void RegisterRoutes(RouteCollection routes)
    {
        MetaModel model = new MetaModel();

        // MetaModel - 数据库和域对象之间的映射的抽象
        // MetaModel.RegisterContext(Type contextType, ContextConfiguration configuration) - 使用指定的配置上下文注册指定的数据上下文
        //     contextType - 数据模型中所定义的数据上下文类型
        //     configuration - 相关的配置。其 ScaffoldAllTables 属性为是否要启用基架，基架就是基于数据库架构（linq to sql 或 entity framework）生成网页模板的机制
        model.RegisterContext(typeof(VS2008SP1.Business.NorthwindEntities), new ContextConfiguration() { ScaffoldAllTables = true });

        // 下面的语句支持分页模式，在这种模式下，“列表”、“详细”、“插入”
        // 和“更新”任务是使用不同页执行的。若要启用此模式，请取消注释下面
        // 的 route 定义，并注释掉后面的合并页模式部分中的 route 定义。
        routes.Add(new DynamicDataRoute("{table}/{action}.aspx")
        {
            Constraints = new RouteValueDictionary(new { action = "List|Details|Edit|Insert" }),
            Model = model
        });

        // 下面的语句支持合并页模式，在这种模式下，“列表”、“详细”、“插入”
        // 和“更新”任务是使用同一页执行的。若要启用此模式，请取消注释下面
        // 的 routes，并注释掉上面的分页模式部分中的 route 定义。
        // routes.Add(new DynamicDataRoute("{table}/ListDetails.aspx") {
        //     Action = PageAction.List,
        //     ViewName = "ListDetails",
        //     Model = model
        // });

        // routes.Add(new DynamicDataRoute("{table}/ListDetails.aspx") {
        //     Action = PageAction.Details,
        //     ViewName = "ListDetails",
        //     Model = model
        // });
    }

    void Application_Start(object sender, EventArgs e)
    {
        RegisterRoutes(RouteTable.Routes);
    }

</script>

