﻿<%@ Page Language="C#" MasterPageFile="~/Site.master" CodeFile="MyProducts.aspx.cs"
    Inherits="MyProducts" Title="以 Products 表为例，演示动态数据的应用" %>

<%@ Register Assembly="System.Web.Entity, Version=3.5.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089"
    Namespace="System.Web.UI.WebControls" TagPrefix="asp" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="Server">
    <asp:DynamicDataManager ID="DynamicDataManager1" runat="server" AutoLoadForeignKeys="true" />
    <h2>
        以 Products 表为例，演示动态数据的应用</h2>
    <asp:FormView ID="FormView1" runat="server" DataSourceID="FormDataSource" AllowPaging="True"
        DataKeyNames="ProductId">
        <ItemTemplate>
            <table>
                <tr>
                    <td>
                        ProductId:
                    </td>
                    <td>
                        <!--DynamicField - 显示指定的动态数据字段，相当于 BoundField-->
                        <!--DynamicControl - 通过指定的字段模板显示指定的动态数据字段-->
                        <asp:DynamicControl ID="ProductId" runat="server" DataField="ProductId" />
                    </td>
                </tr>
                <tr>
                    <td>
                        ProductName:
                    </td>
                    <td>
                        <asp:DynamicControl ID="ProductName" runat="server" DataField="ProductName" />
                    </td>
                </tr>
                <tr>
                    <td>
                        UnitPrice:
                    </td>
                    <td>
                        <asp:DynamicControl ID="UnitPrice" runat="server" DataField="UnitPrice" />
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <asp:LinkButton ID="InsertButton" runat="server" CommandName="New" CausesValidation="false"
                            Text="New" />
                        <asp:LinkButton ID="EditButton" runat="server" CommandName="Edit" CausesValidation="false"
                            Text="Edit" />
                        <asp:LinkButton ID="DeleteButton" runat="server" CommandName="Delete" CausesValidation="false"
                            Text="Delete" />
                    </td>
                </tr>
            </table>
        </ItemTemplate>
        <EditItemTemplate>
            <table>
                <tr>
                    <td>
                        ProductId:
                    </td>
                    <td>
                        <asp:DynamicControl ID="ProductId" runat="server" DataField="ProductId" Mode="ReadOnly" />
                    </td>
                </tr>
                <tr>
                    <td>
                        ProductName:
                    </td>
                    <td>
                        <!--
                            UIHint - 指定字段模板，此例的字段模板会以黄色背景显示数据
                            Mode - 设置呈现模式 [System.Web.UI.WebControls.DataBoundControlMode 枚举] 
                                DataBoundControlMode.ReadOnly - 只读模式。默认值
                                DataBoundControlMode.Edit - 编辑模式
                                DataBoundControlMode.Insert - 插入模式
                        -->
                        <asp:DynamicControl ID="ProductName" runat="server" DataField="ProductName" Mode="Edit"
                            UIHint="YelloText" />
                    </td>
                </tr>
                <tr>
                    <td>
                        UnitPrice:
                    </td>
                    <td>
                        <asp:DynamicControl ID="UnitPrice" runat="server" DataField="UnitPrice" Mode="Edit" />
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <asp:LinkButton ID="UpdateButton" runat="server" CommandName="Update">Update</asp:LinkButton>
                        <asp:LinkButton ID="CancelEditButton" runat="server" CommandName="Cancel" CausesValidation="false">Cancel</asp:LinkButton>
                    </td>
                </tr>
            </table>
        </EditItemTemplate>
        <InsertItemTemplate>
            <table>
                <tr>
                    <td>
                        ProductName:
                    </td>
                    <td>
                        <asp:DynamicControl ID="ProductName" runat="server" DataField="ProductName" Mode="Insert" />
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <asp:LinkButton ID="InsertButton" runat="server" CommandName="Insert" Text="Insert" />
                        <asp:LinkButton ID="CancelInsertButton" runat="server" CommandName="Cancel" CausesValidation="false"
                            Text="Cancel" />
                    </td>
                </tr>
            </table>
        </InsertItemTemplate>
        <PagerSettings Position="Bottom" Mode="NumericFirstLast" />
    </asp:FormView>
    <asp:EntityDataSource ID="FormDataSource" runat="server" ConnectionString="name=NorthwindEntities"
        DefaultContainerName="NorthwindEntities" EntitySetName="Products" ContextTypeName="VS2008SP1.Business.NorthwindEntities"
        EnableInsert="True" EnableUpdate="True" EnableDelete="True">
    </asp:EntityDataSource>
</asp:Content>
