﻿// 客户端用到的只有以下两个类
// System.Data.Services.Client.DataServiceContext - 数据服务的上下文
// System.Data.Services.Client.DataServiceQuery - 以指定的 URI 语法查询数据服务

using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
//该源码下载自www.51aspx.com(５１aｓｐｘ．ｃｏｍ)

using MyDataService;

public partial class DataServices_Demo : System.Web.UI.Page
{
    // ADO.NET 数据服务的地址
    Uri _uri = new Uri("http://localhost:7002/DataServices/Service.svc/", UriKind.Absolute);

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            BindData();
        }
    }

    void BindData()
    {
        // NorthwindEntities - 继承自 DataServiceContext ，其构造函数的参数为数据服务的 URI 地址
        NorthwindEntities ctx = new NorthwindEntities(_uri);

        // 将 System.Data.Services.Client.DataServiceQuery<Categories> 绑定到 Gridview1
        GridView1.DataSource = ctx.Categories;
        GridView1.DataBind();
    }

    protected void btnAddCategory_Click(object sender, EventArgs e)
    {
        NorthwindEntities ctx = new NorthwindEntities(_uri);

        Categories category = new Categories();
        category.CategoryName = txtCategoryName.Text;
        category.Description = txtDescription.Text;

        // DataServiceContext.Timeout - 超时时间
        // DataServiceContext.MergeOption - 当前数据上下文与数据服务的数据的同步选项 [System.Data.Services.Client.MergeOption 枚举]
        //     AppendOnly - 追加。默认值
        //     OverwriteChanges - 以新结果为准
        //     PreserveChanges - 以原结果为准
        //     NoTracking - 取消变更跟踪，不会使用 ObjectStateManager，减少执行查询的时间，所有返回的实体将是分离的状态（detached state）
        ctx.MergeOption = System.Data.Services.Client.MergeOption.AppendOnly;

        ctx.AddToCategories(category);

        for (int i = 0; i < 10; i++)
        {
            var product = new Products() { ProductName = "测试用" + i.ToString() };
            product.Categories = category;

            ctx.AddToProducts(product);

            // DataServiceContext.SetLikn(Object source, string sourceProperty, Object target) - 在指定的对象之间建立连接
            //     source - 源对象
            //     sourceProperty - 源对象上的属性，用于标识目标对象的类型
            //     target - 目标对象
            ctx.SetLink(product, "Categories", category);
            // DataServiceContext.DetachLink(Object source, string sourceProperty, Object target) - 移除指定对象间的连接
            // DataServiceContext.DeleteLink(Object source, string sourceProperty, Object target) - 将指定对象间的连接状态改为已删除状态
        }

        // DataServiceContext.SaveChanges() - 将所有更新保存到相关存储区中
        //     SaveChangesOptions.Batch - 一个 http 提交所有操作
        //     SaveChangesOptions.ContinueOnError - 一个 http 一个操作，某操作出错仍将处理后续操作（不能与 Batch 共存）
        //     SaveChangesOptions.ReplaceOnUpdate - 
        //     SaveChangesOptions.None - 出错则停止
        ctx.SaveChanges(System.Data.Services.Client.SaveChangesOptions.Batch);

        Page.ClientScript.RegisterStartupScript(this.GetType(), "js", "alert('CategoryID: " + category.CategoryID + "');", true);

        GridView1.EditIndex = -1;
        BindData();
    }

    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        NorthwindEntities ctx = new NorthwindEntities(_uri);

        var categoryId = (int)GridView1.DataKeys[e.RowIndex].Value;

        var category = ctx.Categories.Where(p => p.CategoryID == categoryId).First();

        // DataServiceContext.LoadProperty(Object entity, string propertyName) - 加载指定对象的指定实体属性
        //     entity - 包含要加载的实体属性的实体
        //     propertyName - 需要加载的实体属性的名称
        ctx.LoadProperty(category, "Products");
        foreach (var product in category.Products)
        {
            ctx.DeleteObject(product);
        }

        ctx.DeleteObject(category);

        ctx.SaveChanges();

        GridView1.EditIndex = -1;
        BindData();
    }

    protected void GridView1_SelectedIndexChanged(object sender, EventArgs e)
    {
        NorthwindEntities ctx = new NorthwindEntities(_uri);

        var categoryId = (int)GridView1.SelectedDataKey.Value;

        // 查找当前选中的类别下的产品集合
        var products = ctx.Products.Where(p => p.Categories.CategoryID == categoryId);

        // 将 System.Linq.IQueryable<Products> 绑定到 GridView2
        GridView2.DataSource = products;
        GridView2.DataBind();
    }

    protected void GridView1_RowUpdating(object sender, GridViewUpdateEventArgs e)
    {
        NorthwindEntities ctx = new NorthwindEntities(_uri);

        var categoryId = (int)GridView1.DataKeys[e.RowIndex].Value;

        var category = ctx.Categories.Where(p => p.CategoryID == categoryId).First();

        category.CategoryName = ((TextBox)GridView1.Rows[e.RowIndex].Cells[1].Controls[0]).Text;
        category.Description = ((TextBox)GridView1.Rows[e.RowIndex].Cells[2].Controls[0]).Text;

        ctx.UpdateObject(category);
        ctx.SaveChanges();

        GridView1.EditIndex = -1;
        BindData();
    }

    protected void GridView1_RowEditing(object sender, GridViewEditEventArgs e)
    {
        GridView1.EditIndex = e.NewEditIndex;
        BindData();
    }

    protected void GridView1_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
    {
        GridView1.EditIndex = -1;
        BindData();
    }
}
