﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using MyDataService;
using System.Data.Services.Client;

public partial class DataServices_Demo2 : System.Web.UI.Page
{
    // ADO.NET 数据服务的地址
    Uri _uri = new Uri("http://localhost:7002/DataServices/Service.svc/", UriKind.Absolute);

    protected void Page_Load(object sender, EventArgs e)
    {
        // 以 URI 语法的方式查询 ADO.NET 数据服务
        Demo();

        // 异步方式查询 ADO.NET 数据服务
        Demo2();

        // 演示查询拦截器的 Demo
        Demo3();

        // 演示以 JSON 作为响应格式的 Demo
        Demo4();
    }

    void Demo()
    {
        DataServiceContext ctx = new DataServiceContext(_uri);

        // 以 URI 语法的方式查询 ADO.NET 数据服务，详细语法参看 MSDN
        // http://[Url]/[ServiceName]/[EntityName]/[NavigationOptions]?[QueryOptions]
        DataServiceQuery<Categories> categories = ctx.CreateQuery<Categories>("/Categories");

        foreach (var c in categories)
        {
            result.InnerHtml += c.CategoryID + ",";
        }

        result.InnerHtml += "<br /><br />";
    }

    void Demo2()
    {
        DataServiceContext ctx = new DataServiceContext(_uri);

        DataServiceQuery<Categories> query = ctx.CreateQuery<Categories>("/Categories");

        // 异步方式查询 ADO.NET 数据服务
        query.BeginExecute(
            delegate(IAsyncResult ar)
            {
                foreach (var c in query.EndExecute(ar))
                {
                    result.InnerHtml += c.CategoryID + ",";
                }

                result.InnerHtml += "<br /><br />";
            },
            null);
    }

    void Demo3()
    {
        NorthwindEntities ctx = new NorthwindEntities(_uri);

        // 因为设置了查询拦截器，所以只能收到 ContactName 为 Paul Henriot 的 Orders
        foreach (var o in ctx.Orders)
        {
            result.InnerHtml += o.OrderID + ",";
        }

        result.InnerHtml += "<br /><br />";
    }

    void Demo4()
    {
        System.Net.WebClient client = new System.Net.WebClient();
        // 需要以 json 格式返回结果的话，需要设置以下 header
        client.Headers.Add("accept", "application/json");
        // client.Headers.Add("accept", "application/xml"); xml/atom 格式
        // client.Headers.Add("accept", "*/*"); xml/atom 格式，默认值
        result.InnerHtml += HttpUtility.HtmlEncode(client.DownloadString(_uri));
    }
}
