﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

// 在 System.Data.Entity.dll 程序集中
using System.Data.Objects;
using System.Data.Objects.DataClasses;

using VS2008SP1.Business;

public partial class EntityFramework_Demo : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            BindData();
        }
    }

    void BindData()
    {
        using (var ctx = new NorthwindEntities())
        {
            // 将 System.Data.Objects.ObjectQuery<Categories> 绑定到 Gridview1
            GridView1.DataSource = ctx.Categories;
            GridView1.DataBind();
        }
    }

    protected void btnAddCategory_Click(object sender, EventArgs e)
    {
        // NorthwindEntities -  继承自 System.Data.Objects.ObjectContext
        // ObjectContext -  以对象（这些对象是 EDM 中定义的实体类型的实例）的形式与数据进行交互
        using (var ctx = new NorthwindEntities())
        {
            // CreateObjectName - 实体类 的 CreateObjectName 静态方法用于创建实体类的新实例
            //     构造函数的参数为对应的实体类的必填字段
            //     如果参数属于自增列，如本例中的 categoryID ，可以先对其赋予任意值
            var category = Categories.CreateCategories(-1, txtCategoryName.Text);
            category.Description = txtDescription.Text;

            for (int i = 0; i < 10; i++)
            {
                category.Products.Add(new Products() { ProductName = "测试用" + i.ToString()});
            }

            // AddToEntitySetName() - 将需要添加的对象添加到对象上下文中
            ctx.AddToCategories(category);

            // SaveChanges() - 将所有更新保存到相关存储区中
            ctx.SaveChanges();

            // SaveChanges() 之后就可以通过 category.CategoryID 来取得其自增列在数据库中所保存的值
            Page.ClientScript.RegisterStartupScript(this.GetType(), "js", "alert('CategoryID: " + category.CategoryID + "');", true);
        }

        GridView1.EditIndex = -1;
        BindData();
    }

    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        using (var ctx = new NorthwindEntities())
        {
            var categoryId = (int)GridView1.DataKeys[e.RowIndex].Value;

            var category = ctx.Categories.First(p => p.CategoryID == categoryId);

            // 加载类别下的产品到当前上下文中，用以级联删除
            // 当然如果在数据库中配置了级联删除，并且映射中配置了<OnDelete Action="Cascade" />（EDM编辑器会根据数据库中的配置自动做此配置）则不用此句
            category.Products.Load();

            // DeleteObject() - 将指定的对象的状态更改为已删除（调用 SaveChanges() 之后才会执行）
            ctx.DeleteObject(category);

            ctx.SaveChanges();
        }

        GridView1.EditIndex = -1;
        BindData();
    }

    protected void GridView1_SelectedIndexChanged(object sender, EventArgs e)
    {
        using (var ctx = new NorthwindEntities())
        {
            var categoryId = (int)GridView1.SelectedDataKey.Value;

            // 查找当前选中的类别下的产品集合
            var products = ctx.Products.Where(p => p.Categories.CategoryID == categoryId);

            // 将 System.Linq.IQueryable<Products> 绑定到 GridView2
            GridView2.DataSource = products;
            GridView2.DataBind();
        }
    }

    protected void GridView1_RowUpdating(object sender, GridViewUpdateEventArgs e)
    {
        using (var ctx = new NorthwindEntities())
        {
            var categoryId = (int)GridView1.DataKeys[e.RowIndex].Value;

            var category = ctx.Categories.First(p => p.CategoryID == categoryId);

            // 修改 category 对象的属性
            category.CategoryName = ((TextBox)GridView1.Rows[e.RowIndex].Cells[1].Controls[0]).Text;
            category.Description = ((TextBox)GridView1.Rows[e.RowIndex].Cells[2].Controls[0]).Text;

            ctx.SaveChanges();
        }

        GridView1.EditIndex = -1;
        BindData();
    }

    protected void GridView1_RowEditing(object sender, GridViewEditEventArgs e)
    {
        GridView1.EditIndex = e.NewEditIndex;
        BindData();
    }

    protected void GridView1_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
    {
        GridView1.EditIndex = -1;
        BindData();
    }
}
