﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Data.Objects;
using System.Data.Objects.DataClasses;

using VS2008SP1.Business;

public partial class EntityFramework_LinqToEntities : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            Demo();
        }
    }

    void Demo()
    {
        using (var ctx = new NorthwindEntities())
        {
            Products first = ctx.Products.First(p => p.ProductID > 3);
            Products firstOrDefault = ctx.Products.FirstOrDefault(p => p.ProductID > 100);
            bool all = ctx.Products.All(p => p.ProductID > 3);
            bool any = ctx.Products.Any(p => p.ProductID > 3);
            decimal? average = ctx.Products.Average(p => p.UnitPrice);
            decimal? sum = ctx.Products.Sum(p => p.UnitPrice);
            decimal? max = ctx.Products.Max(p => p.UnitPrice);
            decimal? min = ctx.Products.Min(p => p.UnitPrice);
            int count = ctx.Products.Count(p => p.ProductID > 3);
            long longCount = ctx.Products.LongCount(p => p.ProductID > 3);

            IQueryable<Products> take = ctx.Products.Take(3);
            take.ToList();
            IQueryable<Products> skip = ctx.Products.OrderBy(p => p.UnitPrice).Skip(3);
            skip.ToList();
            ObjectQuery<Products> distinct = ctx.Products.Distinct();
            distinct.ToList();

            ObjectQuery<Products> union = ctx.Products.Union(ctx.Products);
            union.ToList();
            ObjectQuery<Products> unionAll = ctx.Products.UnionAll(ctx.Products);
            unionAll.ToList();
            IQueryable<Products> concat = ctx.Products.Concat(ctx.Products);
            concat.ToList();
            ObjectQuery<Products> intersect = ctx.Products.Intersect(ctx.Products);
            intersect.ToList();
            ObjectQuery<Products> except = ctx.Products.Except(ctx.Products);
            except.ToList();
        }
    }
}

/*
Products first = ctx.Products.First(p => p.ProductID > 3)

SELECT 
[Limit1].[C1] AS [C1], 
[Limit1].[Discontinued] AS [Discontinued], 
[Limit1].[ProductID] AS [ProductID], 
[Limit1].[ProductName] AS [ProductName], 
[Limit1].[QuantityPerUnit] AS [QuantityPerUnit], 
[Limit1].[ReorderLevel] AS [ReorderLevel], 
[Limit1].[UnitPrice] AS [UnitPrice], 
[Limit1].[UnitsInStock] AS [UnitsInStock], 
[Limit1].[UnitsOnOrder] AS [UnitsOnOrder], 
[Limit1].[CategoryID] AS [CategoryID], 
[Limit1].[SupplierID] AS [SupplierID]
FROM ( SELECT TOP (1) 
	[Extent1].[CategoryID] AS [CategoryID], 
	[Extent1].[Discontinued] AS [Discontinued], 
	[Extent1].[ProductID] AS [ProductID], 
	[Extent1].[ProductName] AS [ProductName], 
	[Extent1].[QuantityPerUnit] AS [QuantityPerUnit], 
	[Extent1].[ReorderLevel] AS [ReorderLevel], 
	[Extent1].[SupplierID] AS [SupplierID], 
	[Extent1].[UnitPrice] AS [UnitPrice], 
	[Extent1].[UnitsInStock] AS [UnitsInStock], 
	[Extent1].[UnitsOnOrder] AS [UnitsOnOrder], 
	1 AS [C1]
	FROM [dbo].[Products] AS [Extent1]
	WHERE [Extent1].[ProductID] > 3
)  AS [Limit1]
*/

/*
Products firstOrDefault = ctx.Products.FirstOrDefault(p => p.ProductID > 100);

SELECT 
[Limit1].[C1] AS [C1], 
[Limit1].[Discontinued] AS [Discontinued], 
[Limit1].[ProductID] AS [ProductID], 
[Limit1].[ProductName] AS [ProductName], 
[Limit1].[QuantityPerUnit] AS [QuantityPerUnit], 
[Limit1].[ReorderLevel] AS [ReorderLevel], 
[Limit1].[UnitPrice] AS [UnitPrice], 
[Limit1].[UnitsInStock] AS [UnitsInStock], 
[Limit1].[UnitsOnOrder] AS [UnitsOnOrder], 
[Limit1].[CategoryID] AS [CategoryID], 
[Limit1].[SupplierID] AS [SupplierID]
FROM ( SELECT TOP (1) 
	[Extent1].[CategoryID] AS [CategoryID], 
	[Extent1].[Discontinued] AS [Discontinued], 
	[Extent1].[ProductID] AS [ProductID], 
	[Extent1].[ProductName] AS [ProductName], 
	[Extent1].[QuantityPerUnit] AS [QuantityPerUnit], 
	[Extent1].[ReorderLevel] AS [ReorderLevel], 
	[Extent1].[SupplierID] AS [SupplierID], 
	[Extent1].[UnitPrice] AS [UnitPrice], 
	[Extent1].[UnitsInStock] AS [UnitsInStock], 
	[Extent1].[UnitsOnOrder] AS [UnitsOnOrder], 
	1 AS [C1]
	FROM [dbo].[Products] AS [Extent1]
	WHERE [Extent1].[ProductID] > 100
)  AS [Limit1]
*/

/*
bool all = ctx.Products.All(p => p.ProductID > 3);

SELECT 
CASE WHEN ( NOT EXISTS (SELECT 
	cast(1 as bit) AS [C1]
	FROM [dbo].[Products] AS [Extent1]
	WHERE ( NOT ([Extent1].[ProductID] > 3)) OR (CASE WHEN ([Extent1].[ProductID] > 3) THEN cast(1 as bit) WHEN ( NOT ([Extent1].[ProductID] > 3)) THEN cast(0 as bit) END IS NULL)
)) THEN cast(1 as bit) WHEN ( EXISTS (SELECT 
	cast(1 as bit) AS [C1]
	FROM [dbo].[Products] AS [Extent2]
	WHERE ( NOT ([Extent2].[ProductID] > 3)) OR (CASE WHEN ([Extent2].[ProductID] > 3) THEN cast(1 as bit) WHEN ( NOT ([Extent2].[ProductID] > 3)) THEN cast(0 as bit) END IS NULL)
)) THEN cast(0 as bit) END AS [C1]
FROM  ( SELECT cast(1 as bit) AS X ) AS [SingleRowTable1]
*/

/*
bool any = ctx.Products.Any(p => p.ProductID > 3)

SELECT 
CASE WHEN ( EXISTS (SELECT 
	cast(1 as bit) AS [C1]
	FROM [dbo].[Products] AS [Extent1]
	WHERE [Extent1].[ProductID] > 3
)) THEN cast(1 as bit) WHEN ( NOT EXISTS (SELECT 
	cast(1 as bit) AS [C1]
	FROM [dbo].[Products] AS [Extent2]
	WHERE [Extent2].[ProductID] > 3
)) THEN cast(0 as bit) END AS [C1]
FROM  ( SELECT cast(1 as bit) AS X ) AS [SingleRowTable1]
*/

/*
decimal? average = ctx.Products.Average(p => p.UnitPrice); 
 
SELECT 
[GroupBy1].[A1] AS [C1]
FROM   ( SELECT cast(1 as bit) AS X ) AS [SingleRowTable1]
LEFT OUTER JOIN  (SELECT 
	AVG([Extent1].[UnitPrice]) AS [A1]
	FROM [dbo].[Products] AS [Extent1] ) AS [GroupBy1] ON 1 = 1 
*/

/*
decimal? sum = ctx.Products.Sum(p => p.UnitPrice); 

SELECT 
[GroupBy1].[A1] AS [C1]
FROM   ( SELECT cast(1 as bit) AS X ) AS [SingleRowTable1]
LEFT OUTER JOIN  (SELECT 
	SUM([Extent1].[UnitPrice]) AS [A1]
	FROM [dbo].[Products] AS [Extent1] ) AS [GroupBy1] ON 1 = 1
*/

/*
decimal? max = ctx.Products.Max(p => p.UnitPrice); 

SELECT 
[GroupBy1].[A1] AS [C1]
FROM   ( SELECT cast(1 as bit) AS X ) AS [SingleRowTable1]
LEFT OUTER JOIN  (SELECT 
	MAX([Extent1].[UnitPrice]) AS [A1]
	FROM [dbo].[Products] AS [Extent1] ) AS [GroupBy1] ON 1 = 1
*/

/*
decimal? min = ctx.Products.Min(p => p.UnitPrice); 
 
SELECT 
[GroupBy1].[A1] AS [C1]
FROM   ( SELECT cast(1 as bit) AS X ) AS [SingleRowTable1]
LEFT OUTER JOIN  (SELECT 
	MIN([Extent1].[UnitPrice]) AS [A1]
	FROM [dbo].[Products] AS [Extent1] ) AS [GroupBy1] ON 1 = 1 
*/

/*
int count = ctx.Products.Count(p => p.ProductID > 3); 
 
SELECT 
[GroupBy1].[A1] AS [C1]
FROM   ( SELECT cast(1 as bit) AS X ) AS [SingleRowTable1]
LEFT OUTER JOIN  (SELECT 
	COUNT(cast(1 as bit)) AS [A1]
	FROM [dbo].[Products] AS [Extent1]
	WHERE [Extent1].[ProductID] > 3 ) AS [GroupBy1] ON 1 = 1 
*/

/*
long longCount = ctx.Products.LongCount(p => p.ProductID > 3); 
 
SELECT 
[GroupBy1].[A1] AS [C1]
FROM   ( SELECT cast(1 as bit) AS X ) AS [SingleRowTable1]
LEFT OUTER JOIN  (SELECT 
	COUNT_BIG(cast(1 as bit)) AS [A1]
	FROM [dbo].[Products] AS [Extent1]
	WHERE [Extent1].[ProductID] > 3 ) AS [GroupBy1] ON 1 = 1 
*/

/*
IQueryable<Products> take = ctx.Products.Take(3) 
 
SELECT 
[Limit1].[C1] AS [C1], 
[Limit1].[Discontinued] AS [Discontinued], 
[Limit1].[ProductID] AS [ProductID], 
[Limit1].[ProductName] AS [ProductName], 
[Limit1].[QuantityPerUnit] AS [QuantityPerUnit], 
[Limit1].[ReorderLevel] AS [ReorderLevel], 
[Limit1].[UnitPrice] AS [UnitPrice], 
[Limit1].[UnitsInStock] AS [UnitsInStock], 
[Limit1].[UnitsOnOrder] AS [UnitsOnOrder], 
[Limit1].[CategoryID] AS [CategoryID], 
[Limit1].[SupplierID] AS [SupplierID]
FROM ( SELECT TOP (3) 
	[Extent1].[CategoryID] AS [CategoryID], 
	[Extent1].[Discontinued] AS [Discontinued], 
	[Extent1].[ProductID] AS [ProductID], 
	[Extent1].[ProductName] AS [ProductName], 
	[Extent1].[QuantityPerUnit] AS [QuantityPerUnit], 
	[Extent1].[ReorderLevel] AS [ReorderLevel], 
	[Extent1].[SupplierID] AS [SupplierID], 
	[Extent1].[UnitPrice] AS [UnitPrice], 
	[Extent1].[UnitsInStock] AS [UnitsInStock], 
	[Extent1].[UnitsOnOrder] AS [UnitsOnOrder], 
	1 AS [C1]
	FROM [dbo].[Products] AS [Extent1]
)  AS [Limit1]
*/

/*
IQueryable<Products> skip = ctx.Products.OrderBy(p => p.UnitPrice).Skip(3); 

SELECT 
[Project1].[C1] AS [C1], 
[Project1].[Discontinued] AS [Discontinued], 
[Project1].[ProductID] AS [ProductID], 
[Project1].[ProductName] AS [ProductName], 
[Project1].[QuantityPerUnit] AS [QuantityPerUnit], 
[Project1].[ReorderLevel] AS [ReorderLevel], 
[Project1].[UnitPrice] AS [UnitPrice], 
[Project1].[UnitsInStock] AS [UnitsInStock], 
[Project1].[UnitsOnOrder] AS [UnitsOnOrder], 
[Project1].[CategoryID] AS [CategoryID], 
[Project1].[SupplierID] AS [SupplierID]
FROM ( SELECT [Project1].[CategoryID] AS [CategoryID], [Project1].[Discontinued] AS [Discontinued], [Project1].[ProductID] AS [ProductID], [Project1].[ProductName] AS [ProductName], [Project1].[QuantityPerUnit] AS [QuantityPerUnit], [Project1].[ReorderLevel] AS [ReorderLevel], [Project1].[SupplierID] AS [SupplierID], [Project1].[UnitPrice] AS [UnitPrice], [Project1].[UnitsInStock] AS [UnitsInStock], [Project1].[UnitsOnOrder] AS [UnitsOnOrder], [Project1].[C1] AS [C1], row_number() OVER (ORDER BY [Project1].[UnitPrice] ASC) AS [row_number]
	FROM ( SELECT 
		[Extent1].[CategoryID] AS [CategoryID], 
		[Extent1].[Discontinued] AS [Discontinued], 
		[Extent1].[ProductID] AS [ProductID], 
		[Extent1].[ProductName] AS [ProductName], 
		[Extent1].[QuantityPerUnit] AS [QuantityPerUnit], 
		[Extent1].[ReorderLevel] AS [ReorderLevel], 
		[Extent1].[SupplierID] AS [SupplierID], 
		[Extent1].[UnitPrice] AS [UnitPrice], 
		[Extent1].[UnitsInStock] AS [UnitsInStock], 
		[Extent1].[UnitsOnOrder] AS [UnitsOnOrder], 
		1 AS [C1]
		FROM [dbo].[Products] AS [Extent1]
	)  AS [Project1]
)  AS [Project1]
WHERE [Project1].[row_number] > 3
ORDER BY [Project1].[UnitPrice] ASC 
*/

/*
ObjectQuery<Products> distinct = ctx.Products.Distinct(); 

SELECT 
1 AS [C1], 
[Extent1].[Discontinued] AS [Discontinued], 
[Extent1].[ProductID] AS [ProductID], 
[Extent1].[ProductName] AS [ProductName], 
[Extent1].[QuantityPerUnit] AS [QuantityPerUnit], 
[Extent1].[ReorderLevel] AS [ReorderLevel], 
[Extent1].[UnitPrice] AS [UnitPrice], 
[Extent1].[UnitsInStock] AS [UnitsInStock], 
[Extent1].[UnitsOnOrder] AS [UnitsOnOrder], 
[Extent1].[CategoryID] AS [CategoryID], 
[Extent1].[SupplierID] AS [SupplierID]
FROM [dbo].[Products] AS [Extent1] 
*/

/*
ObjectQuery<Products> union = ctx.Products.Union(ctx.Products); 
 
SELECT 
1 AS [C1], 
[Distinct1].[C1] AS [C2], 
[Distinct1].[C2] AS [C3], 
[Distinct1].[C3] AS [C4], 
[Distinct1].[C4] AS [C5], 
[Distinct1].[C5] AS [C6], 
[Distinct1].[C6] AS [C7], 
[Distinct1].[C7] AS [C8], 
[Distinct1].[C8] AS [C9], 
[Distinct1].[C9] AS [C10], 
[Distinct1].[C10] AS [C11]
FROM ( SELECT DISTINCT 
	[UnionAll1].[Discontinued] AS [C1], 
	[UnionAll1].[ProductID] AS [C2], 
	[UnionAll1].[ProductName] AS [C3], 
	[UnionAll1].[QuantityPerUnit] AS [C4], 
	[UnionAll1].[ReorderLevel] AS [C5], 
	[UnionAll1].[UnitPrice] AS [C6], 
	[UnionAll1].[UnitsInStock] AS [C7], 
	[UnionAll1].[UnitsOnOrder] AS [C8], 
	[UnionAll1].[CategoryID] AS [C9], 
	[UnionAll1].[SupplierID] AS [C10]
	FROM  (SELECT 
		[Extent1].[Discontinued] AS [Discontinued], 
		[Extent1].[ProductID] AS [ProductID], 
		[Extent1].[ProductName] AS [ProductName], 
		[Extent1].[QuantityPerUnit] AS [QuantityPerUnit], 
		[Extent1].[ReorderLevel] AS [ReorderLevel], 
		[Extent1].[UnitPrice] AS [UnitPrice], 
		[Extent1].[UnitsInStock] AS [UnitsInStock], 
		[Extent1].[UnitsOnOrder] AS [UnitsOnOrder], 
		[Extent1].[CategoryID] AS [CategoryID], 
		[Extent1].[SupplierID] AS [SupplierID]
		FROM [dbo].[Products] AS [Extent1]
	UNION ALL
		SELECT 
		[Extent2].[Discontinued] AS [Discontinued], 
		[Extent2].[ProductID] AS [ProductID], 
		[Extent2].[ProductName] AS [ProductName], 
		[Extent2].[QuantityPerUnit] AS [QuantityPerUnit], 
		[Extent2].[ReorderLevel] AS [ReorderLevel], 
		[Extent2].[UnitPrice] AS [UnitPrice], 
		[Extent2].[UnitsInStock] AS [UnitsInStock], 
		[Extent2].[UnitsOnOrder] AS [UnitsOnOrder], 
		[Extent2].[CategoryID] AS [CategoryID], 
		[Extent2].[SupplierID] AS [SupplierID]
		FROM [dbo].[Products] AS [Extent2]) AS [UnionAll1]
)  AS [Distinct1]
*/

/*
ObjectQuery<Products> unionAll = ctx.Products.UnionAll(ctx.Products);
 
SELECT 
1 AS [C1], 
[UnionAll1].[Discontinued] AS [C2], 
[UnionAll1].[ProductID] AS [C3], 
[UnionAll1].[ProductName] AS [C4], 
[UnionAll1].[QuantityPerUnit] AS [C5], 
[UnionAll1].[ReorderLevel] AS [C6], 
[UnionAll1].[UnitPrice] AS [C7], 
[UnionAll1].[UnitsInStock] AS [C8], 
[UnionAll1].[UnitsOnOrder] AS [C9], 
[UnionAll1].[CategoryID] AS [C10], 
[UnionAll1].[SupplierID] AS [C11]
FROM  (SELECT 
	[Extent1].[Discontinued] AS [Discontinued], 
	[Extent1].[ProductID] AS [ProductID], 
	[Extent1].[ProductName] AS [ProductName], 
	[Extent1].[QuantityPerUnit] AS [QuantityPerUnit], 
	[Extent1].[ReorderLevel] AS [ReorderLevel], 
	[Extent1].[UnitPrice] AS [UnitPrice], 
	[Extent1].[UnitsInStock] AS [UnitsInStock], 
	[Extent1].[UnitsOnOrder] AS [UnitsOnOrder], 
	[Extent1].[CategoryID] AS [CategoryID], 
	[Extent1].[SupplierID] AS [SupplierID]
	FROM [dbo].[Products] AS [Extent1]
UNION ALL
	SELECT 
	[Extent2].[Discontinued] AS [Discontinued], 
	[Extent2].[ProductID] AS [ProductID], 
	[Extent2].[ProductName] AS [ProductName], 
	[Extent2].[QuantityPerUnit] AS [QuantityPerUnit], 
	[Extent2].[ReorderLevel] AS [ReorderLevel], 
	[Extent2].[UnitPrice] AS [UnitPrice], 
	[Extent2].[UnitsInStock] AS [UnitsInStock], 
	[Extent2].[UnitsOnOrder] AS [UnitsOnOrder], 
	[Extent2].[CategoryID] AS [CategoryID], 
	[Extent2].[SupplierID] AS [SupplierID]
	FROM [dbo].[Products] AS [Extent2]) AS [UnionAll1]
*/

/*
IQueryable<Products> concat = ctx.Products.Concat(ctx.Products);
 
SELECT 
1 AS [C1], 
[UnionAll1].[Discontinued] AS [C2], 
[UnionAll1].[ProductID] AS [C3], 
[UnionAll1].[ProductName] AS [C4], 
[UnionAll1].[QuantityPerUnit] AS [C5], 
[UnionAll1].[ReorderLevel] AS [C6], 
[UnionAll1].[UnitPrice] AS [C7], 
[UnionAll1].[UnitsInStock] AS [C8], 
[UnionAll1].[UnitsOnOrder] AS [C9], 
[UnionAll1].[CategoryID] AS [C10], 
[UnionAll1].[SupplierID] AS [C11]
FROM  (SELECT 
	[Extent1].[Discontinued] AS [Discontinued], 
	[Extent1].[ProductID] AS [ProductID], 
	[Extent1].[ProductName] AS [ProductName], 
	[Extent1].[QuantityPerUnit] AS [QuantityPerUnit], 
	[Extent1].[ReorderLevel] AS [ReorderLevel], 
	[Extent1].[UnitPrice] AS [UnitPrice], 
	[Extent1].[UnitsInStock] AS [UnitsInStock], 
	[Extent1].[UnitsOnOrder] AS [UnitsOnOrder], 
	[Extent1].[CategoryID] AS [CategoryID], 
	[Extent1].[SupplierID] AS [SupplierID]
	FROM [dbo].[Products] AS [Extent1]
UNION ALL
	SELECT 
	[Extent2].[Discontinued] AS [Discontinued], 
	[Extent2].[ProductID] AS [ProductID], 
	[Extent2].[ProductName] AS [ProductName], 
	[Extent2].[QuantityPerUnit] AS [QuantityPerUnit], 
	[Extent2].[ReorderLevel] AS [ReorderLevel], 
	[Extent2].[UnitPrice] AS [UnitPrice], 
	[Extent2].[UnitsInStock] AS [UnitsInStock], 
	[Extent2].[UnitsOnOrder] AS [UnitsOnOrder], 
	[Extent2].[CategoryID] AS [CategoryID], 
	[Extent2].[SupplierID] AS [SupplierID]
	FROM [dbo].[Products] AS [Extent2]) AS [UnionAll1]
*/

/*
ObjectQuery<Products> intersect = ctx.Products.Intersect(ctx.Products); 
 
SELECT 
1 AS [C1], 
[Intersect1].[Discontinued] AS [C2], 
[Intersect1].[ProductID] AS [C3], 
[Intersect1].[ProductName] AS [C4], 
[Intersect1].[QuantityPerUnit] AS [C5], 
[Intersect1].[ReorderLevel] AS [C6], 
[Intersect1].[UnitPrice] AS [C7], 
[Intersect1].[UnitsInStock] AS [C8], 
[Intersect1].[UnitsOnOrder] AS [C9], 
[Intersect1].[CategoryID] AS [C10], 
[Intersect1].[SupplierID] AS [C11]
FROM  (SELECT 
	[Extent1].[Discontinued] AS [Discontinued], 
	[Extent1].[ProductID] AS [ProductID], 
	[Extent1].[ProductName] AS [ProductName], 
	[Extent1].[QuantityPerUnit] AS [QuantityPerUnit], 
	[Extent1].[ReorderLevel] AS [ReorderLevel], 
	[Extent1].[UnitPrice] AS [UnitPrice], 
	[Extent1].[UnitsInStock] AS [UnitsInStock], 
	[Extent1].[UnitsOnOrder] AS [UnitsOnOrder], 
	[Extent1].[CategoryID] AS [CategoryID], 
	[Extent1].[SupplierID] AS [SupplierID]
	FROM [dbo].[Products] AS [Extent1]
INTERSECT
	SELECT 
	[Extent2].[Discontinued] AS [Discontinued], 
	[Extent2].[ProductID] AS [ProductID], 
	[Extent2].[ProductName] AS [ProductName], 
	[Extent2].[QuantityPerUnit] AS [QuantityPerUnit], 
	[Extent2].[ReorderLevel] AS [ReorderLevel], 
	[Extent2].[UnitPrice] AS [UnitPrice], 
	[Extent2].[UnitsInStock] AS [UnitsInStock], 
	[Extent2].[UnitsOnOrder] AS [UnitsOnOrder], 
	[Extent2].[CategoryID] AS [CategoryID], 
	[Extent2].[SupplierID] AS [SupplierID]
	FROM [dbo].[Products] AS [Extent2]) AS [Intersect1] 
*/

/*
ObjectQuery<Products> except = ctx.Products.Except(ctx.Products);
 
SELECT 
1 AS [C1], 
[Except1].[Discontinued] AS [C2], 
[Except1].[ProductID] AS [C3], 
[Except1].[ProductName] AS [C4], 
[Except1].[QuantityPerUnit] AS [C5], 
[Except1].[ReorderLevel] AS [C6], 
[Except1].[UnitPrice] AS [C7], 
[Except1].[UnitsInStock] AS [C8], 
[Except1].[UnitsOnOrder] AS [C9], 
[Except1].[CategoryID] AS [C10], 
[Except1].[SupplierID] AS [C11]
FROM  (SELECT 
	[Extent1].[Discontinued] AS [Discontinued], 
	[Extent1].[ProductID] AS [ProductID], 
	[Extent1].[ProductName] AS [ProductName], 
	[Extent1].[QuantityPerUnit] AS [QuantityPerUnit], 
	[Extent1].[ReorderLevel] AS [ReorderLevel], 
	[Extent1].[UnitPrice] AS [UnitPrice], 
	[Extent1].[UnitsInStock] AS [UnitsInStock], 
	[Extent1].[UnitsOnOrder] AS [UnitsOnOrder], 
	[Extent1].[CategoryID] AS [CategoryID], 
	[Extent1].[SupplierID] AS [SupplierID]
	FROM [dbo].[Products] AS [Extent1]
EXCEPT
	SELECT 
	[Extent2].[Discontinued] AS [Discontinued], 
	[Extent2].[ProductID] AS [ProductID], 
	[Extent2].[ProductName] AS [ProductName], 
	[Extent2].[QuantityPerUnit] AS [QuantityPerUnit], 
	[Extent2].[ReorderLevel] AS [ReorderLevel], 
	[Extent2].[UnitPrice] AS [UnitPrice], 
	[Extent2].[UnitsInStock] AS [UnitsInStock], 
	[Extent2].[UnitsOnOrder] AS [UnitsOnOrder], 
	[Extent2].[CategoryID] AS [CategoryID], 
	[Extent2].[SupplierID] AS [SupplierID]
	FROM [dbo].[Products] AS [Extent2]) AS [Except1] 
*/