﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Data.Objects;
using System.Data.Objects.DataClasses;
using System.Data;

using VS2008SP1.Business;

public partial class EntityFramework_ObjectContext2 : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            // 演示事务的 Demo
            Demo();

            result.InnerHtml += "<br />";

            // 演示并发的 Demo
            Demo2();
        }
    }

    private void Demo()
    {
        // ObjectContext - SaveChanges 中的逻辑会自动做事务处理

        // 通吃的事务处理
        // using (System.Transactions.TransactionScope tc = new TransactionScope())
        // {
        //     code
        //     tc.Complete(); 
        // }

        // 同一 ObjectContext 的多个 SaveChanges() 的事务处理
        using (var ctx = new NorthwindEntities())
        {
            Region region = Region.CreateRegion("Test", 101);
            ctx.AddToRegion(region);

            if (ctx.Connection.State != ConnectionState.Open)
            {
                ctx.Connection.Open();
            }

            // 开始一个事务
            System.Data.Common.DbTransaction tran = ctx.Connection.BeginTransaction();

            // 第一次对数据的操作
            ctx.SaveChanges();

            try
            {
                Region region2 = Region.CreateRegion("Test2", 101);
                ctx.AddToRegion(region2);
                // 第二次对数据库的操作
                ctx.SaveChanges();

                // 提交事务（第一次插入主键为 101 的记录，成功；第二次再次插入主键为 101 的记录，失败。所以此处会报错）
                tran.Commit();
            }
            catch (Exception)
            {
                result.InnerHtml += "回滚" + "<br />";

                // 回滚事务（第一次插入成功的主键为 101 的记录会被删除）
                tran.Rollback();
            }
        }
    }

    private void Demo2()
    {
        var ctx = new NorthwindEntities();
        var ctx2 = new NorthwindEntities();

        var region = ctx.Region.First();
        var region2 = ctx2.Region.First();

        // 需要做并发处理的字段，要将其“并发模式”属性设置为 Fixed
        region.RegionDescription = "Eastern" + Guid.NewGuid().ToString();
        region2.RegionDescription = "Eastern" + Guid.NewGuid().ToString();

        ctx.SaveChanges();

        try
        {
            // ctx 已经修改了 Region 的 RegionDescription 属性
            // ctx2 再次修改 Region 的 RegionDescription 属性，由于 RegionDescription 在 ctx2 读取之后发生了变化，所以会出现乐观并发（Optimistic Concurrency）问题
            ctx2.SaveChanges();
        }
        catch (System.Data.OptimisticConcurrencyException)
        {
            result.InnerHtml += "OptimisticConcurrencyException" + "<br />";

            // ObjectContext.Refresh(RefreshMode refreshMode, object entity) - 更新上下文数据
            //     RefreshMode.StoreWins - 以数据库中的值为准
            //     RefreshMode.ClientWins - 以当前数据为准
            //     object entity - 需要刷新上下文数据的实体
            ctx2.Refresh(RefreshMode.StoreWins, region2);
            // ctx2.Refresh(RefreshMode.ClientWins, region2);

            ctx2.SaveChanges();
        }

        // 可以不通过 try catch 处理并发，而是通过 Refresh() 直接处理更新逻辑
        // 即若是 RefreshMode.ClientWins 则永远以当前值为准；若是 RefreshMode.StoreWins 则永远以数据库中的值为准（不会更新数据）
        // ctx2.Refresh(RefreshMode.StoreWins, region2);
        // ctx2.SaveChanges();

        ctx.Dispose();
        ctx2.Dispose();
    }
}