﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Data.Objects;
using System.Data.Objects.DataClasses;
using System.Data.EntityClient;
using System.Data;
using System.Data.Common;

using VS2008SP1.Business;

public partial class EntityFramework_ObjectQuery : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            Demo();

            result.InnerHtml += "<br />";

            Demo2();

            result.InnerHtml += "<br />";

            Demo3();

            result.InnerHtml += "<br />";

            Demo4();
        }
    }

    private void Demo()
    {
        using (var ctx = new NorthwindEntities())
        {
            string esql = "select value c from NorthwindEntities.Categories as c";

            // ObjectQuery<T> - 通过 Entity SQL 或 查询语法 或 Linq 方法对概念模型做查询
            // ObjectContext.CreateQuery<T>(Entity SQL) - 根据 esql 创建一个 ObjectQuery<T> 。（延迟）
            ObjectQuery<Categories> query = ctx.CreateQuery<Categories>(esql);

            foreach (var c in query)
            {
                result.InnerHtml += c.CategoryName + "<br />";
            }
        }

        /*
        SELECT 
        [Extent1].[CategoryID] AS [CategoryID], 
        [Extent1].[CategoryName] AS [CategoryName], 
        [Extent1].[Description] AS [Description], 
        [Extent1].[Picture] AS [Picture]
        FROM [dbo].[Categories] AS [Extent1]
        */
    }

    private void Demo2()
    {
        using (var ctx = new NorthwindEntities())
        {
            string esql = "select c.CategoryName from NorthwindEntities.Categories as c";

            // ObjectQuery<T>()构造函数 - 根据 esql 创建一个 ObjectQuery ，返回 DbDataRecord 。（延迟）
            // System.Data.Objects.MergeOption枚举 - 如何将此次查询结果与之前同一 ObjectContext 的存在与内存的查询结果做合并
            //     MergeOption.AppendOnly - 追加。默认值
            //     MergeOption.OverwriteChanges - 以新结果为准
            //     MergeOption.PreserveChanges - 以原结果为准
            //     MergeOption.NoTracking - 取消变更跟踪，不会使用 ObjectStateManager，减少执行查询的时间，所有返回的实体将是分离的状态（detached state）
            ObjectQuery<DbDataRecord> query = new ObjectQuery<DbDataRecord>(esql, ctx, MergeOption.NoTracking);

            // 可以在 ObjectQuery<T> 上使用 Linq 方法或查询语法
            foreach (DbDataRecord item in query.Take(3))
            {
                result.InnerHtml += item["CategoryName"].ToString() + "<br />";
            }
        }

        /*
        SELECT 
        [Limit1].[C1] AS [C1], 
        [Limit1].[CategoryName] AS [CategoryName]
        FROM ( SELECT TOP (3) 
	        [Extent1].[CategoryName] AS [CategoryName], 
	        1 AS [C1]
	        FROM [dbo].[Categories] AS [Extent1]
        )  AS [Limit1]
        */
    }

    private void Demo3()
    {
        using (var ctx = new NorthwindEntities())
        {
            string esql = "select value count(c.CategoryID) from NorthwindEntities.Categories as c";

            // ObjectQuery<简单类型> 的示例（延迟）
            ObjectQuery<int> query = ctx.CreateQuery<int>(esql);

            result.InnerHtml += query.First().ToString() + "<br />";
        }

        /*
        SELECT 
        [Limit1].[A1] AS [C1]
        FROM ( SELECT TOP (1) 
	        COUNT([Extent1].[CategoryID]) AS [A1]
	        FROM [dbo].[Categories] AS [Extent1]
        )  AS [Limit1] 
        */
    }

    private void Demo4()
    {
        using (var ctx = new NorthwindEntities())
        {
            string esql = "select value c from NorthwindEntities.Categories as c";
            
            // 延迟
            ObjectQuery<Categories> query = ctx.CreateQuery<Categories>(esql);

            // ObjectQuery<T>.Execute() - 立即执行查询。返回 ObjectResult<T>
            ObjectResult<Categories> queryResult = query.Execute(MergeOption.NoTracking);

            foreach (var c in queryResult)
            {
                result.InnerHtml += c.CategoryName + "<br />";
            }
        }

        /*
        SELECT 
        [Extent1].[CategoryID] AS [CategoryID], 
        [Extent1].[CategoryName] AS [CategoryName], 
        [Extent1].[Description] AS [Description], 
        [Extent1].[Picture] AS [Picture]
        FROM [dbo].[Categories] AS [Extent1] 
        */
    }
}