﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;
using System.Text;
using ImageWaterMark;

public partial class WaterMarkDemo : System.Web.UI.Page
{
    WmConfig wc = new WmConfig();

    WaterMark wm = new WaterMark();

    
    string fpath, ftype, fname, dot;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            colorloading();
            loadconfig();

        }
    }
    private void loadconfig()
    {
        rbwatermarktype.SelectedValue = wc.XMLRead("WMType");
        ddlAlignMode.SelectedValue = wc.XMLRead("AlignMode");
        tbtransparence.Text = wc.XMLRead("Transparence");
        tbangle.Text = wc.XMLRead("Angle");
        tbPlaceX.Text = wc.XMLRead("PlaceX");
        tbPlaceY.Text = wc.XMLRead("PlaceY");
        tbwatermarktext.Text = wc.XMLRead("WMText");
        ddlfont.SelectedValue = wc.XMLRead("Font");
        tbFontSize.Text = wc.XMLRead("FontSize");
        tbFontColor.Text = wc.XMLRead("FontColor");//颜色
        ddlFontstyle.SelectedValue = wc.XMLRead("FontStyle");
        if (wc.XMLRead("Vertical")=="true")
           ckvertical.Checked = true;
       if (wc.XMLRead("EmBossReinfor") == "true")
           ckEmBossReinfor.Checked = true;
       if (wc.XMLRead("SolidFretwork") == "true")
           ckSolidFretwork.Checked = true;
       if (wc.XMLRead("Shadow") == "true")
           ckshadow.Checked = true;
       ddltextstyle.SelectedValue = wc.XMLRead("TextStyle");
       ddlembossoffset.SelectedValue = wc.XMLRead("EmBossOffset");
       ddlSolidoffset.SelectedValue = wc.XMLRead("SolidOffset");
       ddlembossstyle.SelectedValue = wc.XMLRead("EmBossStyle");
       tbSoliddepth.Text = wc.XMLRead("SolidDepth");
       tbsoliddensity.Text = wc.XMLRead("SolidDensity");
       tbtextborder.Text = wc.XMLRead("TextBorderWidth");
       tbbordercolor.Text = wc.XMLRead("BorderColor");//颜色
       tbtextShadowcolor.Text = wc.XMLRead("ShadowColor");//颜色
       tbtxtshadowtransparence.Text = wc.XMLRead("ShadowTransparence");
       tbShadowX.Text = wc.XMLRead("ShadowX");
       tbShadowY.Text = wc.XMLRead("ShadowY");
       tblogopath.Text = wc.XMLRead("LogoPath");
       tbimagegroundcolor.Text = wc.XMLRead("GroundColor");//颜色
       ddledittype.SelectedValue = wc.XMLRead("EditType");
       ddlImgXY.SelectedValue = wc.XMLRead("ImgXY");
       if (wc.XMLRead("ImgCut") == "true")
           ckimgcut.Checked = true;
       tbcutX.Text = wc.XMLRead("CutX");
       tbcutY.Text = wc.XMLRead("CutY");
       tbcutWidth.Text = wc.XMLRead("CutWidth");
       tbcutHeight.Text = wc.XMLRead("CutHeight");
       tbContrast.Text = wc.XMLRead("Contrast");
       if (wc.XMLRead("Mos") == "true")
           ckmos.Checked = true;
       tbmosgranule.Text = wc.XMLRead("MosGranule");
       tbmosX.Text = wc.XMLRead("MosX");
       tbmosY.Text = wc.XMLRead("MosY");
       tbmoswidth.Text = wc.XMLRead("MosWidth");
       tbmosheight.Text = wc.XMLRead("MosHeight");
       tbBrightness.Text = wc.XMLRead("Brightness");
       tb_RGBValue1.Text = wc.XMLRead("RGBValue1");
       tb_RGBValue2.Text = wc.XMLRead("RGBValue2");
       tb_RGBValue3.Text = wc.XMLRead("RGBValue3");
       if (wc.XMLRead("Miniature") == "true")
           ckMiniature.Checked = true;
       if (wc.XMLRead("DelSourceImg") == "true")
           ckdelsourceimg.Checked = true;
       tbimagequality.Text = wc.XMLRead("ImageQuality");
       tbminwidth.Text = wc.XMLRead("MinWidth");
       tbminheight.Text = wc.XMLRead("MinHeight");
       tbminpath.Text = wc.XMLRead("MinPath");
       ddlimgtype.SelectedValue = wc.XMLRead("ImgType");
       tbsavepath.Text = wc.XMLRead("SavePath");
       tbimgwidth.Text = wc.XMLRead("ImgWidth");
       tbimgheight.Text = wc.XMLRead("ImgHeight");
       tbvspace.Text = wc.XMLRead("VSpace");
       tbLineSpace.Text = wc.XMLRead("LineSpace");
       if (wc.XMLRead("WaterMarkTile") == "true")
           ckWaterMarkTile.Checked = true;
       if (wc.XMLRead("ImgBorder") == "true")
           ckimgborder.Checked = true;
       tbimgbordercolor.Text = wc.XMLRead("ImgBorderColor");//颜色
       tbimgborderwidth.Text = wc.XMLRead("ImgBorderWidth");
       tbimgbordertran.Text = wc.XMLRead("ImgBorderTran");
       ddltilemode.SelectedValue = wc.XMLRead("TileMode");

    
    }

    private void colorloading()
    {
        tbFontColor.BackColor = System.Drawing.ColorTranslator.FromHtml(wc.XMLRead("FontColor"));
        tbFontColor.ForeColor = System.Drawing.ColorTranslator.FromHtml(wc.XMLRead("FontColor"));
        tbbordercolor.BackColor = System.Drawing.ColorTranslator.FromHtml(wc.XMLRead("BorderColor"));
        tbbordercolor.ForeColor = System.Drawing.ColorTranslator.FromHtml(wc.XMLRead("BorderColor"));
        tbtextShadowcolor.BackColor = System.Drawing.ColorTranslator.FromHtml(wc.XMLRead("ShadowColor"));
        tbtextShadowcolor.ForeColor = System.Drawing.ColorTranslator.FromHtml(wc.XMLRead("ShadowColor"));
        tbimagegroundcolor.BackColor = System.Drawing.ColorTranslator.FromHtml(wc.XMLRead("GroundColor"));
        tbimagegroundcolor.ForeColor = System.Drawing.ColorTranslator.FromHtml(wc.XMLRead("GroundColor"));
        tbimgbordercolor.BackColor = System.Drawing.ColorTranslator.FromHtml(wc.XMLRead("ImgBorderColor"));
        tbimgbordercolor.ForeColor = System.Drawing.ColorTranslator.FromHtml(wc.XMLRead("ImgBorderColor"));

    }

    private void SaveConfig()
    {
        string ckvertical0 = "", ckEmBossReinfor0 = "", ckSolidFretwork0 = "", ckshadow0 = "", ckimgcut0 = "", ckmos0 = "", ckMiniature0 = "", ckdelsourceimg0 = "", ckWaterMarkTile0 = "", ckimgborder0 = "";
        if (ckvertical.Checked == true)
            ckvertical0 = "true";
        else
            ckvertical0 = "false";

        if (ckEmBossReinfor.Checked == true)
            ckEmBossReinfor0 = "true";
        else
            ckEmBossReinfor0 = "false";

        if (ckSolidFretwork.Checked == true)
            ckSolidFretwork0 = "true";
        else
            ckSolidFretwork0 = "false";

        if (ckshadow.Checked == true)
            ckshadow0 = "true";
        else
            ckshadow0 = "false";

        if (ckimgcut.Checked == true)
            ckimgcut0 = "true";
        else
            ckimgcut0 = "false";

        if (ckmos.Checked == true)
            ckmos0 = "true";
        else
            ckmos0 = "false";

        if (ckMiniature.Checked == true)
            ckMiniature0 = "true";
        else
            ckMiniature0 = "false";

        if (ckdelsourceimg.Checked == true)
            ckdelsourceimg0 = "true";
        else
            ckdelsourceimg0 = "false";

        if (ckWaterMarkTile.Checked == true)
            ckWaterMarkTile0 = "true";
        else
            ckWaterMarkTile0 = "false";

        if (ckimgborder.Checked == true)
            ckimgborder0 = "true";
        else
            ckimgborder0 = "false";

        wc.CreateXML(rbwatermarktype.SelectedValue, ddlAlignMode.SelectedValue, tbtransparence.Text, tbangle.Text,tbPlaceX.Text,tbPlaceY.Text,tbwatermarktext.Text,
           ddlfont.SelectedValue, tbFontSize.Text, tbFontColor.Text, ddlFontstyle.SelectedValue, ckvertical0, ckEmBossReinfor0, ckSolidFretwork0, ckshadow0, ddltextstyle.SelectedValue,
           ddlembossoffset.SelectedValue, ddlSolidoffset.SelectedValue, ddlembossstyle.SelectedValue, tbSoliddepth.Text, tbsoliddensity.Text, tbtextborder.Text, tbbordercolor.Text,
           tbtextShadowcolor.Text, tbtxtshadowtransparence.Text, tbShadowX.Text, tbShadowY.Text, tblogopath.Text, tbimagegroundcolor.Text, ddledittype.SelectedValue, ddlImgXY.SelectedValue,
           ckimgcut0, tbcutX.Text,tbcutY.Text,tbcutWidth.Text,tbcutHeight.Text,tbContrast.Text,ckmos0,tbmosgranule.Text,tbmosX.Text,tbmosY.Text,tbmoswidth.Text,tbmosheight.Text,tbBrightness.Text,tb_RGBValue1.Text,tb_RGBValue2.Text,
           tb_RGBValue3.Text,ckMiniature0,ckdelsourceimg0,tbimagequality.Text,tbminwidth.Text,tbminheight.Text,tbminpath.Text,ddlimgtype.SelectedValue,tbsavepath.Text,tbimgwidth.Text,tbimgheight.Text,
           tbvspace.Text,tbLineSpace.Text,ckWaterMarkTile0,ckimgborder0,tbimgbordercolor.Text,tbimgborderwidth.Text,tbimgbordertran.Text,ddltilemode.SelectedValue);
        colorloading();

    }

    private void CreateImage(string SourcePath)
    {
        wm.SourceImagePath = new string[] { SourcePath };//设置原图像路径

        //wm.SourceImagePath = FileNames("CollectImg/"); //批处理

        #region 公共属性配置
        WaterMark.WaterMarkType wmtype;
        if (wc.XMLRead("WMType") == "Text")
            wmtype = WaterMark.WaterMarkType.Text;
        else if (wc.XMLRead("WMType") == "Logo")
            wmtype = WaterMark.WaterMarkType.Logo;
        else
            wmtype = WaterMark.WaterMarkType.None;

        switch (wc.XMLRead("AlignMode"))//控制水印在图像上的位置
        {
            case "LeftBottom":
                wm.WaterMarkAlign = WaterMark.WaterMarkAlignMode.LeftBottom;
                break;
            case "Center":
                wm.WaterMarkAlign = WaterMark.WaterMarkAlignMode.Center;
                break;
            case "RightTop":
                wm.WaterMarkAlign = WaterMark.WaterMarkAlignMode.RightTop;
                break;
            case "RightBottom":
                wm.WaterMarkAlign = WaterMark.WaterMarkAlignMode.RightBottom;
                break;
            case "CenterTop":
                wm.WaterMarkAlign = WaterMark.WaterMarkAlignMode.CenterTop;
                break;
            case "CenterBottom":
                wm.WaterMarkAlign = WaterMark.WaterMarkAlignMode.CenterBottom;
                break;
            case "CenterLeft":
                wm.WaterMarkAlign = WaterMark.WaterMarkAlignMode.CenterLeft;
                break;
            case "CenterRight":
                wm.WaterMarkAlign = WaterMark.WaterMarkAlignMode.CenterRight;
                break;
            default:
                wm.WaterMarkAlign = WaterMark.WaterMarkAlignMode.LeftTop;
                break;
        }
        wm.WaterMarkTransparence = Convert.ToInt32(wc.XMLRead("Transparence"));
        wm.WaterMarkAngle = Convert.ToInt32(wc.XMLRead("Angle"));
        wm.WaterMarkPlaceX = Convert.ToInt32(wc.XMLRead("PlaceX"));
        wm.WaterMarkPlaceY = Convert.ToInt32(wc.XMLRead("PlaceY"));
        #endregion

        #region 文字水印基本配置

        wm.WaterMarkText = wc.XMLRead("WMText");
        wm.TextFont = wc.XMLRead("Font");
        wm.TextColor = wc.XMLRead("FontColor");
        wm.TextSize = Convert.ToInt32(wc.XMLRead("FontSize"));
        switch (wc.XMLRead("FontStyle"))
        {
            case "Bold":
                wm.WaterMarkTextStyle = WaterMark.TextStyle.Bold;
                break;
            case "Italic":
                wm.WaterMarkTextStyle = WaterMark.TextStyle.Italic;
                break;
            case "Underline":
                wm.WaterMarkTextStyle = WaterMark.TextStyle.Underline;
                break;
            case "Strikeout":
                wm.WaterMarkTextStyle = WaterMark.TextStyle.Strikeout;
                break;
           
        }
        
        wm.Vertical = Convert.ToBoolean(wc.XMLRead("Vertical"));
        wm.TextShadow = Convert.ToBoolean(wc.XMLRead("Shadow"));
        wm.TextShadowColor = wc.XMLRead("ShadowColor");
        wm.TxTShadowTransparence = Convert.ToInt32(wc.XMLRead("ShadowTransparence"));
        wm.TextShadowDepthX = Convert.ToInt32(wc.XMLRead("ShadowX"));
        wm.TextShadowDepthY = Convert.ToInt32(wc.XMLRead("ShadowY"));
      


        #endregion

        #region 文字水印高级配置

        switch (wc.XMLRead("TextStyle"))//设置文字水印类型
        {

            case "DrawBound":
                wm.WaterMarkTextEffect = WaterMark.TextType.DrawBound;
                break;
            case "textSolid":
                wm.WaterMarkTextEffect = WaterMark.TextType.TextSolid;
                break;
            case "Emboss":
                wm.WaterMarkTextEffect = WaterMark.TextType.TextEmBoss;
                break;
            default:
                wm.WaterMarkTextEffect = WaterMark.TextType.Ordinary;
                break;
        }
        switch (wc.XMLRead("EmBossOffset"))//设置浮雕偏移方向
        {
            case "LeftTop":
                wm.EmBossOffsetMode = WaterMark.EmBossOffset.EmBossOffsetLeftTop;
                break;
            case "LeftBottom":
                break;
                wm.EmBossOffsetMode = WaterMark.EmBossOffset.EmBossOffsetLeftBottom;
                break;
            case "RightTop":
                wm.EmBossOffsetMode = WaterMark.EmBossOffset.EmBossOffsetRightTop;
                break;
            default:
                wm.EmBossOffsetMode = WaterMark.EmBossOffset.EmBossOffsetRightBottom;
                break;
        }
        switch (wc.XMLRead("SolidOffset"))//设置立体侧面偏移方向
        {
            case "LeftTop":
                wm.SolidOffsetMode = WaterMark.SolidOffset.SolidOffsetLeftTop;
                break;
            case "LeftBottom":
                wm.SolidOffsetMode = WaterMark.SolidOffset.SolidOffsetLeftBottom;
                break;
            case "RightBottom":
                wm.SolidOffsetMode = WaterMark.SolidOffset.SolidOffsetRightBottom;
                break;
            default:
                wm.SolidOffsetMode = WaterMark.SolidOffset.SolidOffsetRightTop;
                break;
        }
        switch (wc.XMLRead("EmBossStyle"))//设置浮雕样式
        {
            case "engrave":
                wm.EmBossStyle = WaterMark.TextEmBossStyle.Engrave;
                break;
            case "hollow":
                wm.EmBossStyle = WaterMark.TextEmBossStyle.Hollow;
                break;
            default:
                wm.EmBossStyle = WaterMark.TextEmBossStyle.Convexity;
                break;
        }

        wm.EmBossReinfor = Convert.ToBoolean(wc.XMLRead("EmBossReinfor"));
        wm.SolidFretwork = Convert.ToBoolean(wc.XMLRead("SolidFretwork"));
        wm.SolidDepth = Convert.ToInt32(wc.XMLRead("SolidDepth"));
        wm.SolidDensity = Convert.ToInt32(wc.XMLRead("SolidDensity"));
        wm.TextBorderWidth = Convert.ToInt32(wc.XMLRead("TextBorderWidth"));
        wm.TextBorderColor = wc.XMLRead("BorderColor");

        #endregion

        #region 图像编辑

        switch (wc.XMLRead("EditType"))//图像处理
        {
            case "Monochrome":
                wm.SetImgEffect = WaterMark.ImageEffect.Monochrome;
                break;
            case "Negative":
                wm.SetImgEffect = WaterMark.ImageEffect.Negative;
                break;
            case "Brightness":
                wm.SetImgEffect = WaterMark.ImageEffect.Brightness;
                wm.Brightness = Convert.ToInt32(wc.XMLRead("Brightness"));
                break;
            case "Contrast":
                wm.SetImgEffect = WaterMark.ImageEffect.Contrast;
                wm.Contrast = Convert.ToInt32(wc.XMLRead("Contrast"));
                break;
            case "RGBValue":
                wm.SetImgEffect = WaterMark.ImageEffect.RGBValue;
                wm.RValue = Convert.ToInt32(wc.XMLRead("RGBValue1"));
                wm.GValue = Convert.ToInt32(wc.XMLRead("RGBValue2"));
                wm.BValue = Convert.ToInt32(wc.XMLRead("RGBValue3"));
                break;

        }
        switch (wc.XMLRead("ImgXY"))//设置原图像旋转或翻转
        {
            case "s90":
                wm.ImageRotate = WaterMark.RotateFlip.Clockwise90;
                break;
            case "n90":
                wm.ImageRotate = WaterMark.RotateFlip.Anticlockwise90;
                break;
            case "180":
                wm.ImageRotate = WaterMark.RotateFlip.Rotate180;
                break;
            case "rX":
                wm.ImageRotate = WaterMark.RotateFlip.FlipX;
                break;
            case "rY":
                wm.ImageRotate = WaterMark.RotateFlip.FlipY;
                break;
            case "rXY":
                wm.ImageRotate = WaterMark.RotateFlip.FlipXY;
                break;


        }

        wm.CutX = Convert.ToInt32(wc.XMLRead("CutX"));
        wm.CutY = Convert.ToInt32(wc.XMLRead("CutY"));
        wm.CutWidth = Convert.ToInt32(wc.XMLRead("CutWidth"));
        wm.CutHeight = Convert.ToInt32(wc.XMLRead("CutHeight"));
        wm.MosGranule = Convert.ToInt32(wc.XMLRead("MosGranule"));
        wm.MosX = Convert.ToInt32(wc.XMLRead("MosX"));
        wm.MosY = Convert.ToInt32(wc.XMLRead("MosY"));
        wm.MosWidth = Convert.ToInt32(wc.XMLRead("MosWidth"));
        wm.MosHeight = Convert.ToInt32(wc.XMLRead("MosHeight"));

        #endregion

        #region 综合设置

        wm.DelSourceImg = Convert.ToBoolean(wc.XMLRead("DelSourceImg"));
        wm.ImageQuality = Convert.ToInt32(wc.XMLRead("ImageQuality"));
        wm.MiniatureImagePath = wc.XMLRead("MinPath");
        wm.SaveWaterMarkImagePath = wc.XMLRead("SavePath");
        wm.WaterMarkTile = Convert.ToBoolean(wc.XMLRead("WaterMarkTile"));
        wm.VerticalSpace = Convert.ToInt32(wc.XMLRead("VSpace"));
        wm.LineSpace = Convert.ToInt32(wc.XMLRead("LineSpace"));
        wm.ImageBorder = Convert.ToBoolean(wc.XMLRead("ImgBorder"));
        wm.ImageBorderColor = wc.XMLRead("ImgBorderColor");
        wm.ImageBorderWidth = Convert.ToInt32(wc.XMLRead("ImgBorderWidth"));
        wm.ImageBorderTransparence = Convert.ToInt32(wc.XMLRead("ImgBorderTran"));
        wm.WaterMarkImagePath = wc.XMLRead("LogoPath");
        wm.WaterMarkImageGroundColor = wc.XMLRead("GroundColor");
        switch (wc.XMLRead("ImgType"))//设置生成图像类型
        {
            case "Jpg":
                wm.ImgType = WaterMark.ImageType.Jpg;
                break;
            case "Bmp":
                wm.ImgType = WaterMark.ImageType.Bmp;
                break;
            case "Png":
                wm.ImgType = WaterMark.ImageType.Png;
                break;
            case "Gif":
                wm.ImgType = WaterMark.ImageType.Gif;
                break;
            default:
                wm.ImgType = WaterMark.ImageType.None;
                break;
        }

        if (wc.XMLRead("TileMode") == "AlignTiled")
            wm.WaterMarkTileMode = WaterMark.TiledMode.AlignTiled;

        #endregion

        //生成水印图像
        wm.GetToWaterMarkImage(wmtype, Convert.ToInt32(wc.XMLRead("ImgWidth")), Convert.ToInt32(wc.XMLRead("ImgHeight")), Convert.ToBoolean(wc.XMLRead("Miniature")), Convert.ToInt32(wc.XMLRead("MinWidth")), Convert.ToInt32(wc.XMLRead("MinHeight")), Convert.ToBoolean(wc.XMLRead("ImgCut")), Convert.ToBoolean(wc.XMLRead("Mos")));
        photoshow.Text = "<img src=" + wm.Wfpath + "  />";//获取水印图片路径,另一个参数是Mfpath为返回缩略图路径

        TextBox1.Text = wm.WBatchPath;//由于不好演示，只有获取完整地址串；

    }

    protected void saveconfig_Click(object sender, EventArgs e)
    {
        try
        {
            SaveConfig();
            Alert("保存成功!");
        }
        catch
        {
            Alert("保存失败!");
        }
    }

    protected void uploadfile_Click(object sender, EventArgs e)
    {
        fname = FileUpload1.FileName;
        fpath = FileUpload1.PostedFile.FileName;
        ftype = FileUpload1.PostedFile.ContentType;
        if (fname.Length < 1)
        {
            Alert("上传路径不能为空！");
        }
        else
        {
            string[] type = ftype.Split('/');
            string[] fn = fname.Split('.');
            dot = "." + fn[1].ToString();
            if (type[0].ToString() != "image")
            {
                Response.Write("文件格式错误！");
            }
            else
            {
                string filename = DateTime.Now.ToString("yyyyMMddHHmmssffff");
                string pt = "UploadFiles/" + filename + dot;

                FileUpload1.SaveAs(Server.MapPath(pt));
                FileUpload1.Dispose();
                CreateImage(pt);//创建水印图片
            }
        }
    }

    #region 遍历文件夹做批量处理

    private string[] FileNames(string folder)
    {
        string[] fname = new string[] { "" };
        DirectoryInfo Dir = new DirectoryInfo(HttpContext.Current.Server.MapPath(folder));

        if (Dir.Exists)
        {
            FileSystemInfo[] files = Dir.GetFileSystemInfos();
            string filestr = string.Empty;
            string classfile = files[0].ToString().Substring(files[0].ToString().LastIndexOf(".")).ToLower();

            for (int i = 0; i < files.Length; i++)
            {
                if (classfile == ".jpg" || classfile == ".gif" || classfile == ".bmp" || classfile == ".png")
                {
                    filestr += folder + files[i].ToString() + "|";
                }

            }

            fname = filestr.Substring(0,filestr.Length-1).Split('|');
        }
        return fname;
    }
    #endregion

    private void Alert(string msg)
    {
        this.ClientScript.RegisterStartupScript(this.GetType(), "alert", "<script language=\"javascript\">alert('" + msg + "');</script>");
    }
}
