using System;
using System.Web;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using HouseSystem.Modal;
using System.Web.UI;

namespace HouseSystem.Components
{
	/// <summary>
	/// Tools ժҪ˵
	/// </summary>
	public class Tools
	{
		// Fields
		public const string LOGININFOLOST = "󣬽ϵͳ";
		public const string UNKNOWERROR = "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01";
		public const string URLERROR = "볢Դȷӽϵͳ";
		public const string URLERRORJS = "<script>alert('볢Դȷӽϵͳ');</script>";
		
		public static string CheckInputSubStr(string theString, int length)
		{
			if (theString.Length == 0)
			{
				return "";
			}
			if (theString.Length >= length)
			{
				return theString.Substring(0, length).Replace("'", "''");
			}
			return theString.Replace("'", "''");
		}
 
		public static string CheckStrInput(string theString)
		{
			if (theString.Length == 0)
			{
				return "";
			}
			return theString.Replace("'", "''").Replace("<script>", "\u300ascript\u300b").Replace("<SCRIPT", "\u300ascript").Replace("<script", "\u300ascript").Replace("</script>", "\u300a/script\u300b").Replace("</SCRIPT>", "\u300a/script\u300b");
		}
 
		public static string CheckStrOutput(string theString)
		{
			if (theString.Length == 0)
			{
				return "";
			}
			theString = theString.Replace(" ", "&nbsp;");
			theString = theString.Replace("\r", "<br>");
			theString = theString.Replace("\n", "");
			return theString;
		}
 
		public static string GetAdminCookie(string cookieName)
		{
			if (HttpContext.Current.Request.Cookies["WebdiyZjAdmin"] != null)
			{
				return HttpContext.Current.Request.Cookies["WebdiyZjAdmin"][cookieName];
			}
			return "";
		}
 
		public static string GetFooterHtml(string strFileName)
		{
			string text4;
			string text1 = "";
			string text2 = AppDomain.CurrentDomain.BaseDirectory.ToString() + "/News/Controls/" + strFileName;
			try
			{
				if (!File.Exists(text2))
				{
					return ("\u627e\u4e0d\u5230\u6587\u4ef6:" + text2);
				}
				using (StreamReader reader1 = new StreamReader(text2, Encoding.GetEncoding("gb2312")))
				{
					string text3;
					while ((text3 = reader1.ReadLine()) != null)
					{
						text1 = text1 + text3;
					}
					return text1;
				}
			}
			catch
			{
				text1 = "\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25!";
				text4 = text1;
			}
			return text4;
		}
 
		public static byte GetPerPageSize()
		{
			string text1 = System.Configuration.ConfigurationSettings.AppSettings["PerPageSize"].ToString();
			if ((text1 != null) && (text1 != string.Empty))
			{
				return byte.Parse(text1);
			}
			return 20;
		}
 
		public static string GetUserCookie(string cookieName)
		{
			if (HttpContext.Current.Request.Cookies["User"] != null)
			{
				return HttpContext.Current.Request.Cookies["User"][cookieName];
			}
			return "";
		}
 
		public static bool IsAdminLogin()
		{
			if (HttpContext.Current.Request.Cookies["WebdiyZjAdmin"] != null)
			{
				return true;
			}
			return false;
		}
 
		public static bool IsByte(string Value)
		{
			bool flag1;
			try
			{
				byte.Parse(Value);
				flag1 = true;
			}
			catch
			{
				flag1 = false;
			}
			return flag1;
		}
 
		public static bool IsInt(string Value)
		{
			bool flag1;
			try
			{
				int.Parse(Value);
				flag1 = true;
			}
			catch
			{
				flag1 = false;
			}
			return flag1;
		}
 
		public static bool IsLong(string Value)
		{
			bool flag1;
			try
			{
				long.Parse(Value);
				flag1 = true;
			}
			catch
			{
				flag1 = false;
			}
			return flag1;
		}
 
		public static bool IsUserLogin()
		{
			if (HttpContext.Current.Request.Cookies["User"] != null)
			{
				return true;
			}
			return false;
		}
 
		public static bool IsValidEmail(string strMail)
		{
			string text1 = @"^([\w-\.]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([\w-]+\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$";
			if (!Regex.IsMatch(strMail, text1, RegexOptions.IgnoreCase))
			{
				return false;
			}
			return true;
		}
 
		public static void Alert(string message, Page page)
		{
			page.RegisterStartupScript("", "<script>alert('" + message + "');</script>");
		}
 
		public static void Alert(string focusControlName, string message, Page page)
		{
			string[] textArray1 = new string[7] { "<script>alert('", message, "');document.forms(0).", focusControlName, ".focus(); document.forms(0).", focusControlName, ".select();</script>" } ;
			page.RegisterStartupScript("", string.Concat(textArray1));
		}
 
		public static void RemoveLoginInfo()
		{
			HttpContext.Current.Response.Cookies["User"].Expires = DateTime.Now.AddDays(-1);
		}
 
		public static void SetLoginInfo(UserInfo entity)
		{
			HttpContext.Current.Response.Cookies["User"]["UserId"] = entity.UserId.ToString();
			HttpContext.Current.Response.Cookies["User"]["UserName"] = entity.UserName;
			HttpContext.Current.Response.Cookies["User"]["Name"] = entity.Name;
			HttpContext.Current.Response.Cookies["User"]["Sex"] = entity.Sex.ToString();
			HttpContext.Current.Response.Cookies["User"]["Tel1"] = entity.Tel1;
			HttpContext.Current.Response.Cookies["User"]["Tel2"] = entity.Tel2;
			HttpContext.Current.Response.Cookies["User"]["Email"] = entity.Email;
			HttpContext.Current.Response.Cookies["User"]["LoginNum"] = entity.LoginNum.ToString();
			HttpContext.Current.Response.Cookies["User"].Expires = DateTime.Now.AddDays(1);
		}
 
	}
}
