using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using HouseSystem.Components;
using System.Configuration;
using HouseSystem.Modal;
namespace HouseSystem.UserCenter
{
	/// <summary>
	/// AddMyHouse ժҪ˵
	/// </summary>
	public class AddMyHouse : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.Label lblMsg;
		protected System.Web.UI.WebControls.DropDownList dropArea;
		protected System.Web.UI.WebControls.TextBox Addr;
		protected System.Web.UI.WebControls.DropDownList dropHouseType;
		protected System.Web.UI.WebControls.TextBox Floor1;
		protected System.Web.UI.WebControls.TextBox Floor2;
		protected System.Web.UI.WebControls.TextBox Square;
		protected System.Web.UI.WebControls.Label lblPrice1;
		protected System.Web.UI.WebControls.TextBox Price;
		protected System.Web.UI.WebControls.Label lblPrice2;
		protected System.Web.UI.WebControls.TextBox JTQK;
		protected System.Web.UI.WebControls.TextBox Other;
		protected System.Web.UI.WebControls.TextBox LinkMan;
		protected System.Web.UI.WebControls.TextBox Email;
		protected System.Web.UI.WebControls.TextBox Tel1;
		protected System.Web.UI.WebControls.TextBox Tel2;
		protected System.Web.UI.WebControls.Button btnSubmit;
		protected System.Web.UI.HtmlControls.HtmlSelect dropIsAgency;
		protected System.Web.UI.HtmlControls.HtmlSelect dropDirection;
		protected System.Web.UI.HtmlControls.HtmlSelect dropFYHX;
		protected System.Web.UI.HtmlControls.HtmlSelect dropZXQK;
		protected System.Web.UI.HtmlControls.HtmlSelect dropExpire;

		protected string WebName;
		protected string strType;


		private void Page_Load(object sender, System.EventArgs e)
		{
			// ڴ˴ûԳʼҳ
			this.WebName = ConfigurationSettings.AppSettings["My_WebName"];
			if (!this.Page.IsPostBack)
			{
				if (Tools.IsUserLogin()==false)
				{
					Response.Redirect("../login.aspx");
				}

				this.BindDrop();
				byte num1 = 1;
				if ((base.Request.QueryString["type"] == null) || (base.Request.QueryString["type"] == ""))
				{
					this.lblMsg.Text = "볢Դȷӽϵͳ";
				}
				else
				{
					num1 = byte.Parse(base.Request.QueryString["type"]);
					if (num1 == 1)
					{
						this.strType = "";
					}
					else
					{
						this.strType = "";
						this.lblPrice1.Text = "ۼ";
						this.lblPrice2.Text = "Ԫ";
					}
					if (Users.IsUserLogin())
					{
						this.LinkMan.Text = Tools.GetUserCookie("Name");
						this.Email.Text = Tools.GetUserCookie("Email");
						this.Tel1.Text = Tools.GetUserCookie("Tel1");
						this.Tel2.Text = Tools.GetUserCookie("Tel2");
					}
				}
			}

		}
		private void BindDrop()
		{
			//string ss="볢Դȷӽϵͳ";
			this.dropArea.DataSource = BindUI.GetAreaList();
			this.dropArea.DataTextField = "Area_Name";
			this.dropArea.DataValueField = "Area_ID";
			this.dropArea.DataBind();
			this.dropArea.Items.Insert(0, "ѡ...");
			this.dropArea.Items[0].Value = "0";
			this.dropHouseType.DataSource = BindUI.GetHouseTypeList();
			this.dropHouseType.DataTextField = "Ht_Name";
			this.dropHouseType.DataValueField = "Ht_ID";
			this.dropHouseType.DataBind();
			this.dropHouseType.Items.Insert(0, "ѡ...");
			this.dropHouseType.Items[0].Value = "0";
		}
 

		#region Web ɵĴ
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: õ ASP.NET Web ġ
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// ֧ķ - Ҫʹô༭޸
		/// ˷ݡ
		/// </summary>
		private void InitializeComponent()
		{    
			this.btnSubmit.Click += new System.EventHandler(this.btnSubmit_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void btnSubmit_Click(object sender, System.EventArgs e)
		{
			HouseInfo info1 = new HouseInfo();
			info1.Type = byte.Parse(base.Request.QueryString["type"]);
			info1.AreaID = int.Parse(this.dropArea.SelectedValue);
			info1.HtID = int.Parse(this.dropHouseType.SelectedValue);
			info1.IsAgency = byte.Parse(this.dropIsAgency.Value);
			info1.Addr = Tools.CheckInputSubStr(this.Addr.Text.Trim(), 100);
			try
			{
				info1.Square = (this.Square.Text.Trim() != string.Empty) ? int.Parse(this.Square.Text.Trim()) : 0;
				info1.Price = (this.Price.Text.Trim() != string.Empty) ? int.Parse(this.Price.Text.Trim()) : 0;
				info1.Floor1 = (this.Floor1.Text.Trim() != string.Empty) ? int.Parse(this.Floor1.Text.Trim()) : 0;
				info1.Floor2 = (this.Floor2.Text.Trim() != string.Empty) ? int.Parse(this.Floor2.Text.Trim()) : 0;
			}
			catch
			{
				this.lblMsg.Text = "ת";
				return;
			}
			info1.Direction = this.dropDirection.Value;
			info1.FYHX = this.dropFYHX.Value;
			info1.ZXQK = this.dropZXQK.Value;
			info1.JCSS = base.Request.Form["chkJCSS"];
			info1.PTSS = base.Request.Form["chkPTSS"];
			info1.JTQK = this.JTQK.Text.Trim();
			info1.Other = Tools.CheckInputSubStr(this.Other.Text, 500);
			info1.LinkMan = this.LinkMan.Text.Trim();
			info1.Tel1 = this.Tel1.Text.Trim();
			info1.Tel2 = this.Tel2.Text.Trim();
			info1.Email = this.Email.Text.Trim();
			info1.Expire = byte.Parse(this.dropExpire.Value);
			info1.IpAddr = base.Request.ServerVariables["REMOTE_ADDR"];
			string text1 = Tools.GetUserCookie("UserId");
			if ((text1 == "") || (text1 == null))
			{
				info1.UserID = 10;
			}
			else
			{
				info1.UserID = Convert.ToInt32(text1);
			}
			int num1 = RentSell.Add(info1);
			if (num1 > 0)
			{
				base.Response.Redirect("ok.aspx", false);
			}
			else
			{
				this.lblMsg.Text = "ʧܣԣ";
			}

		}
	}
}
