using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Configuration;
using HouseSystem.Components;

namespace HouseSystem.UserCenter
{
	/// <summary>
	/// MyRentSell ժҪ˵
	/// </summary>
	public class MyRentSell : System.Web.UI.Page
	{
		protected Label lblPageInfo;
		protected HyperLink lnkFirst;
		protected HyperLink lnkLast;
		protected HyperLink lnkNext;
		protected HyperLink lnkPrev;
		protected Repeater Repeater1;

		protected string WebName;

		private void Page_Load(object sender, System.EventArgs e)
		{
			// ڴ˴ûԳʼҳ
			this.WebName = ConfigurationSettings.AppSettings["My_WebName"];
			if (!this.Page.IsPostBack)
			{
				int num2;
				byte num1 = 20;
				string text1 = Tools.GetUserCookie("UserId");
				if (text1 == "")
				{
					base.Response.Redirect("/Login.aspx", false);
				}
				DataTable table1 = RentSell.GetHouseListByUserID(int.Parse(text1));
				PagedDataSource source1 = new PagedDataSource();
				source1.DataSource = table1.DefaultView;
				source1.AllowPaging = true;
				source1.PageSize = num1;
				if (base.Request.QueryString["Page"] != null)
				{
					num2 = Convert.ToInt32(base.Request.QueryString["Page"]);
				}
				else
				{
					num2 = 1;
				}
				source1.CurrentPageIndex = num2 - 1;
				object[] objArray1 = new object[4] { "ҳΣ", num2.ToString(), "/", source1.PageCount } ;
				this.lblPageInfo.Text = string.Concat(objArray1);
				if (source1.IsFirstPage)
				{
					this.lnkFirst.Enabled = false;
					this.lnkPrev.Enabled = false;
				}
				else
				{
					this.lnkFirst.Enabled = true;
					this.lnkPrev.Enabled = true;
					this.lnkFirst.NavigateUrl = base.Request.CurrentExecutionFilePath + "?Page=1";
					this.lnkPrev.NavigateUrl = base.Request.CurrentExecutionFilePath + "?Page=" + Convert.ToString((int) (num2 - 1));
				}
				if (source1.IsLastPage)
				{
					this.lnkNext.Enabled = false;
					this.lnkLast.Enabled = false;
				}
				else
				{
					this.lnkNext.Enabled = true;
					this.lnkLast.Enabled = true;
					this.lnkNext.NavigateUrl = base.Request.CurrentExecutionFilePath + "?Page=" + Convert.ToString((int) (num2 + 1));
					this.lnkLast.NavigateUrl = base.Request.CurrentExecutionFilePath + "?Page=" + Convert.ToString(source1.PageCount);
				}
				this.Repeater1.DataSource = source1;
				this.Repeater1.DataBind();
			}
		}

		

		public string GetAreaName(int Area_ID)
		{
			return Area.GetAreaNameByID(Area_ID);
		}
 
		public string GetHouseType(int Ht_ID)
		{
			return HouseType.GetHouseTypeByID(Ht_ID);
		}
 
		public string GetInfoType(byte type)
		{
			if (type == 1)
			{
				return "<font color='blue'>Ϣ</font>";
			}
			if (type == 2)
			{
				return "<font color='red'>Ϣ</font>";
			}
			return "";
		}
 

		#region Web ɵĴ
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: õ ASP.NET Web ġ
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// ֧ķ - Ҫʹô༭޸
		/// ˷ݡ
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);
		}
		#endregion
	}
}
