using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Configuration;
using HouseSystem.Components;
using HouseSystem.Modal;

namespace HouseSystem.UserCenter
{
	/// <summary>
	/// UpdateMyRsInfo ժҪ˵
	/// </summary>
	public class UpdateMyRsInfo : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.Label lblMsg;
		protected System.Web.UI.WebControls.DropDownList dropArea;
		protected System.Web.UI.WebControls.TextBox Addr;
		protected System.Web.UI.WebControls.DropDownList dropHouseType;
		protected System.Web.UI.WebControls.TextBox Floor1;
		protected System.Web.UI.WebControls.TextBox Floor2;
		protected System.Web.UI.WebControls.TextBox Square;
		protected System.Web.UI.WebControls.Label lblPrice1;
		protected System.Web.UI.WebControls.TextBox Price;
		protected System.Web.UI.WebControls.Label lblPrice2;
		protected System.Web.UI.WebControls.CheckBoxList cblJCSS;
		protected System.Web.UI.WebControls.CheckBoxList cblPTSS;
		protected System.Web.UI.WebControls.TextBox JTQK;
		protected System.Web.UI.WebControls.TextBox Other;
		protected System.Web.UI.WebControls.TextBox LinkMan;
		protected System.Web.UI.WebControls.TextBox Email;
		protected System.Web.UI.WebControls.TextBox Tel1;
		protected System.Web.UI.WebControls.TextBox Tel2;
		protected System.Web.UI.WebControls.Button btnSubmit;
		protected System.Web.UI.HtmlControls.HtmlSelect dropIsAgency;
		protected System.Web.UI.HtmlControls.HtmlSelect dropDirection;
		protected System.Web.UI.HtmlControls.HtmlSelect dropFYHX;
		protected System.Web.UI.HtmlControls.HtmlSelect dropZXQK;
		protected System.Web.UI.HtmlControls.HtmlSelect dropExpire;
		protected string strType;
		protected string WebName;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			// ڴ˴ûԳʼҳ
			this.WebName = ConfigurationSettings.AppSettings["My_WebName"];
			if (!this.Page.IsPostBack)
			{
				this.BindDrop();
				byte num1 = 1;
				if ((base.Request.QueryString["type"] == null) || (base.Request.QueryString["type"] == ""))
				{
					this.lblMsg.Text = "볢Դȷӽϵͳ";
				}
				else
				{
					num1 = byte.Parse(base.Request.QueryString["type"]);
					int num2 = int.Parse(base.Request.QueryString["ID"]);
					if (num1 == 1)
					{
						this.strType = "";
					}
					else
					{
						this.strType = "";
						this.lblPrice1.Text = "ۼ";
						this.lblPrice2.Text = "Ԫ";
					}
					string text1 = Tools.GetUserCookie("UserId");
					if (text1 == "")
					{
						base.Response.Redirect("/Login.aspx", false);
					}
					DataRow row1 = RentSell.GetHouseDetail(num2, int.Parse(text1));
					if (row1 != null)
					{
						this.Addr.Text = row1["Addr"].ToString();
						this.Floor1.Text = row1["Floor1"].ToString();
						this.Floor2.Text = row1["Floor2"].ToString();
						this.Square.Text = row1["Square"].ToString();
						this.Price.Text = row1["Price"].ToString();
						this.JTQK.Text = row1["JTQK"].ToString();
						this.Other.Text = row1["Other"].ToString();
						this.LinkMan.Text = row1["LinkMan"].ToString();
						this.Email.Text = row1["Email"].ToString();
						this.Tel1.Text = row1["Tel1"].ToString();
						this.Tel2.Text = row1["Tel2"].ToString();
						this.dropArea.SelectedValue = row1["Area_ID"].ToString();
						this.dropHouseType.SelectedValue = row1["Ht_ID"].ToString();
						this.dropIsAgency.Items.FindByValue(row1["IsAgency"].ToString()).Selected = true;
						this.dropDirection.Items.FindByValue(row1["Direction"].ToString()).Selected = true;
						this.dropFYHX.Items.FindByValue(row1["FYHX"].ToString()).Selected = true;
						this.dropZXQK.Items.FindByValue(row1["ZXQK"].ToString()).Selected = true;
						this.dropExpire.Items.FindByValue(row1["Expire"].ToString()).Selected = true;
						try
						{
							this.SetCheckBoxListSelectValue(this.cblJCSS, row1["JCSS"].ToString());
							this.SetCheckBoxListSelectValue(this.cblPTSS, row1["PTSS"].ToString());
						}
						catch
						{
						}
					}
					else
					{
						this.lblMsg.Text = "ǰԴϢѾɾȨʣ";
					}
				}
			}

		}
		private void BindDrop()
		{
			this.dropArea.DataSource = BindUI.GetAreaList();
			this.dropArea.DataTextField = "Area_Name";
			this.dropArea.DataValueField = "Area_ID";
			this.dropArea.DataBind();
			this.dropArea.Items.Insert(0, "ѡ...");
			this.dropArea.Items[0].Value = "0";
			this.dropHouseType.DataSource = BindUI.GetHouseTypeList();
			this.dropHouseType.DataTextField = "Ht_Name";
			this.dropHouseType.DataValueField = "Ht_ID";
			this.dropHouseType.DataBind();
			this.dropHouseType.Items.Insert(0, "ѡ...");
			this.dropHouseType.Items[0].Value = "0";
		}
 
		private void SetCheckBoxListSelectValue(CheckBoxList cbl, string strSelectList)
		{
			if ((strSelectList != null) && (strSelectList != ""))
			{
				char[] chArray1 = new char[1] { ',' } ;
				string[] textArray1 = strSelectList.Split(chArray1);
				for (int num1 = 0; num1 < textArray1.Length; num1++)
				{
					cbl.Items.FindByValue(textArray1[num1]).Selected = true;
				}
			}
		}
 
		private string GetCheckBoxListSelectValue(CheckBoxList cbl)
		{
			string text1 = "";
			for (int num1 = 0; num1 < cbl.Items.Count; num1++)
			{
				if (cbl.Items[num1].Selected)
				{
					text1 = text1 + cbl.Items[num1].Value + ",";
				}
			}
			if (text1.Length > 1)
			{
				return text1.Substring(0, text1.Length - 1);
			}
			return "";
		}
 

		#region Web ɵĴ
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: õ ASP.NET Web ġ
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// ֧ķ - Ҫʹô༭޸
		/// ˷ݡ
		/// </summary>
		private void InitializeComponent()
		{    
			this.btnSubmit.Click += new System.EventHandler(this.btnSubmit_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void btnSubmit_Click(object sender, System.EventArgs e)
		{
			HouseInfo info1 = new HouseInfo();
			string text1 = Tools.GetUserCookie("UserId");
			if (text1 == "")
			{
				this.lblMsg.Text = "󣬽ϵͳ";
			}
			else
			{
				info1.UserID = Convert.ToInt32(text1);
			}
			info1.ID = int.Parse(base.Request.QueryString["ID"]);
			info1.Type = byte.Parse(base.Request.QueryString["type"]);
			info1.AreaID = int.Parse(this.dropArea.SelectedValue);
			info1.HtID = int.Parse(this.dropHouseType.SelectedValue);
			info1.IsAgency = byte.Parse(this.dropIsAgency.Value);
			info1.Addr = this.Addr.Text.Trim();
			info1.Square = (this.Square.Text.Trim() != string.Empty) ? int.Parse(this.Square.Text.Trim()) : 0;
			info1.Price = (this.Price.Text.Trim() != string.Empty) ? int.Parse(this.Price.Text.Trim()) : 0;
			info1.Direction = this.dropDirection.Value;
			info1.Floor1 = (this.Floor1.Text.Trim() != string.Empty) ? int.Parse(this.Floor1.Text.Trim()) : 0;
			info1.Floor2 = (this.Floor2.Text.Trim() != string.Empty) ? int.Parse(this.Floor2.Text.Trim()) : 0;
			info1.FYHX = this.dropFYHX.Value;
			info1.ZXQK = this.dropZXQK.Value;
			info1.JTQK = this.JTQK.Text.Trim();
			info1.Other = this.Other.Text.Trim();
			info1.LinkMan = this.LinkMan.Text.Trim();
			info1.Tel1 = this.Tel1.Text.Trim();
			info1.Tel2 = this.Tel2.Text.Trim();
			info1.Email = this.Email.Text.Trim();
			info1.Expire = byte.Parse(this.dropExpire.Value);
			info1.IpAddr = base.Request.ServerVariables["REMOTE_ADDR"];
			info1.JCSS = this.GetCheckBoxListSelectValue(this.cblJCSS);
			info1.PTSS = this.GetCheckBoxListSelectValue(this.cblPTSS);
			int num1 = RentSell.Update(info1);
			if (num1 > 0)
			{
				base.Response.Redirect("MyRentSell.aspx", false);
			}
			else
			{
				this.lblMsg.Text = "޸ʧܣԣ";
			}

		}
	}
}
