/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.bnf;

import java.util.ArrayList;
import java.util.HashMap;
import org.h2.upgrade.v1_1.bnf.Bnf;
import org.h2.upgrade.v1_1.bnf.Rule;
import org.h2.upgrade.v1_1.bnf.RuleHead;
import org.h2.upgrade.v1_1.bnf.Sentence;
import org.h2.upgrade.v1_1.util.New;
import org.h2.upgrade.v1_1.util.StatementBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleList
implements Rule {
    private boolean or;
    private ArrayList<Rule> list = New.arrayList();
    private boolean mapSet;

    RuleList(Rule rule, Rule rule2, boolean bl) {
        if (rule instanceof RuleList && ((RuleList)rule).or == bl) {
            this.list.addAll(((RuleList)rule).list);
        } else {
            this.list.add(rule);
        }
        if (rule2 instanceof RuleList && ((RuleList)rule2).or == bl) {
            this.list.addAll(((RuleList)rule2).list);
        } else {
            this.list.add(rule2);
        }
        this.or = bl;
    }

    public String toString() {
        StatementBuilder statementBuilder = new StatementBuilder();
        if (this.or) {
            statementBuilder.append('{');
            for (Rule rule : this.list) {
                statementBuilder.appendExceptFirst("|");
                statementBuilder.append(rule.toString());
            }
            statementBuilder.append('}');
        } else {
            for (Rule rule : this.list) {
                statementBuilder.appendExceptFirst(" ");
                statementBuilder.append(rule.toString());
            }
        }
        return statementBuilder.toString();
    }

    @Override
    public String getHtmlRailroad(Bnf bnf, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.or) {
            stringBuilder.append("<table class=\"railroad\">");
            int n = 0;
            for (Rule rule : this.list) {
                String string = n == 0 ? "t" : (n == this.list.size() - 1 ? "l" : "k");
                ++n;
                stringBuilder.append("<tr class=\"railroad\"><td class=\"" + string + "s\"></td><td class=\"d\">");
                stringBuilder.append(rule.getHtmlRailroad(bnf, false));
                stringBuilder.append("</td><td class=\"" + string + "e\"></td></tr>");
            }
            stringBuilder.append("</table>");
        } else {
            if (!bl) {
                stringBuilder.append("<table class=\"railroad\">");
                stringBuilder.append("<tr class=\"railroad\">");
            }
            for (Rule rule : this.list) {
                if (!bl) {
                    stringBuilder.append("<td class=\"d\">");
                }
                stringBuilder.append(rule.getHtmlRailroad(bnf, false));
                if (bl) continue;
                stringBuilder.append("</td>");
            }
            if (!bl) {
                stringBuilder.append("</tr></table>");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String random(Bnf bnf, int n) {
        if (this.or) {
            if (n > 10) {
                if (n > 1000) {
                    throw new AssertionError();
                }
                return this.get(0).random(bnf, n);
            }
            int n2 = bnf.getRandom().nextInt(this.list.size());
            return this.get(n2).random(bnf, n + 1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Rule rule : this.list) {
            stringBuilder.append(rule.random(bnf, n + 1));
        }
        return stringBuilder.toString();
    }

    private Rule get(int n) {
        return this.list.get(n);
    }

    @Override
    public String name() {
        return null;
    }

    @Override
    public Rule last() {
        return this.get(this.list.size() - 1);
    }

    @Override
    public void setLinks(HashMap<String, RuleHead> hashMap) {
        if (!this.mapSet) {
            for (Rule rule : this.list) {
                rule.setLinks(hashMap);
            }
            this.mapSet = true;
        }
    }

    @Override
    public boolean matchRemove(Sentence sentence) {
        String string = sentence.getQuery();
        if (string.length() == 0) {
            return false;
        }
        if (this.or) {
            for (Rule rule : this.list) {
                if (!rule.matchRemove(sentence)) continue;
                return true;
            }
            return false;
        }
        for (Rule rule : this.list) {
            if (rule.matchRemove(sentence)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addNextTokenList(Sentence sentence) {
        String string = sentence.getQuery();
        if (this.or) {
            for (Rule rule : this.list) {
                sentence.setQuery(string);
                rule.addNextTokenList(sentence);
            }
        } else {
            for (Rule rule : this.list) {
                rule.addNextTokenList(sentence);
                if (rule.matchRemove(sentence)) continue;
                break;
            }
        }
        sentence.setQuery(string);
    }
}

