/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.bnf;

import java.util.HashMap;
import org.h2.upgrade.v1_1.bnf.Bnf;
import org.h2.upgrade.v1_1.bnf.Rule;
import org.h2.upgrade.v1_1.bnf.RuleHead;
import org.h2.upgrade.v1_1.bnf.Sentence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleRepeat
implements Rule {
    private static final boolean RAILROAD_DOTS = true;
    private final Rule rule;
    private final boolean comma;

    RuleRepeat(Rule rule, boolean bl) {
        this.rule = rule;
        this.comma = bl;
    }

    public String toString() {
        return "...";
    }

    @Override
    public String getHtmlRailroad(Bnf bnf, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<code class=\"c\">");
        if (this.comma) {
            stringBuilder.append(", ");
        }
        stringBuilder.append("...</code>");
        return stringBuilder.toString();
    }

    @Override
    public String name() {
        return this.rule.name();
    }

    @Override
    public Rule last() {
        return this;
    }

    @Override
    public void setLinks(HashMap<String, RuleHead> hashMap) {
    }

    @Override
    public String random(Bnf bnf, int n) {
        return this.rule.random(bnf, n);
    }

    @Override
    public boolean matchRemove(Sentence sentence) {
        if (sentence.shouldStop()) {
            return false;
        }
        String string = sentence.getQuery();
        if (string.length() == 0) {
            return false;
        }
        do {
            if (this.rule.matchRemove(sentence)) continue;
            return true;
        } while (sentence.getQuery().length() != 0);
        return true;
    }

    @Override
    public void addNextTokenList(Sentence sentence) {
        if (sentence.shouldStop()) {
            return;
        }
        String string = sentence.getQuery();
        do {
            this.rule.addNextTokenList(sentence);
        } while (this.rule.matchRemove(sentence) && !string.equals(sentence.getQuery()));
        sentence.setQuery(string);
    }
}

