/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.command;

import java.io.IOException;
import java.sql.SQLException;
import org.h2.upgrade.v1_1.command.CommandInterface;
import org.h2.upgrade.v1_1.constant.SysProperties;
import org.h2.upgrade.v1_1.engine.SessionRemote;
import org.h2.upgrade.v1_1.expression.ParameterInterface;
import org.h2.upgrade.v1_1.expression.ParameterRemote;
import org.h2.upgrade.v1_1.message.Trace;
import org.h2.upgrade.v1_1.message.TraceObject;
import org.h2.upgrade.v1_1.result.ResultInterface;
import org.h2.upgrade.v1_1.result.ResultRemote;
import org.h2.upgrade.v1_1.util.ObjectArray;
import org.h2.upgrade.v1_1.value.Transfer;
import org.h2.upgrade.v1_1.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandRemote
implements CommandInterface {
    private final ObjectArray<Transfer> transferList;
    private final ObjectArray<ParameterInterface> parameters;
    private final Trace trace;
    private final String sql;
    private final int fetchSize;
    private SessionRemote session;
    private int id;
    private boolean isQuery;
    private boolean readonly;
    private int paramCount;
    private int created;

    public CommandRemote(SessionRemote sessionRemote, ObjectArray<Transfer> objectArray, String string, int n) throws SQLException {
        this.transferList = objectArray;
        this.trace = sessionRemote.getTrace();
        this.sql = string;
        this.parameters = ObjectArray.newInstance();
        this.prepare(sessionRemote, true);
        this.session = sessionRemote;
        this.fetchSize = n;
        this.created = sessionRemote.getLastReconnect();
    }

    private void prepare(SessionRemote sessionRemote, boolean bl) throws SQLException {
        this.id = sessionRemote.getNextId();
        this.paramCount = 0;
        boolean bl2 = sessionRemote.getClientVersion() >= 6;
        int n = 0;
        for (int i = 0; i < this.transferList.size(); ++i) {
            try {
                Transfer transfer = this.transferList.get(i);
                if (bl2 && bl) {
                    sessionRemote.traceOperation("SESSION_PREPARE_READ_PARAMS", this.id);
                    transfer.writeInt(11).writeInt(this.id).writeString(this.sql);
                } else {
                    sessionRemote.traceOperation("SESSION_PREPARE", this.id);
                    transfer.writeInt(0).writeInt(this.id).writeString(this.sql);
                }
                sessionRemote.done(transfer);
                this.isQuery = transfer.readBoolean();
                this.readonly = transfer.readBoolean();
                this.paramCount = transfer.readInt();
                if (!bl) continue;
                this.parameters.clear();
                for (int j = 0; j < this.paramCount; ++j) {
                    if (bl2) {
                        ParameterRemote parameterRemote = new ParameterRemote(j);
                        parameterRemote.readMetaData(transfer);
                        this.parameters.add(parameterRemote);
                        continue;
                    }
                    this.parameters.add(new ParameterRemote(j));
                }
                continue;
            }
            catch (IOException iOException) {
                sessionRemote.removeServer(iOException, i--, ++n);
            }
        }
    }

    @Override
    public boolean isQuery() {
        return this.isQuery;
    }

    public ObjectArray<ParameterInterface> getParameters() {
        return this.parameters;
    }

    private void prepareIfRequired() throws SQLException {
        if (this.session.getLastReconnect() != this.created) {
            this.id = Integer.MIN_VALUE;
        }
        this.session.checkClosed();
        if (this.id <= this.session.getCurrentId() - SysProperties.SERVER_CACHED_OBJECTS) {
            this.prepare(this.session, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultInterface getMetaData() throws SQLException {
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            if (!this.isQuery) {
                return null;
            }
            int n = this.session.getNextId();
            ResultRemote resultRemote = null;
            int n2 = 0;
            for (int i = 0; i < this.transferList.size(); ++i) {
                this.prepareIfRequired();
                Transfer transfer = this.transferList.get(i);
                try {
                    this.session.traceOperation("COMMAND_GET_META_DATA", this.id);
                    transfer.writeInt(10).writeInt(this.id).writeInt(n);
                    this.session.done(transfer);
                    int n3 = transfer.readInt();
                    resultRemote = new ResultRemote(this.session, transfer, n, n3, Integer.MAX_VALUE);
                    break;
                }
                catch (IOException iOException) {
                    this.session.removeServer(iOException, i--, ++n2);
                    continue;
                }
            }
            this.session.autoCommitIfCluster();
            return resultRemote;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultInterface executeQuery(int n, boolean bl) throws SQLException {
        this.checkParameters();
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            int n2 = this.session.getNextId();
            ResultRemote resultRemote = null;
            int n3 = 0;
            for (int i = 0; i < this.transferList.size(); ++i) {
                this.prepareIfRequired();
                Transfer transfer = this.transferList.get(i);
                try {
                    this.session.traceOperation("COMMAND_EXECUTE_QUERY", this.id);
                    transfer.writeInt(2).writeInt(this.id).writeInt(n2).writeInt(n);
                    int n4 = this.session.isClustered() || bl ? Integer.MAX_VALUE : this.fetchSize;
                    transfer.writeInt(n4);
                    this.sendParameters(transfer);
                    this.session.done(transfer);
                    int n5 = transfer.readInt();
                    if (resultRemote != null) {
                        resultRemote.close();
                        resultRemote = null;
                    }
                    resultRemote = new ResultRemote(this.session, transfer, n2, n5, n4);
                    if (!this.readonly) continue;
                    break;
                }
                catch (IOException iOException) {
                    this.session.removeServer(iOException, i--, ++n3);
                }
            }
            this.session.autoCommitIfCluster();
            this.session.readSessionState();
            return resultRemote;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        this.checkParameters();
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            int n = 0;
            boolean bl = false;
            int n2 = 0;
            for (int i = 0; i < this.transferList.size(); ++i) {
                this.prepareIfRequired();
                Transfer transfer = this.transferList.get(i);
                try {
                    this.session.traceOperation("COMMAND_EXECUTE_UPDATE", this.id);
                    transfer.writeInt(3).writeInt(this.id);
                    this.sendParameters(transfer);
                    this.session.done(transfer);
                    n = transfer.readInt();
                    bl = transfer.readBoolean();
                    continue;
                }
                catch (IOException iOException) {
                    this.session.removeServer(iOException, i--, ++n2);
                }
            }
            this.session.setAutoCommit(bl);
            this.session.autoCommitIfCluster();
            this.session.readSessionState();
            return n;
        }
    }

    private void checkParameters() throws SQLException {
        for (ParameterInterface parameterInterface : this.parameters) {
            parameterInterface.checkSet();
        }
    }

    private void sendParameters(Transfer transfer) throws IOException, SQLException {
        int n = this.parameters.size();
        transfer.writeInt(n);
        for (ParameterInterface parameterInterface : this.parameters) {
            transfer.writeValue(parameterInterface.getParamValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.session == null || this.session.isClosed()) {
            return;
        }
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            this.session.traceOperation("COMMAND_CLOSE", this.id);
            for (Transfer transfer : this.transferList) {
                try {
                    transfer.writeInt(4).writeInt(this.id);
                }
                catch (IOException iOException) {
                    this.trace.error("close", iOException);
                }
            }
        }
        this.session = null;
        try {
            for (ParameterInterface parameterInterface : this.parameters) {
                Value value = parameterInterface.getParamValue();
                if (value == null) continue;
                value.close();
            }
        }
        catch (SQLException sQLException) {
            this.trace.error("close", sQLException);
        }
        this.parameters.clear();
    }

    @Override
    public void cancel() {
        this.session.cancelStatement(this.id);
    }

    public String toString() {
        return TraceObject.toString(this.sql, this.getParameters());
    }
}

