/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.command;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.command.Command;
import org.h2.upgrade.v1_1.constant.SysProperties;
import org.h2.upgrade.v1_1.engine.Database;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.expression.Expression;
import org.h2.upgrade.v1_1.expression.Parameter;
import org.h2.upgrade.v1_1.jdbc.JdbcSQLException;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.result.ResultInterface;
import org.h2.upgrade.v1_1.util.ObjectArray;
import org.h2.upgrade.v1_1.util.StatementBuilder;
import org.h2.upgrade.v1_1.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Prepared {
    protected Session session;
    protected String sqlStatement;
    protected int headPos = -1;
    protected ObjectArray<Parameter> parameters;
    protected boolean prepareAlways;
    private long modificationMetaId;
    private Command command;
    private int objectId;
    private int currentRowNumber;
    private int rowScanCount;

    public Prepared(Session session) {
        this.session = session;
        this.modificationMetaId = session.getDatabase().getModificationMetaId();
    }

    public abstract boolean isTransactional();

    public abstract ResultInterface queryMeta() throws SQLException;

    public boolean isReadOnly() {
        return false;
    }

    public boolean needRecompile() throws SQLException {
        Database database = this.session.getDatabase();
        if (database == null) {
            throw Message.getSQLException(90067, "database closed");
        }
        return SysProperties.RECOMPILE_ALWAYS || this.prepareAlways || this.modificationMetaId < database.getModificationMetaId();
    }

    long getModificationMetaId() {
        return this.modificationMetaId;
    }

    void setModificationMetaId(long l) {
        this.modificationMetaId = l;
    }

    public void setParameterList(ObjectArray<Parameter> objectArray) {
        this.parameters = objectArray;
    }

    public ObjectArray<Parameter> getParameters() {
        return this.parameters;
    }

    protected void checkParameters() throws SQLException {
        for (int i = 0; this.parameters != null && i < this.parameters.size(); ++i) {
            Parameter parameter = this.parameters.get(i);
            parameter.checkSet();
        }
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public boolean isQuery() {
        return false;
    }

    public void prepare() throws SQLException {
    }

    public int update() throws SQLException {
        throw Message.getSQLException(90001);
    }

    public ResultInterface query(int n) throws SQLException {
        throw Message.getSQLException(90002);
    }

    public void setSQL(String string) {
        this.sqlStatement = string;
    }

    public String getSQL() {
        return this.sqlStatement;
    }

    protected int getCurrentObjectId() {
        return this.objectId;
    }

    protected int getObjectId(boolean bl, boolean bl2) {
        Database database = this.session.getDatabase();
        int n = this.objectId;
        if (n == 0) {
            n = database.allocateObjectId(bl, bl2);
        }
        this.objectId = 0;
        return n;
    }

    public String getPlanSQL() {
        return null;
    }

    public void checkCanceled() throws SQLException {
        Command command;
        this.session.checkCanceled();
        Command command2 = command = this.command != null ? this.command : this.session.getCurrentCommand();
        if (command != null) {
            command.checkCanceled();
        }
    }

    public void setObjectId(int n) {
        this.objectId = n;
    }

    public void setHeadPos(int n) {
        this.headPos = n;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    void trace(long l, int n) throws SQLException {
        if (this.session.getTrace().isInfoEnabled()) {
            String string;
            long l2 = System.currentTimeMillis() - l;
            if (this.parameters.size() > 0) {
                StatementBuilder statementBuilder = new StatementBuilder(" {");
                int n2 = 0;
                for (Parameter parameter : this.parameters) {
                    statementBuilder.appendExceptFirst(", ");
                    Value value = ((Expression)parameter).getValue(this.session);
                    statementBuilder.append(++n2).append(": ").append(value.getTraceSQL());
                }
                string = statementBuilder.append('}').toString();
            } else {
                string = "";
            }
            this.session.getTrace().infoSQL(this.sqlStatement, string, n, l2);
        }
    }

    public void setPrepareAlways(boolean bl) {
        this.prepareAlways = bl;
    }

    protected void setCurrentRowNumber(int n) throws SQLException {
        if ((++this.rowScanCount & 0x7F) == 0) {
            this.checkCanceled();
        }
        this.currentRowNumber = n;
    }

    public int getCurrentRowNumber() {
        return this.currentRowNumber;
    }

    public String toString() {
        return this.sqlStatement;
    }

    protected String getSQL(Value[] valueArray) {
        StatementBuilder statementBuilder = new StatementBuilder();
        for (Value value : valueArray) {
            statementBuilder.appendExceptFirst(", ");
            if (value == null) continue;
            statementBuilder.append(value.getSQL());
        }
        return statementBuilder.toString();
    }

    protected String getSQL(Expression[] expressionArray) {
        StatementBuilder statementBuilder = new StatementBuilder();
        for (Expression expression : expressionArray) {
            statementBuilder.appendExceptFirst(", ");
            if (expression == null) continue;
            statementBuilder.append(expression.getSQL());
        }
        return statementBuilder.toString();
    }

    protected SQLException setRow(SQLException sQLException, int n, String string) {
        if (sQLException instanceof JdbcSQLException) {
            JdbcSQLException jdbcSQLException = (JdbcSQLException)sQLException;
            StringBuilder stringBuilder = new StringBuilder();
            if (this.sqlStatement != null) {
                stringBuilder.append(this.sqlStatement);
            }
            stringBuilder.append(" -- ");
            if (n > 0) {
                stringBuilder.append("row #").append(n + 1).append(' ');
            }
            stringBuilder.append('(').append(string).append(')');
            jdbcSQLException.setSQL(stringBuilder.toString());
        }
        return sQLException;
    }
}

