/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.command.ddl;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.command.ddl.DefineCommand;
import org.h2.upgrade.v1_1.engine.Database;
import org.h2.upgrade.v1_1.engine.FunctionAlias;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.message.Message;

public class CreateFunctionAlias
extends DefineCommand {
    private String aliasName;
    private String javaClassMethod;
    private boolean deterministic;
    private boolean ifNotExists;
    private boolean force;
    private String source;

    public CreateFunctionAlias(Session session) {
        super(session);
    }

    public int update() throws SQLException {
        this.session.commit(true);
        this.session.getUser().checkAdmin();
        Database database = this.session.getDatabase();
        if (database.findFunctionAlias(this.aliasName) != null) {
            if (!this.ifNotExists) {
                throw Message.getSQLException(90076, this.aliasName);
            }
        } else {
            int n = this.getObjectId(false, true);
            FunctionAlias functionAlias = this.javaClassMethod != null ? FunctionAlias.newInstance(database, n, this.aliasName, this.javaClassMethod, this.force) : FunctionAlias.newInstanceFromSource(database, n, this.aliasName, this.source, this.force);
            functionAlias.setDeterministic(this.deterministic);
            database.addDatabaseObject(this.session, functionAlias);
        }
        return 0;
    }

    public void setAliasName(String string) {
        this.aliasName = string;
    }

    public void setJavaClassMethod(String string) {
        this.javaClassMethod = string;
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public void setDeterministic(boolean bl) {
        this.deterministic = bl;
    }

    public void setSource(String string) {
        this.source = string;
    }
}

