/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.command.ddl;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.command.ddl.DefineCommand;
import org.h2.upgrade.v1_1.engine.Database;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.engine.UserAggregate;
import org.h2.upgrade.v1_1.message.Message;

public class DropAggregate
extends DefineCommand {
    private String name;
    private boolean ifExists;

    public DropAggregate(Session session) {
        super(session);
    }

    public int update() throws SQLException {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        UserAggregate userAggregate = database.findAggregate(this.name);
        if (userAggregate == null) {
            if (!this.ifExists) {
                throw Message.getSQLException(90132, this.name);
            }
        } else {
            database.removeDatabaseObject(this.session, userAggregate);
        }
        return 0;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }
}

