/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.command.ddl;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.command.ddl.DefineCommand;
import org.h2.upgrade.v1_1.engine.Database;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.schema.Schema;

public class DropSchema
extends DefineCommand {
    private String schemaName;
    private boolean ifExists;

    public DropSchema(Session session) {
        super(session);
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    public int update() throws SQLException {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        Schema schema = database.findSchema(this.schemaName);
        if (schema == null) {
            if (!this.ifExists) {
                throw Message.getSQLException(90079, this.schemaName);
            }
        } else {
            if (!schema.canDrop()) {
                throw Message.getSQLException(90090, this.schemaName);
            }
            database.removeDatabaseObject(this.session, schema);
        }
        return 0;
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }
}

