/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.engine;

import java.util.HashMap;
import org.h2.upgrade.v1_1.constant.SysProperties;
import org.h2.upgrade.v1_1.util.New;
import org.h2.upgrade.v1_1.util.StringUtils;

public class Mode {
    public static final String REGULAR = "REGULAR";
    private static final HashMap<String, Mode> MODES = New.hashMap();
    public boolean aliasColumnName;
    public boolean convertInsertNullToZero;
    public boolean convertOnlyToSmallerScale;
    public boolean indexDefinitionInCreateTable;
    public boolean lowerCaseIdentifiers;
    public boolean nullConcatIsNull;
    public boolean roundWhenConvertToLong;
    public boolean squareBracketQuotedNames;
    public boolean supportOffsetFetch;
    public boolean systemColumns;
    public boolean uniqueIndexSingleNull;
    public boolean uniqueIndexSingleNullExceptAllColumnsAreNull;
    private String name;

    private Mode(String string) {
        this.name = string;
    }

    private static void add(Mode mode) {
        MODES.put(StringUtils.toUpperEnglish(mode.name), mode);
    }

    public static Mode getInstance(String string) {
        return MODES.get(StringUtils.toUpperEnglish(string));
    }

    public String getName() {
        return this.name;
    }

    static {
        Mode mode = new Mode(REGULAR);
        mode.aliasColumnName = SysProperties.ALIAS_COLUMN_NAME;
        mode.nullConcatIsNull = SysProperties.NULL_CONCAT_IS_NULL;
        Mode.add(mode);
        mode = new Mode("DB2");
        mode.aliasColumnName = true;
        mode.supportOffsetFetch = true;
        Mode.add(mode);
        mode = new Mode("Derby");
        mode.aliasColumnName = true;
        mode.uniqueIndexSingleNull = true;
        Mode.add(mode);
        mode = new Mode("HSQLDB");
        mode.aliasColumnName = true;
        mode.convertOnlyToSmallerScale = true;
        mode.nullConcatIsNull = true;
        mode.uniqueIndexSingleNull = true;
        Mode.add(mode);
        mode = new Mode("MSSQLServer");
        mode.aliasColumnName = true;
        mode.squareBracketQuotedNames = true;
        mode.uniqueIndexSingleNull = true;
        Mode.add(mode);
        mode = new Mode("MySQL");
        mode.convertInsertNullToZero = true;
        mode.indexDefinitionInCreateTable = true;
        mode.lowerCaseIdentifiers = true;
        mode.roundWhenConvertToLong = true;
        Mode.add(mode);
        mode = new Mode("Oracle");
        mode.aliasColumnName = true;
        mode.uniqueIndexSingleNullExceptAllColumnsAreNull = true;
        Mode.add(mode);
        mode = new Mode("PostgreSQL");
        mode.aliasColumnName = true;
        mode.nullConcatIsNull = true;
        mode.roundWhenConvertToLong = true;
        mode.systemColumns = true;
        Mode.add(mode);
    }
}

