/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.expression;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.constant.SysProperties;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.expression.Condition;
import org.h2.upgrade.v1_1.expression.Expression;
import org.h2.upgrade.v1_1.expression.ExpressionVisitor;
import org.h2.upgrade.v1_1.expression.ValueExpression;
import org.h2.upgrade.v1_1.table.ColumnResolver;
import org.h2.upgrade.v1_1.table.TableFilter;
import org.h2.upgrade.v1_1.value.Value;
import org.h2.upgrade.v1_1.value.ValueNull;

public class ConditionNot
extends Condition {
    private Expression condition;

    public ConditionNot(Expression expression) {
        this.condition = expression;
    }

    public Expression getNotIfPossible(Session session) {
        return this.condition;
    }

    public Value getValue(Session session) throws SQLException {
        Value value = this.condition.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return value;
        }
        return value.convertTo(1).negate();
    }

    public void mapColumns(ColumnResolver columnResolver, int n) throws SQLException {
        this.condition.mapColumns(columnResolver, n);
    }

    public Expression optimize(Session session) throws SQLException {
        if (!SysProperties.OPTIMIZE_NOT) {
            this.condition = this.condition.optimize(session);
            return this;
        }
        Expression expression = this.condition.getNotIfPossible(session);
        if (expression != null) {
            return expression.optimize(session);
        }
        Expression expression2 = this.condition.optimize(session);
        if (expression2.isConstant()) {
            Value value = expression2.getValue(session);
            if (value == ValueNull.INSTANCE) {
                return ValueExpression.getNull();
            }
            return ValueExpression.get(value.convertTo(1).negate());
        }
        this.condition = expression2;
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.condition.setEvaluatable(tableFilter, bl);
    }

    public String getSQL() {
        return "(NOT " + this.condition.getSQL() + ")";
    }

    public void updateAggregate(Session session) throws SQLException {
        this.condition.updateAggregate(session);
    }

    public void addFilterConditions(TableFilter tableFilter, boolean bl) {
        if (bl) {
            return;
        }
        super.addFilterConditions(tableFilter, bl);
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.condition.isEverything(expressionVisitor);
    }

    public int getCost() {
        return this.condition.getCost();
    }
}

