/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.index;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.index.Cursor;
import org.h2.upgrade.v1_1.result.Row;
import org.h2.upgrade.v1_1.result.SearchRow;
import org.h2.upgrade.v1_1.table.TableData;
import org.h2.upgrade.v1_1.util.IntArray;

public class NonUniqueHashCursor
implements Cursor {
    private final Session session;
    private final IntArray positions;
    private final TableData tableData;
    private int index = -1;

    public NonUniqueHashCursor(Session session, TableData tableData, IntArray intArray) {
        this.session = session;
        this.tableData = tableData;
        this.positions = intArray;
    }

    public Row get() throws SQLException {
        if (this.index < 0 || this.index >= this.positions.size()) {
            return null;
        }
        return this.tableData.getRow(this.session, this.positions.get(this.index));
    }

    public long getKey() {
        return this.index;
    }

    public SearchRow getSearchRow() throws SQLException {
        return this.get();
    }

    public boolean next() {
        return this.positions != null && ++this.index < this.positions.size();
    }

    public boolean previous() {
        return this.positions != null && --this.index >= 0;
    }
}

