/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.index;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.index.PageBtreeCursor;
import org.h2.upgrade.v1_1.index.PageBtreeIndex;
import org.h2.upgrade.v1_1.index.PageBtreeLeaf;
import org.h2.upgrade.v1_1.result.SearchRow;
import org.h2.upgrade.v1_1.store.Data;
import org.h2.upgrade.v1_1.store.Page;

public abstract class PageBtree
extends Page {
    static final int ROOT = 0;
    static final int UNKNOWN_ROWCOUNT = -1;
    protected final PageBtreeIndex index;
    protected int parentPageId;
    protected final Data data;
    protected int[] offsets;
    protected int entryCount;
    protected SearchRow[] rows;
    protected int start;
    protected boolean onlyPosition;
    protected boolean written;

    PageBtree(PageBtreeIndex pageBtreeIndex, int n, Data data) {
        this.index = pageBtreeIndex;
        this.data = data;
        this.setPos(n);
    }

    abstract int getRowCount() throws SQLException;

    abstract void setRowCountStored(int var1) throws SQLException;

    int find(SearchRow searchRow, boolean bl, boolean bl2, boolean bl3) throws SQLException {
        if (searchRow == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.entryCount;
        int n3 = 1;
        while (n < n2) {
            int n4 = n + n2 >>> 1;
            SearchRow searchRow2 = this.getRow(n4);
            n3 = this.index.compareRows(searchRow2, searchRow);
            if (n3 == 0) {
                if (bl2 && this.index.indexType.isUnique() && !this.index.containsNullAndAllowMultipleNull(searchRow)) {
                    throw this.index.getDuplicateKeyException();
                }
                if (bl3 && (n3 = this.index.compareKeys(searchRow2, searchRow)) == 0) {
                    return n4;
                }
            }
            if (n3 > 0 || !bl && n3 == 0) {
                n2 = n4;
                continue;
            }
            n = n4 + 1;
        }
        return n;
    }

    abstract int addRowTry(SearchRow var1) throws SQLException;

    abstract void find(PageBtreeCursor var1, SearchRow var2, boolean var3) throws SQLException;

    abstract void last(PageBtreeCursor var1) throws SQLException;

    SearchRow getRow(int n) throws SQLException {
        SearchRow searchRow = this.rows[n];
        if (searchRow == null) {
            this.rows[n] = searchRow = this.index.readRow(this.data, this.offsets[n], this.onlyPosition, true);
        } else if (!this.index.hasData(searchRow)) {
            this.rows[n] = searchRow = this.index.readRow(searchRow.getKey());
        }
        return searchRow;
    }

    abstract PageBtree split(int var1) throws SQLException;

    void setPageId(int n) throws SQLException {
        this.changeCount = this.index.getPageStore().getChangeCount();
        this.written = false;
        this.index.getPageStore().removeRecord(this.getPos());
        this.setPos(n);
        this.index.getPageStore().logUndo(this, null);
        this.remapChildren();
    }

    abstract PageBtreeLeaf getFirstLeaf() throws SQLException;

    abstract PageBtreeLeaf getLastLeaf() throws SQLException;

    void setParentPageId(int n) throws SQLException {
        this.index.getPageStore().logUndo(this, this.data);
        this.changeCount = this.index.getPageStore().getChangeCount();
        this.written = false;
        this.parentPageId = n;
    }

    abstract void remapChildren() throws SQLException;

    abstract SearchRow remove(SearchRow var1) throws SQLException;

    abstract void freeRecursive() throws SQLException;

    protected void readAllRows() throws SQLException {
        for (int i = 0; i < this.entryCount; ++i) {
            SearchRow searchRow = this.rows[i];
            if (searchRow != null) continue;
            this.rows[i] = searchRow = this.index.readRow(this.data, this.offsets[i], this.onlyPosition, false);
        }
    }

    public int getMemorySize() {
        return this.index.getPageStore().getPageSize();
    }

    public boolean canRemove() {
        if (this.changeCount >= this.index.getPageStore().getChangeCount()) {
            return false;
        }
        return super.canRemove();
    }
}

