/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.index;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.constant.SysProperties;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.index.BaseIndex;
import org.h2.upgrade.v1_1.index.Cursor;
import org.h2.upgrade.v1_1.index.IndexType;
import org.h2.upgrade.v1_1.index.TreeCursor;
import org.h2.upgrade.v1_1.index.TreeNode;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.result.Row;
import org.h2.upgrade.v1_1.result.SearchRow;
import org.h2.upgrade.v1_1.table.IndexColumn;
import org.h2.upgrade.v1_1.table.TableData;
import org.h2.upgrade.v1_1.value.Value;
import org.h2.upgrade.v1_1.value.ValueNull;

public class TreeIndex
extends BaseIndex {
    private TreeNode root;
    private TableData tableData;
    private long rowCount;

    public TreeIndex(TableData tableData, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.initBaseIndex(tableData, n, string, indexColumnArray, indexType);
        this.tableData = tableData;
    }

    public void close(Session session) {
        this.root = null;
    }

    public void add(Session session, Row row) throws SQLException {
        TreeNode treeNode;
        TreeNode treeNode2 = new TreeNode(row);
        TreeNode treeNode3 = treeNode = this.root;
        boolean bl = true;
        while (true) {
            if (treeNode == null) {
                if (treeNode3 == null) {
                    this.root = treeNode2;
                    ++this.rowCount;
                    return;
                }
                break;
            }
            Row row2 = treeNode.row;
            int n = this.compareRows(row, row2);
            if (n == 0) {
                if (this.indexType.isUnique() && !this.containsNullAndAllowMultipleNull(row)) {
                    throw this.getDuplicateKeyException();
                }
                n = this.compareKeys(row, row2);
            }
            bl = n < 0;
            treeNode3 = treeNode;
            treeNode = this.child(treeNode3, bl);
        }
        this.set(treeNode3, bl, treeNode2);
        this.balance(treeNode3, bl);
        ++this.rowCount;
    }

    private void balance(TreeNode treeNode, boolean bl) {
        while (true) {
            int n = bl ? 1 : -1;
            switch (treeNode.balance * n) {
                case 1: {
                    treeNode.balance = 0;
                    return;
                }
                case 0: {
                    treeNode.balance = -n;
                    break;
                }
                case -1: {
                    TreeNode treeNode2 = this.child(treeNode, bl);
                    if (treeNode2.balance == -n) {
                        this.replace(treeNode, treeNode2);
                        this.set(treeNode, bl, this.child(treeNode2, !bl));
                        this.set(treeNode2, !bl, treeNode);
                        treeNode.balance = 0;
                        treeNode2.balance = 0;
                    } else {
                        TreeNode treeNode3 = this.child(treeNode2, !bl);
                        this.replace(treeNode, treeNode3);
                        this.set(treeNode2, !bl, this.child(treeNode3, bl));
                        this.set(treeNode3, bl, treeNode2);
                        this.set(treeNode, bl, this.child(treeNode3, !bl));
                        this.set(treeNode3, !bl, treeNode);
                        int n2 = treeNode3.balance;
                        treeNode.balance = n2 == -n ? n : 0;
                        treeNode2.balance = n2 == n ? -n : 0;
                        treeNode3.balance = 0;
                    }
                    return;
                }
                default: {
                    Message.throwInternalError("b:" + treeNode.balance * n);
                }
            }
            if (treeNode == this.root) {
                return;
            }
            bl = treeNode.isFromLeft();
            treeNode = treeNode.parent;
        }
    }

    private TreeNode child(TreeNode treeNode, boolean bl) {
        return bl ? treeNode.left : treeNode.right;
    }

    private void replace(TreeNode treeNode, TreeNode treeNode2) {
        if (treeNode == this.root) {
            this.root = treeNode2;
            if (treeNode2 != null) {
                treeNode2.parent = null;
            }
        } else {
            this.set(treeNode.parent, treeNode.isFromLeft(), treeNode2);
        }
    }

    private void set(TreeNode treeNode, boolean bl, TreeNode treeNode2) {
        if (bl) {
            treeNode.left = treeNode2;
        } else {
            treeNode.right = treeNode2;
        }
        if (treeNode2 != null) {
            treeNode2.parent = treeNode;
        }
    }

    public void remove(Session session, Row row) throws SQLException {
        TreeNode treeNode;
        int n;
        TreeNode treeNode2;
        TreeNode treeNode3 = this.findFirstNode(row, true);
        if (treeNode3 == null) {
            throw Message.throwInternalError("not found!");
        }
        if (treeNode3.left == null) {
            treeNode2 = treeNode3.right;
        } else if (treeNode3.right == null) {
            treeNode2 = treeNode3.left;
        } else {
            TreeNode treeNode4 = treeNode3;
            TreeNode treeNode5 = treeNode3 = treeNode3.left;
            while ((treeNode5 = treeNode5.right) != null) {
                treeNode3 = treeNode5;
            }
            treeNode2 = treeNode3.left;
            n = treeNode3.balance;
            treeNode3.balance = treeNode4.balance;
            treeNode4.balance = n;
            treeNode = treeNode3.parent;
            TreeNode treeNode6 = treeNode4.parent;
            if (treeNode4 == this.root) {
                this.root = treeNode3;
            }
            treeNode3.parent = treeNode6;
            if (treeNode6 != null) {
                if (treeNode6.right == treeNode4) {
                    treeNode6.right = treeNode3;
                } else {
                    treeNode6.left = treeNode3;
                }
            }
            if (treeNode == treeNode4) {
                treeNode4.parent = treeNode3;
                if (treeNode4.left == treeNode3) {
                    treeNode3.left = treeNode4;
                    treeNode3.right = treeNode4.right;
                } else {
                    treeNode3.right = treeNode4;
                    treeNode3.left = treeNode4.left;
                }
            } else {
                treeNode4.parent = treeNode;
                treeNode.right = treeNode4;
                treeNode3.right = treeNode4.right;
                treeNode3.left = treeNode4.left;
            }
            if (SysProperties.CHECK && treeNode3.right == null) {
                Message.throwInternalError("tree corrupted");
            }
            treeNode3.right.parent = treeNode3;
            treeNode3.left.parent = treeNode3;
            treeNode4.left = treeNode2;
            if (treeNode2 != null) {
                treeNode2.parent = treeNode4;
            }
            treeNode4.right = null;
            treeNode3 = treeNode4;
        }
        --this.rowCount;
        boolean bl = treeNode3.isFromLeft();
        this.replace(treeNode3, treeNode2);
        treeNode2 = treeNode3.parent;
        while (treeNode2 != null) {
            treeNode3 = treeNode2;
            n = bl ? 1 : -1;
            switch (treeNode3.balance * n) {
                case -1: {
                    treeNode3.balance = 0;
                    break;
                }
                case 0: {
                    treeNode3.balance = n;
                    return;
                }
                case 1: {
                    treeNode = this.child(treeNode3, !bl);
                    int n2 = treeNode.balance;
                    if (n2 * n >= 0) {
                        this.replace(treeNode3, treeNode);
                        this.set(treeNode3, !bl, this.child(treeNode, bl));
                        this.set(treeNode, bl, treeNode3);
                        if (n2 == 0) {
                            treeNode3.balance = n;
                            treeNode.balance = -n;
                            return;
                        }
                        treeNode3.balance = 0;
                        treeNode.balance = 0;
                        treeNode3 = treeNode;
                        break;
                    }
                    TreeNode treeNode7 = this.child(treeNode, bl);
                    this.replace(treeNode3, treeNode7);
                    n2 = treeNode7.balance;
                    this.set(treeNode, bl, this.child(treeNode7, !bl));
                    this.set(treeNode7, !bl, treeNode);
                    this.set(treeNode3, !bl, this.child(treeNode7, bl));
                    this.set(treeNode7, bl, treeNode3);
                    treeNode3.balance = n2 == n ? -n : 0;
                    treeNode.balance = n2 == -n ? n : 0;
                    treeNode7.balance = 0;
                    treeNode3 = treeNode7;
                    break;
                }
                default: {
                    Message.throwInternalError("b: " + treeNode3.balance * n);
                }
            }
            bl = treeNode3.isFromLeft();
            treeNode2 = treeNode3.parent;
        }
    }

    private TreeNode findFirstNode(SearchRow searchRow, boolean bl) throws SQLException {
        TreeNode treeNode;
        TreeNode treeNode2 = treeNode = this.root;
        while (treeNode != null) {
            treeNode2 = treeNode;
            int n = this.compareRows(treeNode.row, searchRow);
            if (n == 0 && bl) {
                n = this.compareKeys(treeNode.row, searchRow);
            }
            if (n == 0) {
                if (bl) {
                    return treeNode;
                }
                treeNode = treeNode.left;
                continue;
            }
            if (n > 0) {
                treeNode = treeNode.left;
                continue;
            }
            treeNode = treeNode.right;
        }
        return treeNode2;
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        if (searchRow == null) {
            TreeNode treeNode;
            TreeNode treeNode2 = this.root;
            while (treeNode2 != null && (treeNode = treeNode2.left) != null) {
                treeNode2 = treeNode;
            }
            return new TreeCursor(this, treeNode2, null, searchRow2);
        }
        TreeNode treeNode = this.findFirstNode(searchRow, false);
        return new TreeCursor(this, treeNode, searchRow, searchRow2);
    }

    public double getCost(Session session, int[] nArray) {
        return this.getCostRangeIndex(nArray, this.tableData.getRowCountApproximation());
    }

    public void remove(Session session) {
        this.truncate(session);
    }

    public void truncate(Session session) {
        this.root = null;
        this.rowCount = 0L;
    }

    TreeNode next(TreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        TreeNode treeNode2 = treeNode.right;
        if (treeNode2 != null) {
            treeNode = treeNode2;
            TreeNode treeNode3 = treeNode.left;
            while (treeNode3 != null) {
                treeNode = treeNode3;
                treeNode3 = treeNode.left;
            }
            return treeNode;
        }
        TreeNode treeNode4 = treeNode;
        treeNode = treeNode.parent;
        while (treeNode != null && treeNode4 == treeNode.right) {
            treeNode4 = treeNode;
            treeNode = treeNode.parent;
        }
        return treeNode;
    }

    TreeNode previous(TreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        TreeNode treeNode2 = treeNode.left;
        if (treeNode2 != null) {
            treeNode = treeNode2;
            TreeNode treeNode3 = treeNode.right;
            while (treeNode3 != null) {
                treeNode = treeNode3;
                treeNode3 = treeNode.right;
            }
            return treeNode;
        }
        TreeNode treeNode4 = treeNode;
        treeNode = treeNode.parent;
        while (treeNode != null && treeNode4 == treeNode.left) {
            treeNode4 = treeNode;
            treeNode = treeNode.parent;
        }
        return treeNode;
    }

    public void checkRename() {
    }

    public boolean needRebuild() {
        return true;
    }

    public boolean canGetFirstOrLast() {
        return true;
    }

    public Cursor findFirstOrLast(Session session, boolean bl) throws SQLException {
        SearchRow searchRow;
        TreeNode treeNode;
        if (bl) {
            Cursor cursor = this.find(session, null, null);
            while (cursor.next()) {
                SearchRow searchRow2 = cursor.getSearchRow();
                Value value = searchRow2.getValue(this.columnIds[0]);
                if (value == ValueNull.INSTANCE) continue;
                return cursor;
            }
            return cursor;
        }
        TreeNode treeNode2 = this.root;
        while (treeNode2 != null && (treeNode = treeNode2.right) != null) {
            treeNode2 = treeNode;
        }
        TreeCursor treeCursor = new TreeCursor(this, treeNode2, null, null);
        if (treeNode2 == null) {
            return treeCursor;
        }
        while ((searchRow = treeCursor.getSearchRow()) != null) {
            Value value = searchRow.getValue(this.columnIds[0]);
            if (value != ValueNull.INSTANCE) {
                return treeCursor;
            }
            if (treeCursor.previous()) continue;
        }
        return treeCursor;
    }

    public long getRowCount(Session session) {
        return this.rowCount;
    }

    public long getRowCountApproximation() {
        return this.rowCount;
    }
}

