/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.result;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.command.ddl.CreateTableData;
import org.h2.upgrade.v1_1.engine.Database;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.index.BtreeIndex;
import org.h2.upgrade.v1_1.index.Cursor;
import org.h2.upgrade.v1_1.index.Index;
import org.h2.upgrade.v1_1.index.IndexType;
import org.h2.upgrade.v1_1.index.PageBtreeIndex;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.result.ResultExternal;
import org.h2.upgrade.v1_1.result.Row;
import org.h2.upgrade.v1_1.result.SearchRow;
import org.h2.upgrade.v1_1.result.SortOrder;
import org.h2.upgrade.v1_1.schema.Schema;
import org.h2.upgrade.v1_1.table.Column;
import org.h2.upgrade.v1_1.table.IndexColumn;
import org.h2.upgrade.v1_1.table.TableData;
import org.h2.upgrade.v1_1.util.ObjectArray;
import org.h2.upgrade.v1_1.value.Value;
import org.h2.upgrade.v1_1.value.ValueArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultTempTable
implements ResultExternal {
    private static final String COLUMN_NAME = "DATA";
    private Session session;
    private TableData table;
    private SortOrder sort;
    private Index index;
    private Cursor resultCursor;

    public ResultTempTable(Session session, SortOrder sortOrder) throws SQLException {
        this.session = session;
        this.sort = sortOrder;
        Schema schema = session.getDatabase().getSchema("PUBLIC");
        Column column = new Column(COLUMN_NAME, 17);
        column.setNullable(false);
        CreateTableData createTableData = new CreateTableData();
        createTableData.columns.add(column);
        createTableData.id = session.getDatabase().allocateObjectId(true, true);
        createTableData.tableName = "TEMP_RESULT_SET_" + createTableData.id;
        createTableData.temporary = true;
        createTableData.persistIndexes = false;
        createTableData.persistData = true;
        createTableData.headPos = -1;
        createTableData.session = session;
        this.table = schema.createTable(createTableData);
        int n = session.getDatabase().allocateObjectId(true, false);
        IndexColumn indexColumn = new IndexColumn();
        indexColumn.column = column;
        indexColumn.columnName = COLUMN_NAME;
        IndexType indexType = IndexType.createPrimaryKey(true, false);
        IndexColumn[] indexColumnArray = new IndexColumn[]{indexColumn};
        this.index = session.getDatabase().isPageStoreEnabled() ? new PageBtreeIndex(this.table, n, createTableData.tableName, indexColumnArray, indexType, -1, session) : new BtreeIndex(session, this.table, n, createTableData.tableName, indexColumnArray, indexType, -1);
        this.index.setTemporary(true);
        this.table.getIndexes().add(this.index);
    }

    @Override
    public int removeRow(Value[] valueArray) throws SQLException {
        Row row = this.convertToRow(valueArray);
        Cursor cursor = this.find(row);
        if (cursor != null) {
            row = cursor.get();
            this.table.removeRow(this.session, row);
        }
        return (int)this.table.getRowCount(this.session);
    }

    @Override
    public boolean contains(Value[] valueArray) throws SQLException {
        return this.find(this.convertToRow(valueArray)) != null;
    }

    @Override
    public int addRow(Value[] valueArray) throws SQLException {
        Row row = this.convertToRow(valueArray);
        Cursor cursor = this.find(row);
        if (cursor == null) {
            this.table.addRow(this.session, row);
        }
        return (int)this.table.getRowCount(this.session);
    }

    @Override
    public void addRows(ObjectArray<Value[]> objectArray) throws SQLException {
        if (this.sort != null) {
            this.sort.sort(objectArray);
        }
        for (Value[] valueArray : objectArray) {
            this.addRow(valueArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.table == null) {
            return;
        }
        try {
            Database database;
            this.table.truncate(this.session);
            Database database2 = database = this.session.getDatabase();
            synchronized (database2) {
                Session session = database.getSystemSession();
                if (!database.isSysTableLocked()) {
                    Session session2 = session;
                    synchronized (session2) {
                        this.index.removeChildrenAndResources(session);
                        this.table.removeChildrenAndResources(session);
                        session.commit(false);
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw Message.convertToInternal(sQLException);
        }
        finally {
            this.table = null;
        }
    }

    @Override
    public void done() {
    }

    @Override
    public Value[] next() throws SQLException {
        if (!this.resultCursor.next()) {
            return null;
        }
        Row row = this.resultCursor.get();
        ValueArray valueArray = (ValueArray)row.getValue(0);
        return valueArray.getList();
    }

    @Override
    public void reset() throws SQLException {
        this.resultCursor = this.index.find(this.session, null, null);
    }

    private Row convertToRow(Value[] valueArray) {
        ValueArray valueArray2 = ValueArray.get(valueArray);
        return new Row(new Value[]{valueArray2}, valueArray2.getMemory());
    }

    private Cursor find(Row row) throws SQLException {
        Cursor cursor = this.index.find(this.session, row, row);
        while (cursor.next()) {
            SearchRow searchRow = cursor.getSearchRow();
            if (!searchRow.getValue(0).equals(row.getValue(0))) continue;
            return cursor;
        }
        return null;
    }
}

