/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.server.web;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.h2.upgrade.v1_1.bnf.Bnf;
import org.h2.upgrade.v1_1.message.TraceSystem;
import org.h2.upgrade.v1_1.server.web.DbContents;
import org.h2.upgrade.v1_1.server.web.DbContextRule;
import org.h2.upgrade.v1_1.server.web.WebServer;
import org.h2.upgrade.v1_1.util.New;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WebSession {
    private static final int MAX_HISTORY = 1000;
    long lastAccess;
    HashMap<String, Object> map = New.hashMap();
    Locale locale;
    Statement executingStatement;
    ResultSet result;
    private WebServer server;
    private ArrayList<String> commandHistory = New.arrayList();
    private Connection conn;
    private DatabaseMetaData meta;
    private DbContents contents = new DbContents();
    private DbContextRule columnRule;
    private DbContextRule newAliasRule;
    private DbContextRule schemaRule;
    private DbContextRule tableRule;
    private DbContextRule aliasRule;
    private DbContextRule columnAliasRule;
    private Bnf bnf;
    private boolean shutdownServerOnDisconnect;

    WebSession(WebServer webServer) {
        this.server = webServer;
    }

    void put(String string, Object object) {
        this.map.put(string, object);
    }

    Object get(String string) {
        if ("sessions".equals(string)) {
            return this.server.getSessions();
        }
        return this.map.get(string);
    }

    void remove(String string) {
        this.map.remove(string);
    }

    Bnf getBnf() {
        return this.bnf;
    }

    void loadBnf() {
        try {
            Bnf bnf = Bnf.getInstance(null);
            this.columnRule = new DbContextRule(this.contents, 0);
            this.newAliasRule = new DbContextRule(this.contents, 3);
            this.aliasRule = new DbContextRule(this.contents, 2);
            this.tableRule = new DbContextRule(this.contents, 1);
            this.schemaRule = new DbContextRule(this.contents, 5);
            this.columnAliasRule = new DbContextRule(this.contents, 4);
            bnf.updateTopic("column_name", this.columnRule);
            bnf.updateTopic("new_table_alias", this.newAliasRule);
            bnf.updateTopic("table_alias", this.aliasRule);
            bnf.updateTopic("column_alias", this.columnAliasRule);
            bnf.updateTopic("table_name", this.tableRule);
            bnf.updateTopic("schema_name", this.schemaRule);
            bnf.linkStatements();
            this.bnf = bnf;
        }
        catch (Exception exception) {
            this.server.traceError(exception);
        }
    }

    String getCommand(int n) {
        return this.commandHistory.get(n);
    }

    void addCommand(String string) {
        int n;
        if (string == null) {
            return;
        }
        if ((string = string.trim()).length() == 0) {
            return;
        }
        if (this.commandHistory.size() > 1000) {
            this.commandHistory.remove(0);
        }
        if ((n = this.commandHistory.indexOf(string)) >= 0) {
            this.commandHistory.remove(n);
        }
        this.commandHistory.add(string);
    }

    ArrayList<String> getCommands() {
        return this.commandHistory;
    }

    HashMap<String, Object> getInfo() {
        HashMap<String, Object> hashMap = New.hashMap();
        hashMap.putAll(this.map);
        hashMap.put("lastAccess", new Timestamp(this.lastAccess).toString());
        try {
            hashMap.put("url", this.conn == null ? "not connected" : this.conn.getMetaData().getURL());
            hashMap.put("user", this.conn == null ? "-" : this.conn.getMetaData().getUserName());
            hashMap.put("lastQuery", this.commandHistory.size() == 0 ? "" : this.commandHistory.get(0));
            hashMap.put("executing", this.executingStatement == null ? "no" : "yes");
        }
        catch (SQLException sQLException) {
            TraceSystem.traceThrowable(sQLException);
        }
        return hashMap;
    }

    void setConnection(Connection connection) throws SQLException {
        this.conn = connection;
        this.meta = connection == null ? null : connection.getMetaData();
        this.contents = new DbContents();
    }

    DatabaseMetaData getMetaData() {
        return this.meta;
    }

    Connection getConnection() {
        return this.conn;
    }

    DbContents getContents() {
        return this.contents;
    }

    void setShutdownServerOnDisconnect() {
        this.shutdownServerOnDisconnect = true;
    }

    boolean getShutdownServerOnDisconnect() {
        return this.shutdownServerOnDisconnect;
    }

    void close() {
        if (this.executingStatement != null) {
            try {
                this.executingStatement.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

