/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.store;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.h2.upgrade.v1_1.constant.SysProperties;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.store.DataHandler;
import org.h2.upgrade.v1_1.store.DataPage;
import org.h2.upgrade.v1_1.util.DateTimeUtils;
import org.h2.upgrade.v1_1.util.MathUtils;
import org.h2.upgrade.v1_1.util.MemoryUtils;
import org.h2.upgrade.v1_1.value.Value;
import org.h2.upgrade.v1_1.value.ValueArray;
import org.h2.upgrade.v1_1.value.ValueBoolean;
import org.h2.upgrade.v1_1.value.ValueByte;
import org.h2.upgrade.v1_1.value.ValueBytes;
import org.h2.upgrade.v1_1.value.ValueDate;
import org.h2.upgrade.v1_1.value.ValueDecimal;
import org.h2.upgrade.v1_1.value.ValueDouble;
import org.h2.upgrade.v1_1.value.ValueFloat;
import org.h2.upgrade.v1_1.value.ValueInt;
import org.h2.upgrade.v1_1.value.ValueJavaObject;
import org.h2.upgrade.v1_1.value.ValueLob;
import org.h2.upgrade.v1_1.value.ValueLong;
import org.h2.upgrade.v1_1.value.ValueNull;
import org.h2.upgrade.v1_1.value.ValueShort;
import org.h2.upgrade.v1_1.value.ValueString;
import org.h2.upgrade.v1_1.value.ValueStringFixed;
import org.h2.upgrade.v1_1.value.ValueStringIgnoreCase;
import org.h2.upgrade.v1_1.value.ValueTime;
import org.h2.upgrade.v1_1.value.ValueTimestamp;
import org.h2.upgrade.v1_1.value.ValueUuid;

public class Data
extends DataPage {
    private static final int TEST_OFFSET = 0;
    private static final int INT_0_15 = 32;
    private static final int LONG_0_7 = 48;
    private static final int DECIMAL_0_1 = 56;
    private static final int DECIMAL_SMALL_0 = 58;
    private static final int DECIMAL_SMALL = 59;
    private static final int DOUBLE_0_1 = 60;
    private static final int FLOAT_0_1 = 62;
    private static final int BOOLEAN_FALSE = 64;
    private static final int BOOLEAN_TRUE = 65;
    private static final int INT_NEG = 66;
    private static final int LONG_NEG = 67;
    private static final int STRING_0_31 = 68;
    private static final int BYTES_0_31 = 100;
    private static final long MILLIS_PER_MINUTE = 60000L;

    private Data(DataHandler dataHandler, byte[] byArray) {
        super(dataHandler, byArray);
    }

    public void setInt(int n, int n2) {
        byte[] byArray = this.data;
        byArray[n] = (byte)(n2 >> 24);
        byArray[n + 1] = (byte)(n2 >> 16);
        byArray[n + 2] = (byte)(n2 >> 8);
        byArray[n + 3] = (byte)n2;
    }

    public void writeInt(int n) {
        byte[] byArray = this.data;
        byArray[this.pos] = (byte)(n >> 24);
        byArray[this.pos + 1] = (byte)(n >> 16);
        byArray[this.pos + 2] = (byte)(n >> 8);
        byArray[this.pos + 3] = (byte)n;
        this.pos += 4;
    }

    public int readInt() {
        byte[] byArray = this.data;
        int n = (byArray[this.pos] << 24) + ((byArray[this.pos + 1] & 0xFF) << 16) + ((byArray[this.pos + 2] & 0xFF) << 8) + (byArray[this.pos + 3] & 0xFF);
        this.pos += 4;
        return n;
    }

    public int getStringLen(String string) {
        int n = string.length();
        return this.getStringWithoutLengthLen(string, n) + this.getVarIntLen(n);
    }

    private int getStringWithoutLengthLen(String string, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0800') {
                n2 += 2;
                continue;
            }
            if (c < '\u0080') continue;
            ++n2;
        }
        return n + n2;
    }

    public String readString() {
        int n = this.readVarInt();
        return this.readString(n);
    }

    private String readString(int n) {
        byte[] byArray = this.data;
        int n2 = this.pos;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            int n3;
            cArray[i] = (n3 = byArray[n2++] & 0xFF) < 128 ? (char)n3 : (n3 >= 224 ? (char)(((n3 & 0xF) << 12) + ((byArray[n2++] & 0x3F) << 6) + (byArray[n2++] & 0x3F)) : (char)(((n3 & 0x1F) << 6) + (byArray[n2++] & 0x3F)));
        }
        this.pos = n2;
        return new String(cArray);
    }

    public void writeString(String string) {
        int n = string.length();
        this.writeVarInt(n);
        this.writeStringWithoutLength(string, n);
    }

    private void writeStringWithoutLength(String string, int n) {
        int n2 = this.pos;
        byte[] byArray = this.data;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '\u0080') {
                byArray[n2++] = (byte)c;
                continue;
            }
            if (c >= '\u0800') {
                byArray[n2++] = (byte)(0xE0 | c >> 12);
                byArray[n2++] = (byte)(c >> 6 & 0x3F);
                byArray[n2++] = (byte)(c & 0x3F);
                continue;
            }
            byArray[n2++] = (byte)(0xC0 | c >> 6);
            byArray[n2++] = (byte)(c & 0x3F);
        }
        this.pos = n2;
    }

    public void fill(int n) {
        if (this.pos > n) {
            this.pos = n;
        }
        this.pos = n;
    }

    public static Data create(DataHandler dataHandler, int n) {
        return new Data(dataHandler, new byte[n]);
    }

    public static Data create(DataHandler dataHandler, byte[] byArray) {
        return new Data(dataHandler, byArray);
    }

    public int length() {
        return this.pos;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public void reset() {
        this.pos = 0;
    }

    public void writeDataPageNoSize(Data data) {
        int n = data.pos - 2;
        System.arraycopy(data.data, 0, this.data, this.pos, n);
        this.pos += n;
    }

    public void write(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this.data, this.pos, n2);
        this.pos += n2;
    }

    public void read(byte[] byArray, int n, int n2) {
        System.arraycopy(this.data, this.pos, byArray, n, n2);
        this.pos += n2;
    }

    public void writeByte(byte by) {
        this.data[this.pos++] = by;
    }

    public int readByte() {
        return this.data[this.pos++];
    }

    public long readLong() {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public void writeLong(long l) {
        this.writeInt((int)(l >>> 32));
        this.writeInt((int)l);
    }

    public void writeValue(Value value) throws SQLException {
        int n = this.pos;
        if (value == ValueNull.INSTANCE) {
            this.data[this.pos++] = 0;
            return;
        }
        int n2 = value.getType();
        switch (n2) {
            case 1: {
                this.writeByte((byte)(value.getBoolean() != false ? 65 : 64));
                break;
            }
            case 2: {
                this.writeByte((byte)n2);
                this.writeByte(value.getByte());
                break;
            }
            case 3: {
                this.writeByte((byte)n2);
                this.writeShortInt(value.getShort());
                break;
            }
            case 4: {
                int n3 = value.getInt();
                if (n3 < 0) {
                    this.writeByte((byte)66);
                    this.writeVarInt(-n3);
                    break;
                }
                if (n3 < 16) {
                    this.writeByte((byte)(32 + n3));
                    break;
                }
                this.writeByte((byte)n2);
                this.writeVarInt(n3);
                break;
            }
            case 5: {
                long l = value.getLong();
                if (l < 0L) {
                    this.writeByte((byte)67);
                    this.writeVarLong(-l);
                    break;
                }
                if (l < 8L) {
                    this.writeByte((byte)(48L + l));
                    break;
                }
                this.writeByte((byte)n2);
                this.writeVarLong(l);
                break;
            }
            case 6: {
                BigDecimal bigDecimal = value.getBigDecimal();
                if (BigDecimal.ZERO.equals(bigDecimal)) {
                    this.writeByte((byte)56);
                    break;
                }
                if (BigDecimal.ONE.equals(bigDecimal)) {
                    this.writeByte((byte)57);
                    break;
                }
                int n4 = bigDecimal.scale();
                BigInteger bigInteger = bigDecimal.unscaledValue();
                int n5 = bigInteger.bitLength();
                if (n5 <= 63) {
                    if (n4 == 0) {
                        this.writeByte((byte)58);
                        this.writeVarLong(bigInteger.longValue());
                        break;
                    }
                    this.writeByte((byte)59);
                    this.writeVarInt(n4);
                    this.writeVarLong(bigInteger.longValue());
                    break;
                }
                this.writeByte((byte)n2);
                this.writeVarInt(n4);
                byte[] byArray = bigInteger.toByteArray();
                this.writeVarInt(byArray.length);
                this.write(byArray, 0, byArray.length);
                break;
            }
            case 9: {
                this.writeByte((byte)n2);
                this.writeVarLong(DateTimeUtils.getTimeLocal(value.getTimeNoCopy()));
                break;
            }
            case 10: {
                this.writeByte((byte)n2);
                long l = DateTimeUtils.getTimeLocal(value.getDateNoCopy());
                this.writeVarLong(l / 60000L);
                break;
            }
            case 11: {
                this.writeByte((byte)n2);
                Timestamp timestamp = value.getTimestampNoCopy();
                this.writeVarLong(DateTimeUtils.getTimeLocal(timestamp));
                this.writeVarInt(timestamp.getNanos());
                break;
            }
            case 19: {
                this.writeByte((byte)n2);
                byte[] byArray = value.getBytesNoCopy();
                this.writeVarInt(byArray.length);
                this.write(byArray, 0, byArray.length);
                break;
            }
            case 12: {
                byte[] byArray = value.getBytesNoCopy();
                int n6 = byArray.length;
                if (n6 < 32) {
                    this.writeByte((byte)(100 + n6));
                    this.write(byArray, 0, byArray.length);
                    break;
                }
                this.writeByte((byte)n2);
                this.writeVarInt(byArray.length);
                this.write(byArray, 0, byArray.length);
                break;
            }
            case 20: {
                this.writeByte((byte)n2);
                ValueUuid valueUuid = (ValueUuid)value;
                this.writeLong(valueUuid.getHigh());
                this.writeLong(valueUuid.getLow());
                break;
            }
            case 13: {
                String string = value.getString();
                int n7 = string.length();
                if (n7 < 32) {
                    this.writeByte((byte)(68 + n7));
                    this.writeStringWithoutLength(string, n7);
                    break;
                }
                this.writeByte((byte)n2);
                this.writeString(string);
                break;
            }
            case 14: 
            case 21: {
                this.writeByte((byte)n2);
                this.writeString(value.getString());
                break;
            }
            case 7: {
                double d = value.getDouble();
                if (d == 0.0 || d == 1.0) {
                    this.writeByte((byte)(60.0 + d));
                    break;
                }
                this.writeByte((byte)n2);
                this.writeVarLong(MathUtils.reverse(Double.doubleToLongBits(d)));
                break;
            }
            case 8: {
                float f = value.getFloat();
                if (f == 0.0f || f == 1.0f) {
                    this.writeByte((byte)(62.0f + f));
                    break;
                }
                this.writeByte((byte)n2);
                this.writeVarInt(MathUtils.reverse(Float.floatToIntBits(value.getFloat())));
                break;
            }
            case 15: 
            case 16: {
                this.writeByte((byte)n2);
                ValueLob valueLob = (ValueLob)value;
                valueLob.convertToFileIfRequired(this.handler);
                byte[] byArray = valueLob.getSmall();
                if (byArray == null) {
                    int n8 = -1;
                    if (!valueLob.isLinked()) {
                        n8 = -2;
                    }
                    this.writeVarInt(n8);
                    this.writeVarInt(valueLob.getTableId());
                    this.writeVarInt(valueLob.getObjectId());
                    this.writeVarLong(valueLob.getPrecision());
                    this.writeByte((byte)(valueLob.useCompression() ? 1 : 0));
                    if (n8 != -2) break;
                    this.writeString(valueLob.getFileName());
                    break;
                }
                this.writeVarInt(byArray.length);
                this.write(byArray, 0, byArray.length);
                break;
            }
            case 17: {
                this.writeByte((byte)n2);
                Value[] valueArray = ((ValueArray)value).getList();
                this.writeVarInt(valueArray.length);
                for (Value value2 : valueArray) {
                    this.writeValue(value2);
                }
                break;
            }
            default: {
                Message.throwInternalError("type=" + value.getType());
            }
        }
        if (SysProperties.CHECK2 && this.pos - n != this.getValueLen(value)) {
            throw Message.throwInternalError("value size error: got " + (this.pos - n) + " expected " + this.getValueLen(value));
        }
    }

    public Value readValue() throws SQLException {
        int n = this.data[this.pos++] & 0xFF;
        switch (n) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 65: {
                return ValueBoolean.get(true);
            }
            case 64: {
                return ValueBoolean.get(false);
            }
            case 66: {
                return ValueInt.get(-this.readVarInt());
            }
            case 4: {
                return ValueInt.get(this.readVarInt());
            }
            case 67: {
                return ValueLong.get(-this.readVarLong());
            }
            case 5: {
                return ValueLong.get(this.readVarLong());
            }
            case 2: {
                return ValueByte.get((byte)this.readByte());
            }
            case 3: {
                return ValueShort.get((short)this.readShortInt());
            }
            case 56: {
                return (ValueDecimal)ValueDecimal.ZERO;
            }
            case 57: {
                return (ValueDecimal)ValueDecimal.ONE;
            }
            case 58: {
                return ValueDecimal.get(BigDecimal.valueOf(this.readVarLong()));
            }
            case 59: {
                int n2 = this.readVarInt();
                return ValueDecimal.get(BigDecimal.valueOf(this.readVarLong(), n2));
            }
            case 6: {
                int n3 = this.readVarInt();
                int n4 = this.readVarInt();
                byte[] byArray = MemoryUtils.newBytes(n4);
                this.read(byArray, 0, n4);
                BigInteger bigInteger = new BigInteger(byArray);
                return ValueDecimal.get(new BigDecimal(bigInteger, n3));
            }
            case 10: {
                long l = this.readVarLong() * 60000L;
                return ValueDate.getNoCopy(new Date(DateTimeUtils.getTimeGMT(l)));
            }
            case 9: {
                return ValueTime.get(new Time(DateTimeUtils.getTimeGMT(this.readVarLong())));
            }
            case 11: {
                Timestamp timestamp = new Timestamp(DateTimeUtils.getTimeGMT(this.readVarLong()));
                timestamp.setNanos(this.readVarInt());
                return ValueTimestamp.getNoCopy(timestamp);
            }
            case 12: {
                int n5 = this.readVarInt();
                byte[] byArray = MemoryUtils.newBytes(n5);
                this.read(byArray, 0, n5);
                return ValueBytes.getNoCopy(byArray);
            }
            case 19: {
                int n6 = this.readVarInt();
                byte[] byArray = MemoryUtils.newBytes(n6);
                this.read(byArray, 0, n6);
                return ValueJavaObject.getNoCopy(byArray);
            }
            case 20: {
                return ValueUuid.get(this.readLong(), this.readLong());
            }
            case 13: {
                return ValueString.get(this.readString());
            }
            case 14: {
                return ValueStringIgnoreCase.get(this.readString());
            }
            case 21: {
                return ValueStringFixed.get(this.readString());
            }
            case 62: {
                return ValueFloat.get(0.0f);
            }
            case 63: {
                return ValueFloat.get(1.0f);
            }
            case 60: {
                return ValueDouble.get(0.0);
            }
            case 61: {
                return ValueDouble.get(1.0);
            }
            case 7: {
                return ValueDouble.get(Double.longBitsToDouble(MathUtils.reverse(this.readVarLong())));
            }
            case 8: {
                return ValueFloat.get(Float.intBitsToFloat(MathUtils.reverse(this.readVarInt())));
            }
            case 15: 
            case 16: {
                int n7 = this.readVarInt();
                if (n7 >= 0) {
                    byte[] byArray = MemoryUtils.newBytes(n7);
                    this.read(byArray, 0, n7);
                    return ValueLob.createSmallLob(n, byArray);
                }
                int n8 = this.readVarInt();
                int n9 = this.readVarInt();
                long l = 0L;
                boolean bl = false;
                if (n7 == -1 || n7 == -2) {
                    l = this.readVarLong();
                    bl = this.readByte() == 1;
                }
                ValueLob valueLob = ValueLob.open(n, this.handler, n8, n9, l, bl);
                if (n7 == -2) {
                    valueLob.setFileName(this.readString(), false);
                }
                return valueLob;
            }
            case 17: {
                int n10 = this.readVarInt();
                Value[] valueArray = new Value[n10];
                for (int i = 0; i < n10; ++i) {
                    valueArray[i] = this.readValue();
                }
                return ValueArray.get(valueArray);
            }
        }
        if (n >= 32 && n < 48) {
            return ValueInt.get(n - 32);
        }
        if (n >= 48 && n < 56) {
            return ValueLong.get(n - 48);
        }
        if (n >= 100 && n < 132) {
            int n11 = n - 100;
            byte[] byArray = MemoryUtils.newBytes(n11);
            this.read(byArray, 0, n11);
            return ValueBytes.getNoCopy(byArray);
        }
        if (n >= 68 && n < 100) {
            return ValueString.get(this.readString(n - 68));
        }
        throw Message.getSQLException(90030, "type: " + n);
    }

    public int getValueLen(Value value) throws SQLException {
        return this.getValueLen2(value) + 0;
    }

    private int getValueLen2(Value value) throws SQLException {
        if (value == ValueNull.INSTANCE) {
            return 1;
        }
        switch (value.getType()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                int n = value.getInt();
                if (n < 0) {
                    return 1 + this.getVarIntLen(-n);
                }
                if (n < 16) {
                    return 1;
                }
                return 1 + this.getVarIntLen(n);
            }
            case 5: {
                long l = value.getLong();
                if (l < 0L) {
                    return 1 + this.getVarLongLen(-l);
                }
                if (l < 8L) {
                    return 1;
                }
                return 1 + this.getVarLongLen(l);
            }
            case 7: {
                double d = value.getDouble();
                if (d == 0.0 || d == 1.0) {
                    return 1;
                }
                return 1 + this.getVarLongLen(MathUtils.reverse(Double.doubleToLongBits(d)));
            }
            case 8: {
                float f = value.getFloat();
                if (f == 0.0f || f == 1.0f) {
                    return 1;
                }
                return 1 + this.getVarIntLen(MathUtils.reverse(Float.floatToIntBits(value.getFloat())));
            }
            case 13: {
                String string = value.getString();
                int n = string.length();
                if (n < 32) {
                    return 1 + this.getStringWithoutLengthLen(string, n);
                }
                return 1 + this.getStringLen(string);
            }
            case 14: 
            case 21: {
                return 1 + this.getStringLen(value.getString());
            }
            case 6: {
                BigDecimal bigDecimal = value.getBigDecimal();
                if (BigDecimal.ZERO.equals(bigDecimal)) {
                    return 1;
                }
                if (BigDecimal.ONE.equals(bigDecimal)) {
                    return 1;
                }
                int n = bigDecimal.scale();
                BigInteger bigInteger = bigDecimal.unscaledValue();
                int n2 = bigInteger.bitLength();
                if (n2 <= 63) {
                    if (n == 0) {
                        return 1 + this.getVarLongLen(bigInteger.longValue());
                    }
                    return 1 + this.getVarIntLen(n) + this.getVarLongLen(bigInteger.longValue());
                }
                byte[] byArray = bigInteger.toByteArray();
                return 1 + this.getVarIntLen(n) + this.getVarIntLen(byArray.length) + byArray.length;
            }
            case 9: {
                return 1 + this.getVarLongLen(DateTimeUtils.getTimeLocal(value.getTimeNoCopy()));
            }
            case 10: {
                long l = DateTimeUtils.getTimeLocal(value.getDateNoCopy());
                return 1 + this.getVarLongLen(l / 60000L);
            }
            case 11: {
                Timestamp timestamp = value.getTimestampNoCopy();
                return 1 + this.getVarLongLen(DateTimeUtils.getTimeLocal(timestamp)) + this.getVarIntLen(timestamp.getNanos());
            }
            case 19: {
                byte[] byArray = value.getBytesNoCopy();
                return 1 + this.getVarIntLen(byArray.length) + byArray.length;
            }
            case 12: {
                byte[] byArray = value.getBytesNoCopy();
                int n = byArray.length;
                if (n < 32) {
                    return 1 + byArray.length;
                }
                return 1 + this.getVarIntLen(byArray.length) + byArray.length;
            }
            case 20: {
                return 17;
            }
            case 15: 
            case 16: {
                int n = 1;
                ValueLob valueLob = (ValueLob)value;
                valueLob.convertToFileIfRequired(this.handler);
                byte[] byArray = valueLob.getSmall();
                if (byArray == null) {
                    int n3 = -1;
                    if (!valueLob.isLinked()) {
                        n3 = -2;
                    }
                    n += this.getVarIntLen(n3);
                    n += this.getVarIntLen(valueLob.getTableId());
                    n += this.getVarIntLen(valueLob.getObjectId());
                    n += this.getVarLongLen(valueLob.getPrecision());
                    ++n;
                    if (n3 == -2) {
                        n += this.getStringLen(valueLob.getFileName());
                    }
                } else {
                    n += this.getVarIntLen(byArray.length);
                    n += byArray.length;
                }
                return n;
            }
            case 17: {
                Value[] valueArray = ((ValueArray)value).getList();
                int n = 1 + this.getVarIntLen(valueArray.length);
                for (Value value2 : valueArray) {
                    n += this.getValueLen(value2);
                }
                return n;
            }
        }
        throw Message.throwInternalError("type=" + value.getType());
    }

    public void setPos(int n) {
        this.pos = n;
    }

    public void writeShortInt(int n) {
        byte[] byArray = this.data;
        byArray[this.pos++] = (byte)(n >> 8);
        byArray[this.pos++] = (byte)n;
    }

    public int readShortInt() {
        byte[] byArray = this.data;
        return ((byArray[this.pos++] & 0xFF) << 8) + (byArray[this.pos++] & 0xFF);
    }

    public void truncate(int n) {
        if (this.pos > n) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.data, 0, byArray, 0, n);
            this.pos = n;
            this.data = byArray;
        }
    }

    private int getVarIntLen(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void writeVarInt(int n) {
        while ((n & 0xFFFFFF80) != 0) {
            this.data[this.pos++] = (byte)(0x80 | n & 0x7F);
            n >>>= 7;
        }
        this.data[this.pos++] = (byte)n;
    }

    public int readVarInt() {
        byte by = this.data[this.pos];
        if (by >= 0) {
            ++this.pos;
            return by;
        }
        int n = by & 0x7F;
        by = this.data[this.pos + 1];
        if (by >= 0) {
            this.pos += 2;
            return n | by << 7;
        }
        n |= (by & 0x7F) << 7;
        by = this.data[this.pos + 2];
        if (by >= 0) {
            this.pos += 3;
            return n | by << 14;
        }
        n |= (by & 0x7F) << 14;
        by = this.data[this.pos + 3];
        if (by >= 0) {
            this.pos += 4;
            return n | by << 21;
        }
        this.pos += 5;
        return n |= (by & 0x7F) << 21 | this.data[this.pos + 4] << 28;
    }

    public int getVarLongLen(long l) {
        int n = 1;
        while ((l >>>= 7) != 0L) {
            ++n;
        }
        return n;
    }

    public void writeVarLong(long l) {
        while ((l & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.data[this.pos++] = (byte)(l & 0x7FL | 0x80L);
            l >>>= 7;
        }
        this.data[this.pos++] = (byte)l;
    }

    public long readVarLong() {
        long l;
        if ((l = (long)this.data[this.pos++]) >= 0L) {
            return l;
        }
        l &= 0x7FL;
        int n = 7;
        while (true) {
            long l2 = this.data[this.pos++];
            l |= (l2 & 0x7FL) << n;
            if (l2 >= 0L) {
                return l;
            }
            n += 7;
        }
    }
}

