/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.store.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.h2.upgrade.v1_1.store.fs.FileObject;

public class FileObjectDiskChannel
implements FileObject {
    private final String name;
    private FileChannel channel;

    FileObjectDiskChannel(String string, String string2) throws FileNotFoundException {
        this.name = string;
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, string2);
        this.channel = randomAccessFile.getChannel();
    }

    public void close() throws IOException {
        this.channel.close();
    }

    public long getFilePointer() throws IOException {
        return this.channel.position();
    }

    public String getName() {
        return this.name;
    }

    public long length() throws IOException {
        return this.channel.size();
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.position(n);
        byteBuffer.limit(n + n2);
        this.channel.read(byteBuffer);
    }

    public void seek(long l) throws IOException {
        this.channel.position(l);
    }

    public void setFileLength(long l) throws IOException {
        if (l <= this.channel.size()) {
            long l2 = this.channel.position();
            this.channel.truncate(l);
            if (l2 > l) {
                l2 = l;
            }
            this.channel.position(l2);
        } else {
            ByteBuffer byteBuffer = ByteBuffer.allocate(1);
            this.channel.write(byteBuffer, l - 1L);
        }
    }

    public void sync() throws IOException {
        this.channel.force(true);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.position(n);
        byteBuffer.limit(n + n2);
        this.channel.write(byteBuffer);
    }
}

