/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.table;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.Locale;
import org.h2.upgrade.v1_1.command.Command;
import org.h2.upgrade.v1_1.constant.SysProperties;
import org.h2.upgrade.v1_1.constraint.Constraint;
import org.h2.upgrade.v1_1.constraint.ConstraintCheck;
import org.h2.upgrade.v1_1.constraint.ConstraintReferential;
import org.h2.upgrade.v1_1.constraint.ConstraintUnique;
import org.h2.upgrade.v1_1.engine.Constants;
import org.h2.upgrade.v1_1.engine.Database;
import org.h2.upgrade.v1_1.engine.DbObject;
import org.h2.upgrade.v1_1.engine.FunctionAlias;
import org.h2.upgrade.v1_1.engine.Right;
import org.h2.upgrade.v1_1.engine.Role;
import org.h2.upgrade.v1_1.engine.Session;
import org.h2.upgrade.v1_1.engine.Setting;
import org.h2.upgrade.v1_1.engine.User;
import org.h2.upgrade.v1_1.engine.UserAggregate;
import org.h2.upgrade.v1_1.engine.UserDataType;
import org.h2.upgrade.v1_1.expression.ValueExpression;
import org.h2.upgrade.v1_1.index.Index;
import org.h2.upgrade.v1_1.index.IndexType;
import org.h2.upgrade.v1_1.index.MetaIndex;
import org.h2.upgrade.v1_1.log.InDoubtTransaction;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.result.Row;
import org.h2.upgrade.v1_1.result.SearchRow;
import org.h2.upgrade.v1_1.schema.Constant;
import org.h2.upgrade.v1_1.schema.Schema;
import org.h2.upgrade.v1_1.schema.SchemaObject;
import org.h2.upgrade.v1_1.schema.Sequence;
import org.h2.upgrade.v1_1.schema.TriggerObject;
import org.h2.upgrade.v1_1.store.DiskFile;
import org.h2.upgrade.v1_1.store.PageStore;
import org.h2.upgrade.v1_1.table.Column;
import org.h2.upgrade.v1_1.table.IndexColumn;
import org.h2.upgrade.v1_1.table.Table;
import org.h2.upgrade.v1_1.table.TableView;
import org.h2.upgrade.v1_1.tools.Csv;
import org.h2.upgrade.v1_1.util.MathUtils;
import org.h2.upgrade.v1_1.util.ObjectArray;
import org.h2.upgrade.v1_1.util.Resources;
import org.h2.upgrade.v1_1.util.StatementBuilder;
import org.h2.upgrade.v1_1.util.StringUtils;
import org.h2.upgrade.v1_1.value.CompareMode;
import org.h2.upgrade.v1_1.value.DataType;
import org.h2.upgrade.v1_1.value.Value;
import org.h2.upgrade.v1_1.value.ValueNull;
import org.h2.upgrade.v1_1.value.ValueString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaTable
extends Table {
    public static final long ROW_COUNT_APPROXIMATION = 1000L;
    private static final int TABLES = 0;
    private static final int COLUMNS = 1;
    private static final int INDEXES = 2;
    private static final int TABLE_TYPES = 3;
    private static final int TYPE_INFO = 4;
    private static final int CATALOGS = 5;
    private static final int SETTINGS = 6;
    private static final int HELP = 7;
    private static final int SEQUENCES = 8;
    private static final int USERS = 9;
    private static final int ROLES = 10;
    private static final int RIGHTS = 11;
    private static final int FUNCTION_ALIASES = 12;
    private static final int SCHEMATA = 13;
    private static final int TABLE_PRIVILEGES = 14;
    private static final int COLUMN_PRIVILEGES = 15;
    private static final int COLLATIONS = 16;
    private static final int VIEWS = 17;
    private static final int IN_DOUBT = 18;
    private static final int CROSS_REFERENCES = 19;
    private static final int CONSTRAINTS = 20;
    private static final int FUNCTION_COLUMNS = 21;
    private static final int CONSTANTS = 22;
    private static final int DOMAINS = 23;
    private static final int TRIGGERS = 24;
    private static final int SESSIONS = 25;
    private static final int LOCKS = 26;
    private static final int SESSION_STATE = 27;
    private static final int META_TABLE_TYPE_COUNT = 28;
    private final int type;
    private final int indexColumn;
    private MetaIndex metaIndex;

    public MetaTable(Schema schema, int n, int n2) throws SQLException {
        super(schema, n, null, true, true);
        Column[] columnArray;
        this.type = n2;
        String string = null;
        switch (n2) {
            case 0: {
                this.setObjectName("TABLES");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "TABLE_TYPE", "STORAGE_TYPE", "SQL", "REMARKS", "LAST_MODIFICATION BIGINT", "ID INT", "TYPE_NAME");
                string = "TABLE_NAME";
                break;
            }
            case 1: {
                this.setObjectName("COLUMNS");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "ORDINAL_POSITION INT", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE INT", "CHARACTER_MAXIMUM_LENGTH INT", "CHARACTER_OCTET_LENGTH INT", "NUMERIC_PRECISION INT", "NUMERIC_PRECISION_RADIX INT", "NUMERIC_SCALE INT", "CHARACTER_SET_NAME", "COLLATION_NAME", "TYPE_NAME", "NULLABLE INT", "IS_COMPUTED BIT", "SELECTIVITY INT", "CHECK_CONSTRAINT", "SEQUENCE_NAME", "REMARKS", "SOURCE_DATA_TYPE SMALLINT");
                string = "TABLE_NAME";
                break;
            }
            case 2: {
                this.setObjectName("INDEXES");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "NON_UNIQUE BIT", "INDEX_NAME", "ORDINAL_POSITION SMALLINT", "COLUMN_NAME", "CARDINALITY INT", "PRIMARY_KEY BIT", "INDEX_TYPE_NAME", "IS_GENERATED BIT", "INDEX_TYPE SMALLINT", "ASC_OR_DESC", "PAGES INT", "FILTER_CONDITION", "REMARKS", "SQL", "ID INT", "SORT_TYPE INT", "CONSTRAINT_NAME");
                string = "TABLE_NAME";
                break;
            }
            case 3: {
                this.setObjectName("TABLE_TYPES");
                columnArray = this.createColumns("TYPE");
                break;
            }
            case 4: {
                this.setObjectName("TYPE_INFO");
                columnArray = this.createColumns("TYPE_NAME", "DATA_TYPE INT", "PRECISION INT", "PREFIX", "SUFFIX", "PARAMS", "AUTO_INCREMENT BIT", "MINIMUM_SCALE SMALLINT", "MAXIMUM_SCALE SMALLINT", "RADIX INT", "POS INT", "CASE_SENSITIVE BIT", "NULLABLE SMALLINT", "SEARCHABLE SMALLINT");
                break;
            }
            case 5: {
                this.setObjectName("CATALOGS");
                columnArray = this.createColumns("CATALOG_NAME");
                break;
            }
            case 6: {
                this.setObjectName("SETTINGS");
                columnArray = this.createColumns("NAME", "VALUE");
                break;
            }
            case 7: {
                this.setObjectName("HELP");
                columnArray = this.createColumns("ID INT", "SECTION", "TOPIC", "SYNTAX", "TEXT");
                break;
            }
            case 8: {
                this.setObjectName("SEQUENCES");
                columnArray = this.createColumns("SEQUENCE_CATALOG", "SEQUENCE_SCHEMA", "SEQUENCE_NAME", "CURRENT_VALUE BIGINT", "INCREMENT BIGINT", "IS_GENERATED BIT", "REMARKS", "CACHE BIGINT", "ID INT");
                break;
            }
            case 9: {
                this.setObjectName("USERS");
                columnArray = this.createColumns("NAME", "ADMIN", "REMARKS", "ID INT");
                break;
            }
            case 10: {
                this.setObjectName("ROLES");
                columnArray = this.createColumns("NAME", "REMARKS", "ID INT");
                break;
            }
            case 11: {
                this.setObjectName("RIGHTS");
                columnArray = this.createColumns("GRANTEE", "GRANTEETYPE", "GRANTEDROLE", "RIGHTS", "TABLE_SCHEMA", "TABLE_NAME", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 12: {
                this.setObjectName("FUNCTION_ALIASES");
                columnArray = this.createColumns("ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "DATA_TYPE INT", "COLUMN_COUNT INT", "RETURNS_RESULT SMALLINT", "REMARKS", "ID INT", "SOURCE");
                break;
            }
            case 21: {
                this.setObjectName("FUNCTION_COLUMNS");
                columnArray = this.createColumns("ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "COLUMN_COUNT INT", "POS INT", "COLUMN_NAME", "DATA_TYPE INT", "TYPE_NAME", "PRECISION INT", "SCALE SMALLINT", "RADIX SMALLINT", "NULLABLE SMALLINT", "COLUMN_TYPE SMALLINT", "REMARKS", "COLUMN_DEFAULT");
                break;
            }
            case 13: {
                this.setObjectName("SCHEMATA");
                columnArray = this.createColumns("CATALOG_NAME", "SCHEMA_NAME", "SCHEMA_OWNER", "DEFAULT_CHARACTER_SET_NAME", "DEFAULT_COLLATION_NAME", "IS_DEFAULT BIT", "REMARKS", "ID INT");
                break;
            }
            case 14: {
                this.setObjectName("TABLE_PRIVILEGES");
                columnArray = this.createColumns("GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE");
                string = "TABLE_NAME";
                break;
            }
            case 15: {
                this.setObjectName("COLUMN_PRIVILEGES");
                columnArray = this.createColumns("GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE");
                string = "TABLE_NAME";
                break;
            }
            case 16: {
                this.setObjectName("COLLATIONS");
                columnArray = this.createColumns("NAME", "KEY");
                break;
            }
            case 17: {
                this.setObjectName("VIEWS");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "VIEW_DEFINITION", "CHECK_OPTION", "IS_UPDATABLE", "STATUS", "REMARKS", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 18: {
                this.setObjectName("IN_DOUBT");
                columnArray = this.createColumns("TRANSACTION", "STATE");
                break;
            }
            case 19: {
                this.setObjectName("CROSS_REFERENCES");
                columnArray = this.createColumns("PKTABLE_CATALOG", "PKTABLE_SCHEMA", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CATALOG", "FKTABLE_SCHEMA", "FKTABLE_NAME", "FKCOLUMN_NAME", "ORDINAL_POSITION SMALLINT", "UPDATE_RULE SMALLINT", "DELETE_RULE SMALLINT", "FK_NAME", "PK_NAME", "DEFERRABILITY SMALLINT");
                string = "PKTABLE_NAME";
                break;
            }
            case 20: {
                this.setObjectName("CONSTRAINTS");
                columnArray = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "CONSTRAINT_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "UNIQUE_INDEX_NAME", "CHECK_EXPRESSION", "COLUMN_LIST", "REMARKS", "SQL", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 22: {
                this.setObjectName("CONSTANTS");
                columnArray = this.createColumns("CONSTANT_CATALOG", "CONSTANT_SCHEMA", "CONSTANT_NAME", "DATA_TYPE INT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 23: {
                this.setObjectName("DOMAINS");
                columnArray = this.createColumns("DOMAIN_CATALOG", "DOMAIN_SCHEMA", "DOMAIN_NAME", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE INT", "PRECISION INT", "SCALE INT", "TYPE_NAME", "SELECTIVITY INT", "CHECK_CONSTRAINT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 24: {
                this.setObjectName("TRIGGERS");
                columnArray = this.createColumns("TRIGGER_CATALOG", "TRIGGER_SCHEMA", "TRIGGER_NAME", "TRIGGER_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "BEFORE BIT", "JAVA_CLASS", "QUEUE_SIZE INT", "NO_WAIT BIT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 25: {
                this.setObjectName("SESSIONS");
                columnArray = this.createColumns("ID INT", "USER_NAME", "SESSION_START", "STATEMENT", "STATEMENT_START");
                break;
            }
            case 26: {
                this.setObjectName("LOCKS");
                columnArray = this.createColumns("TABLE_SCHEMA", "TABLE_NAME", "SESSION_ID INT", "LOCK_TYPE");
                break;
            }
            case 27: {
                this.setObjectName("SESSION_STATE");
                columnArray = this.createColumns("KEY", "SQL");
                break;
            }
            default: {
                throw Message.throwInternalError("type=" + n2);
            }
        }
        this.setColumns(columnArray);
        if (string == null) {
            this.indexColumn = -1;
        } else {
            this.indexColumn = this.getColumn(string).getColumnId();
            IndexColumn[] indexColumnArray = IndexColumn.wrap(new Column[]{columnArray[this.indexColumn]});
            this.metaIndex = new MetaIndex(this, indexColumnArray, false);
        }
    }

    private Column[] createColumns(String ... stringArray) {
        Column[] columnArray = new Column[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            int n;
            String string2 = stringArray[i];
            int n2 = string2.indexOf(32);
            if (n2 < 0) {
                n = 13;
                string = string2;
            } else {
                n = DataType.getTypeByName((String)string2.substring((int)(n2 + 1))).type;
                string = string2.substring(0, n2);
            }
            columnArray[i] = new Column(string, n);
        }
        return columnArray;
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, int n2, String string2) throws SQLException {
        throw Message.getUnsupportedException("META");
    }

    @Override
    public void lock(Session session, boolean bl, boolean bl2) {
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    private String identifier(String string) {
        if (this.database.getMode().lowerCaseIdentifiers) {
            string = string == null ? null : StringUtils.toLowerEnglish(string);
        }
        return string;
    }

    private ObjectArray<Table> getAllTables(Session session) {
        ObjectArray<Table> objectArray = this.database.getAllTablesAndViews(true);
        ObjectArray<Table> objectArray2 = session.getLocalTempTables();
        objectArray.addAll(objectArray2);
        return objectArray;
    }

    private boolean checkIndex(Session session, String string, Value value, Value value2) throws SQLException {
        if (string == null || value == null && value2 == null) {
            return true;
        }
        Database database = session.getDatabase();
        ValueString valueString = ValueString.get(string);
        if (value != null && database.compare(valueString, value) < 0) {
            return false;
        }
        return value2 == null || database.compare(valueString, value2) <= 0;
    }

    private String replaceNullWithEmpty(String string) {
        return string == null ? "" : string;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectArray<Row> generateRows(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        Value value = null;
        Value value2 = null;
        if (this.indexColumn >= 0) {
            if (searchRow != null) {
                value = searchRow.getValue(this.indexColumn);
            }
            if (searchRow2 != null) {
                value2 = searchRow2.getValue(this.indexColumn);
            }
        }
        ObjectArray<Row> objectArray = ObjectArray.newInstance();
        String string = this.identifier(this.database.getShortName());
        switch (this.type) {
            case 0: {
                for (Table table : this.getAllTables(session)) {
                    String sequence = this.identifier(table.getName());
                    if (!this.checkIndex(session, sequence, value, value2)) continue;
                    String string2 = table.isTemporary() ? (table.isGlobalTemporary() ? "GLOBAL TEMPORARY" : "LOCAL TEMPORARY") : (table.isPersistIndexes() ? "CACHED" : "MEMORY");
                    this.add(objectArray, string, this.identifier(table.getSchema().getName()), sequence, table.getTableType(), string2, table.getCreateSQL(), this.replaceNullWithEmpty(table.getComment()), "" + table.getMaxDataModificationId(), "" + table.getId(), null);
                }
                break;
            }
            case 1: {
                for (Table table : this.getAllTables(session)) {
                    String role = this.identifier(table.getName());
                    if (!this.checkIndex(session, role, value, value2)) continue;
                    Column[] columnArray = table.getColumns();
                    String string3 = this.database.getCompareMode().getName();
                    for (int indexColumnArray2 = 0; indexColumnArray2 < columnArray.length; ++indexColumnArray2) {
                        Column column = columnArray[indexColumnArray2];
                        Sequence sequence = column.getSequence();
                        this.add(objectArray, string, this.identifier(table.getSchema().getName()), role, this.identifier(column.getName()), String.valueOf(indexColumnArray2 + 1), column.getDefaultSQL(), column.isNullable() ? "YES" : "NO", "" + DataType.convertTypeToSQLType(column.getType()), "" + column.getPrecisionAsInt(), "" + column.getPrecisionAsInt(), "" + column.getPrecisionAsInt(), "10", "" + column.getScale(), "Unicode", string3, this.identifier(DataType.getDataType((int)column.getType()).name), "" + (column.isNullable() ? 1 : 0), "" + (column.getComputed() ? "TRUE" : "FALSE"), "" + column.getSelectivity(), column.getCheckConstraintSQL(session, column.getName()), sequence == null ? null : sequence.getName(), this.replaceNullWithEmpty(column.getComment()), null);
                    }
                }
                break;
            }
            case 2: {
                for (Table table : this.getAllTables(session)) {
                    String string4 = this.identifier(table.getName());
                    if (!this.checkIndex(session, string4, value, value2)) continue;
                    ObjectArray<Index> string15 = table.getIndexes();
                    ObjectArray<Constraint> dbObject = table.getConstraints();
                    for (int indexColumnArray = 0; string15 != null && indexColumnArray < string15.size(); ++indexColumnArray) {
                        Index index = string15.get(indexColumnArray);
                        if (index.getCreateSQL() == null) continue;
                        String string5 = null;
                        for (int i = 0; dbObject != null && i < dbObject.size(); ++i) {
                            Constraint constraint = dbObject.get(i);
                            if (constraint.getUniqueIndex() != index) continue;
                            if (index.getIndexType().isPrimaryKey()) {
                                if (!constraint.getConstraintType().equals("PRIMARY KEY")) continue;
                                string5 = constraint.getName();
                                continue;
                            }
                            string5 = constraint.getName();
                        }
                        IndexColumn[] indexColumnArray2 = index.getIndexColumns();
                        for (int i = 0; i < indexColumnArray2.length; ++i) {
                            IndexColumn indexColumn = indexColumnArray2[i];
                            Column column = indexColumn.column;
                            this.add(objectArray, string, this.identifier(table.getSchema().getName()), string4, index.getIndexType().isUnique() ? "FALSE" : "TRUE", this.identifier(index.getName()), "" + (i + 1), this.identifier(column.getName()), "0", index.getIndexType().isPrimaryKey() ? "TRUE" : "FALSE", index.getIndexType().getSQL(), index.getIndexType().getBelongsToConstraint() ? "TRUE" : "FALSE", "3", (indexColumn.sortType & 1) != 0 ? "D" : "A", "0", "", this.replaceNullWithEmpty(index.getComment()), index.getSQL(), "" + index.getId(), "" + indexColumn.sortType, string5);
                        }
                    }
                }
                break;
            }
            case 3: {
                this.add(objectArray, "TABLE");
                this.add(objectArray, "TABLE LINK");
                this.add(objectArray, "SYSTEM TABLE");
                this.add(objectArray, "VIEW");
                break;
            }
            case 5: {
                this.add(objectArray, string);
                break;
            }
            case 6: {
                Object object2 = this.database.getAllSettings().iterator();
                while (object2.hasNext()) {
                    Setting object = object2.next();
                    String n = object.getStringValue();
                    if (n == null) {
                        n = "" + object.getIntValue();
                    }
                    this.add(objectArray, this.identifier(object.getName()), n);
                }
                this.add(objectArray, "info.BUILD_ID", "128");
                this.add(objectArray, "info.VERSION_MAJOR", "1");
                this.add(objectArray, "info.VERSION_MINOR", "2");
                this.add(objectArray, "info.VERSION", "" + Constants.getFullVersion());
                if (session.getUser().isAdmin()) {
                    object2 = new String[]{"java.runtime.version", "java.vm.name", "java.vendor", "os.name", "os.arch", "os.version", "sun.os.patch.level", "file.separator", "path.separator", "line.separator", "user.country", "user.language", "user.variant", "file.encoding"};
                    for (String indexColumnArray : object2) {
                        this.add(objectArray, "property." + indexColumnArray, SysProperties.getStringSetting(indexColumnArray, ""));
                    }
                }
                this.add(objectArray, "CLUSTER", this.database.getCluster());
                this.add(objectArray, "EXCLUSIVE", this.database.getExclusiveSession() == null ? "FALSE" : "TRUE");
                this.add(objectArray, "MODE", this.database.getMode().getName());
                this.add(objectArray, "MULTI_THREADED", this.database.isMultiThreaded() ? "1" : "0");
                this.add(objectArray, "MVCC", this.database.isMultiVersion() ? "TRUE" : "FALSE");
                this.add(objectArray, "QUERY_TIMEOUT", "" + session.getQueryTimeout());
                this.add(objectArray, "LOB_FILES_IN_DIRECTORIES", "" + this.database.getLobFilesInDirectories());
                this.add(objectArray, "h2.allowBigDecimalExtensions", "" + SysProperties.ALLOW_BIG_DECIMAL_EXTENSIONS);
                this.add(objectArray, "h2.baseDir", "" + SysProperties.getBaseDir());
                this.add(objectArray, "h2.check", "" + SysProperties.CHECK);
                this.add(objectArray, "h2.check2", "" + SysProperties.CHECK2);
                this.add(objectArray, "h2.clientTraceDirectory", SysProperties.CLIENT_TRACE_DIRECTORY);
                this.add(objectArray, "h2.collatorCacheSize", "" + SysProperties.getCollatorCacheSize());
                this.add(objectArray, "h2.defaultMaxMemoryUndo", "" + SysProperties.DEFAULT_MAX_MEMORY_UNDO);
                this.add(objectArray, "h2.lobFilesInDirectories", "" + SysProperties.LOB_FILES_IN_DIRECTORIES);
                this.add(objectArray, "h2.lobFilesPerDirectory", "" + SysProperties.LOB_FILES_PER_DIRECTORY);
                this.add(objectArray, "h2.logAllErrors", "" + SysProperties.LOG_ALL_ERRORS);
                this.add(objectArray, "h2.logAllErrorsFile", "" + SysProperties.LOG_ALL_ERRORS_FILE);
                this.add(objectArray, "h2.maxFileRetry", "" + SysProperties.MAX_FILE_RETRY);
                this.add(objectArray, "h2.maxQueryTimeout", "" + SysProperties.getMaxQueryTimeout());
                this.add(objectArray, "h2.lobCloseBetweenReads", "" + SysProperties.lobCloseBetweenReads);
                this.add(objectArray, "h2.objectCache", "" + SysProperties.OBJECT_CACHE);
                this.add(objectArray, "h2.objectCacheSize", "" + SysProperties.OBJECT_CACHE_SIZE);
                this.add(objectArray, "h2.objectCacheMaxPerElementSize", "" + SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE);
                this.add(objectArray, "h2.optimizeIn", "" + SysProperties.OPTIMIZE_IN);
                this.add(objectArray, "h2.optimizeInJoin", "" + SysProperties.optimizeInJoin);
                this.add(objectArray, "h2.optimizeInList", "" + SysProperties.OPTIMIZE_IN_LIST);
                this.add(objectArray, "h2.optimizeMinMax", "" + SysProperties.OPTIMIZE_MIN_MAX);
                this.add(objectArray, "h2.optimizeSubqueryCache", "" + SysProperties.OPTIMIZE_SUBQUERY_CACHE);
                this.add(objectArray, "h2.overflowExceptions", "" + SysProperties.OVERFLOW_EXCEPTIONS);
                this.add(objectArray, "h2.recompileAlways", "" + SysProperties.RECOMPILE_ALWAYS);
                this.add(objectArray, "h2.redoBufferSize", "" + SysProperties.REDO_BUFFER_SIZE);
                this.add(objectArray, "h2.runFinalize", "" + SysProperties.runFinalize);
                this.add(objectArray, "h2.scriptDirectory", SysProperties.getScriptDirectory());
                this.add(objectArray, "h2.serverCachedObjects", "" + SysProperties.SERVER_CACHED_OBJECTS);
                this.add(objectArray, "h2.serverResultSetFetchSize", "" + SysProperties.SERVER_RESULT_SET_FETCH_SIZE);
                this.add(objectArray, "h2.sortNullsHigh", "" + SysProperties.SORT_NULLS_HIGH);
                if (this.database.isPageStoreEnabled() && this.database.isPersistent()) {
                    object2 = this.database.getPageStore();
                    this.add(objectArray, "info.FILE_WRITE_TOTAL", "" + ((PageStore)object2).getWriteCountTotal());
                    this.add(objectArray, "info.FILE_WRITE", "" + ((PageStore)object2).getWriteCount());
                    this.add(objectArray, "info.FILE_READ", "" + ((PageStore)object2).getReadCount());
                    this.add(objectArray, "info.CACHE_MAX_SIZE", "" + ((PageStore)object2).getCache().getMaxSize());
                    this.add(objectArray, "info.CACHE_SIZE", "" + ((PageStore)object2).getCache().getSize());
                }
                if ((object2 = this.database.getDataFile()) == null) break;
                this.add(objectArray, "CACHE_TYPE", ((DiskFile)object2).getCache().getTypeName());
                if (!session.getUser().isAdmin()) break;
                DiskFile iOException = this.database.getIndexFile();
                this.add(objectArray, "info.FILE_DISK_WRITE", "" + ((DiskFile)object2).getWriteCount());
                this.add(objectArray, "info.FILE_DISK_READ", "" + ((DiskFile)object2).getReadCount());
                this.add(objectArray, "info.FILE_INDEX_WRITE", "" + this.database.getIndexFile().getWriteCount());
                this.add(objectArray, "info.FILE_INDEX_READ", "" + this.database.getIndexFile().getReadCount());
                this.add(objectArray, "info.CACHE_DATA_MAX_SIZE", "" + ((DiskFile)object2).getCache().getMaxSize());
                this.add(objectArray, "info.CACHE_DATA_SIZE", "" + ((DiskFile)object2).getCache().getSize());
                this.add(objectArray, "info.CACHE_INDEX_MAX_SIZE", "" + iOException.getCache().getMaxSize());
                this.add(objectArray, "info.CACHE_INDEX_SIZE", "" + iOException.getCache().getSize());
                break;
            }
            case 4: {
                for (DataType schemaObject : DataType.getTypes()) {
                    if (schemaObject.hidden || schemaObject.sqlType == 0) continue;
                    this.add(objectArray, schemaObject.name, String.valueOf(schemaObject.sqlType), String.valueOf(MathUtils.convertLongToInt(schemaObject.maxPrecision)), schemaObject.prefix, schemaObject.suffix, schemaObject.params, String.valueOf(schemaObject.autoIncrement), String.valueOf(schemaObject.minScale), String.valueOf(schemaObject.maxScale), schemaObject.decimal ? "10" : null, String.valueOf(schemaObject.sqlTypePos), String.valueOf(schemaObject.caseSensitive), "1", "3");
                }
                break;
            }
            case 7: {
                String string10 = "/org/h2/upgrade/v1_1/res/help.csv";
                try {
                    byte[] user = Resources.get(string10);
                    InputStreamReader schema = new InputStreamReader(new ByteArrayInputStream(user));
                    ResultSet locale = Csv.getInstance().read(schema, null);
                    int string21 = 0;
                    while (locale.next()) {
                        this.add(objectArray, String.valueOf(string21), locale.getString(1).trim(), locale.getString(2).trim(), locale.getString(3).trim(), locale.getString(4).trim());
                        ++string21;
                    }
                    break;
                }
                catch (IOException role) {
                    throw Message.convertIOException(role, string10);
                }
            }
            case 8: {
                for (SchemaObject right : this.database.getAllSchemaObjects(3)) {
                    Sequence table = (Sequence)right;
                    this.add(objectArray, string, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), String.valueOf(table.getCurrentValue()), String.valueOf(table.getIncrement()), table.getBelongsToTable() ? "TRUE" : "FALSE", this.replaceNullWithEmpty(table.getComment()), String.valueOf(table.getCacheSize()), "" + table.getId());
                }
                break;
            }
            case 9: {
                for (User dbObjectBase : this.database.getAllUsers()) {
                    this.add(objectArray, this.identifier(dbObjectBase.getName()), String.valueOf(dbObjectBase.isAdmin()), this.replaceNullWithEmpty(dbObjectBase.getComment()), "" + dbObjectBase.getId());
                }
                break;
            }
            case 10: {
                for (Role functionAlias : this.database.getAllRoles()) {
                    this.add(objectArray, this.identifier(functionAlias.getName()), this.replaceNullWithEmpty(functionAlias.getComment()), "" + functionAlias.getId());
                }
                break;
            }
            case 11: {
                for (Right right : this.database.getAllRights()) {
                    String session2;
                    Role table = right.getGrantedRole();
                    DbObject tableView = right.getGrantee();
                    String string6 = session2 = tableView.getType() == 2 ? "USER" : "ROLE";
                    if (table == null) {
                        Table command = right.getGrantedTable();
                        String string7 = this.identifier(command.getName());
                        if (!this.checkIndex(session, string7, value, value2)) continue;
                        this.add(objectArray, this.identifier(tableView.getName()), session2, "", right.getRights(), this.identifier(command.getSchema().getName()), this.identifier(command.getName()), "" + right.getId());
                        continue;
                    }
                    this.add(objectArray, this.identifier(tableView.getName()), session2, this.identifier(table.getName()), "", "", "", "" + right.getId());
                }
                break;
            }
            case 12: {
                for (FunctionAlias right : this.database.getAllFunctionAliases()) {
                    for (FunctionAlias.JavaMethod javaMethod : right.getJavaMethods()) {
                        int n = javaMethod.getDataType() == 0 ? 1 : 2;
                        this.add(objectArray, string, "PUBLIC", this.identifier(right.getName()), right.getJavaClassName(), right.getJavaMethodName(), "" + DataType.convertTypeToSQLType(javaMethod.getDataType()), "" + javaMethod.getColumnClasses().length, "" + n, this.replaceNullWithEmpty(right.getComment()), "" + right.getId(), right.getSource());
                    }
                }
                for (UserAggregate userAggregate : this.database.getAllAggregates()) {
                    int string17 = 2;
                    this.add(objectArray, string, "PUBLIC", this.identifier(userAggregate.getName()), userAggregate.getJavaClassName(), "", "" + DataType.convertTypeToSQLType(0), "1", "" + string17, this.replaceNullWithEmpty(userAggregate.getComment()), "" + userAggregate.getId());
                }
                break;
            }
            case 21: {
                for (FunctionAlias table : this.database.getAllFunctionAliases()) {
                    for (FunctionAlias.JavaMethod object : table.getJavaMethods()) {
                        Class<?>[] classArray = object.getColumnClasses();
                        for (int i = 0; i < classArray.length; ++i) {
                            Class<?> clazz = classArray[i];
                            int n = DataType.getTypeFromClass(clazz);
                            DataType dataType = DataType.getDataType(n);
                            int n2 = clazz.isPrimitive() ? 0 : 1;
                            this.add(objectArray, string, "PUBLIC", this.identifier(table.getName()), table.getJavaClassName(), table.getJavaMethodName(), "" + object.getParameterCount(), "" + i, "P" + (i + 1), "" + DataType.convertTypeToSQLType(dataType.type), dataType.name, "" + dataType.defaultPrecision, "" + dataType.defaultScale, "10", "" + n2, "1", "", null);
                        }
                    }
                }
                break;
            }
            case 13: {
                String string14 = this.database.getCompareMode().getName();
                for (Schema constraint : this.database.getAllSchemas()) {
                    this.add(objectArray, string, this.identifier(constraint.getName()), this.identifier(constraint.getOwner().getName()), "Unicode", string14, "PUBLIC".equals(constraint.getName()) ? "TRUE" : "FALSE", this.replaceNullWithEmpty(constraint.getComment()), "" + constraint.getId());
                }
                break;
            }
            case 14: {
                for (Right schemaObject : this.database.getAllRights()) {
                    String valueExpression;
                    Table constraint = schemaObject.getGrantedTable();
                    if (constraint == null || !this.checkIndex(session, valueExpression = this.identifier(constraint.getName()), value, value2)) continue;
                    this.addPrivileges(objectArray, schemaObject.getGrantee(), string, constraint, null, schemaObject.getRightMask());
                }
                break;
            }
            case 15: {
                for (Right schemaObject : this.database.getAllRights()) {
                    String table;
                    Table constant = schemaObject.getGrantedTable();
                    if (constant == null || !this.checkIndex(session, table = this.identifier(constant.getName()), value, value2)) continue;
                    DbObject dbObject = schemaObject.getGrantee();
                    int n = schemaObject.getRightMask();
                    for (Column column : constant.getColumns()) {
                        this.addPrivileges(objectArray, dbObject, string, constant, column.getName(), n);
                    }
                }
                break;
            }
            case 16: {
                for (Locale locale : Collator.getAvailableLocales()) {
                    this.add(objectArray, CompareMode.getName(locale), locale.toString());
                }
                break;
            }
            case 17: {
                for (Table userDataType : this.getAllTables(session)) {
                    String triggerObject;
                    if (!userDataType.getTableType().equals("VIEW") || !this.checkIndex(session, triggerObject = this.identifier(userDataType.getName()), value, value2)) continue;
                    TableView tableView = (TableView)userDataType;
                    this.add(objectArray, string, this.identifier(userDataType.getSchema().getName()), triggerObject, userDataType.getCreateSQL(), "NONE", "NO", tableView.isInvalid() ? "INVALID" : "VALID", this.replaceNullWithEmpty(tableView.getComment()), "" + tableView.getId());
                }
                break;
            }
            case 18: {
                void var9_58;
                ObjectArray<InDoubtTransaction> objectArray4 = this.database.getLog().getInDoubtTransactions();
                boolean schemaObject = false;
                while (objectArray4 != null && var9_58 < objectArray4.size()) {
                    InDoubtTransaction inDoubtTransaction = objectArray4.get((int)var9_58);
                    this.add(objectArray, inDoubtTransaction.getTransaction(), inDoubtTransaction.getState());
                    ++var9_58;
                }
                break;
            }
            case 19: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(5)) {
                    Constraint constraint = (Constraint)schemaObject;
                    if (!constraint.getConstraintType().equals("REFERENTIAL")) continue;
                    ConstraintReferential string25 = (ConstraintReferential)constraint;
                    IndexColumn[] indexColumnArray = string25.getColumns();
                    IndexColumn[] indexColumnArray3 = string25.getRefColumns();
                    Table table = string25.getTable();
                    Table table2 = string25.getRefTable();
                    String string8 = this.identifier(table2.getName());
                    if (!this.checkIndex(session, string8, value, value2)) continue;
                    int n = this.getRefAction(string25.getUpdateAction());
                    int n3 = this.getRefAction(string25.getDeleteAction());
                    for (int i = 0; i < indexColumnArray.length; ++i) {
                        this.add(objectArray, string, this.identifier(table2.getSchema().getName()), this.identifier(table2.getName()), this.identifier(indexColumnArray3[i].column.getName()), string, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), this.identifier(indexColumnArray[i].column.getName()), String.valueOf(i + 1), String.valueOf(n), String.valueOf(n3), this.identifier(string25.getName()), null, "7");
                    }
                }
                break;
            }
            case 20: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(5)) {
                    void var13_137;
                    String string9;
                    Constraint constraint = (Constraint)schemaObject;
                    String string10 = constraint.getConstraintType();
                    String string11 = null;
                    Object var13_138 = null;
                    Table table = constraint.getTable();
                    Index index = constraint.getUniqueIndex();
                    String string12 = null;
                    if (index != null) {
                        string12 = index.getName();
                    }
                    if (!this.checkIndex(session, string9 = this.identifier(table.getName()), value, value2)) continue;
                    if (string10.equals("CHECK")) {
                        string11 = ((ConstraintCheck)constraint).getExpression().getSQL();
                    } else if (string10.equals("UNIQUE") || string10.equals("PRIMARY KEY")) {
                        IndexColumn[] indexColumnArray = ((ConstraintUnique)constraint).getColumns();
                    } else if (string10.equals("REFERENTIAL")) {
                        IndexColumn[] indexColumnArray = ((ConstraintReferential)constraint).getColumns();
                    }
                    String string13 = null;
                    if (var13_137 != null) {
                        StatementBuilder statementBuilder = new StatementBuilder();
                        for (void var23_184 : var13_137) {
                            statementBuilder.appendExceptFirst(",");
                            statementBuilder.append(var23_184.column.getName());
                        }
                        string13 = statementBuilder.toString();
                    }
                    this.add(objectArray, string, this.identifier(constraint.getSchema().getName()), this.identifier(constraint.getName()), string10, string, this.identifier(table.getSchema().getName()), string9, string12, string11, string13, this.replaceNullWithEmpty(constraint.getComment()), constraint.getCreateSQL(), "" + constraint.getId());
                }
                break;
            }
            case 22: {
                for (SchemaObject table : this.database.getAllSchemaObjects(11)) {
                    Constant constant = (Constant)table;
                    ValueExpression valueExpression = constant.getValue();
                    this.add(objectArray, string, this.identifier(constant.getSchema().getName()), this.identifier(constant.getName()), "" + DataType.convertTypeToSQLType(valueExpression.getType()), this.replaceNullWithEmpty(constant.getComment()), valueExpression.getSQL(), "" + constant.getId());
                }
                break;
            }
            case 23: {
                for (UserDataType statementBuilder : this.database.getAllUserDataTypes()) {
                    Column column = statementBuilder.getColumn();
                    this.add(objectArray, string, "PUBLIC", this.identifier(statementBuilder.getName()), column.getDefaultSQL(), column.isNullable() ? "YES" : "NO", "" + column.getDataType().sqlType, "" + column.getPrecisionAsInt(), "" + column.getScale(), column.getDataType().name, "" + column.getSelectivity(), "" + column.getCheckConstraintSQL(session, "VALUE"), this.replaceNullWithEmpty(statementBuilder.getComment()), "" + statementBuilder.getCreateSQL(), "" + statementBuilder.getId());
                }
                break;
            }
            case 24: {
                for (SchemaObject string24 : this.database.getAllSchemaObjects(4)) {
                    TriggerObject triggerObject = (TriggerObject)string24;
                    Table table = triggerObject.getTable();
                    this.add(objectArray, string, this.identifier(triggerObject.getSchema().getName()), this.identifier(triggerObject.getName()), triggerObject.getTypeNameList(), string, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), "" + triggerObject.isBefore(), triggerObject.getTriggerClassName(), "" + triggerObject.getQueueSize(), "" + triggerObject.isNoWait(), this.replaceNullWithEmpty(triggerObject.getComment()), triggerObject.getCreateSQL(), "" + triggerObject.getId());
                }
                break;
            }
            case 25: {
                boolean bl = session.getUser().isAdmin();
                for (Session session2 : this.database.getSessions(false)) {
                    if (!bl && session2 != session) continue;
                    Command command = session2.getCurrentCommand();
                    this.add(objectArray, "" + session2.getId(), session2.getUser().getName(), new Timestamp(session2.getSessionStart()).toString(), command == null ? null : command.toString(), new Timestamp(session2.getCurrentCommandStart()).toString());
                }
                break;
            }
            case 26: {
                boolean bl = session.getUser().isAdmin();
                for (Session session3 : this.database.getSessions(false)) {
                    if (!bl && session3 != session) continue;
                    for (Table table : session3.getLocks()) {
                        this.add(objectArray, table.getSchema().getName(), table.getName(), "" + session3.getId(), table.isLockedExclusivelyBy(session3) ? "WRITE" : "READ");
                    }
                }
                break;
            }
            case 27: {
                String string14;
                for (String string15 : session.getVariableNames()) {
                    Value value3 = session.getVariable(string15);
                    this.add(objectArray, "@" + string15, "SET @" + string15 + " " + value3.getSQL());
                }
                for (Table table : session.getLocalTempTables()) {
                    this.add(objectArray, "TABLE " + table.getName(), table.getCreateSQL());
                }
                String[] stringArray = session.getSchemaSearchPath();
                if (stringArray != null && stringArray.length > 0) {
                    StatementBuilder statementBuilder = new StatementBuilder("SET SCHEMA_SEARCH_PATH ");
                    for (Object object : stringArray) {
                        statementBuilder.appendExceptFirst(", ");
                        statementBuilder.append(StringUtils.quoteIdentifier((String)object));
                    }
                    this.add(objectArray, "SCHEMA_SEARCH_PATH", statementBuilder.toString());
                }
                if ((string14 = session.getCurrentSchemaName()) == null) break;
                this.add(objectArray, "SCHEMA", "SET SCHEMA " + StringUtils.quoteIdentifier(string14));
                break;
            }
            default: {
                Message.throwInternalError("type=" + this.type);
            }
        }
        return objectArray;
    }

    private int getRefAction(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 0: {
                return 1;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 2;
            }
        }
        throw Message.throwInternalError("action=" + n);
    }

    @Override
    public void removeRow(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException("META");
    }

    @Override
    public void addRow(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException("META");
    }

    @Override
    public void removeChildrenAndResources(Session session) throws SQLException {
        throw Message.getUnsupportedException("META");
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session session) {
    }

    private void addPrivileges(ObjectArray<Row> objectArray, DbObject dbObject, String string, Table table, String string2, int n) throws SQLException {
        if ((n & 1) != 0) {
            this.addPrivilege(objectArray, dbObject, string, table, string2, "SELECT");
        }
        if ((n & 4) != 0) {
            this.addPrivilege(objectArray, dbObject, string, table, string2, "INSERT");
        }
        if ((n & 8) != 0) {
            this.addPrivilege(objectArray, dbObject, string, table, string2, "UPDATE");
        }
        if ((n & 2) != 0) {
            this.addPrivilege(objectArray, dbObject, string, table, string2, "DELETE");
        }
    }

    private void addPrivilege(ObjectArray<Row> objectArray, DbObject dbObject, String string, Table table, String string2, String string3) throws SQLException {
        User user;
        String string4 = "NO";
        if (dbObject.getType() == 2 && (user = (User)dbObject).isAdmin()) {
            string4 = "YES";
        }
        if (string2 == null) {
            this.add(objectArray, null, this.identifier(dbObject.getName()), string, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), string3, string4);
        } else {
            this.add(objectArray, null, this.identifier(dbObject.getName()), string, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), this.identifier(string2), string3, string4);
        }
    }

    private void add(ObjectArray<Row> objectArray, String ... stringArray) throws SQLException {
        Value[] valueArray = new Value[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Value value = string == null ? ValueNull.INSTANCE : ValueString.get(string);
            Column column = this.columns[i];
            value = column.convert(value);
            valueArray[i] = value;
        }
        Row row = new Row(valueArray, 0);
        row.setKey(objectArray.size());
        objectArray.add(row);
    }

    @Override
    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException("META");
    }

    @Override
    public void checkSupportAlter() throws SQLException {
        throw Message.getUnsupportedException("META");
    }

    @Override
    public void truncate(Session session) throws SQLException {
        throw Message.getUnsupportedException("META");
    }

    @Override
    public long getRowCount(Session session) {
        throw Message.throwInternalError();
    }

    @Override
    public boolean canGetRowCount() {
        return false;
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public String getTableType() {
        return "SYSTEM TABLE";
    }

    @Override
    public Index getScanIndex(Session session) {
        return new MetaIndex(this, IndexColumn.wrap(this.columns), true);
    }

    @Override
    public ObjectArray<Index> getIndexes() {
        if (this.metaIndex == null) {
            return null;
        }
        ObjectArray<Index> objectArray = ObjectArray.newInstance();
        objectArray.add(new MetaIndex(this, IndexColumn.wrap(this.columns), true));
        objectArray.add(this.metaIndex);
        return objectArray;
    }

    @Override
    public long getMaxDataModificationId() {
        return this.database.getModificationDataId();
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    public static int getMetaTableTypeCount() {
        return 28;
    }

    @Override
    public long getRowCountApproximation() {
        return 1000L;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }
}

