/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.h2.upgrade.v1_1.constant.SysProperties;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.tools.SimpleResultSet;
import org.h2.upgrade.v1_1.tools.SimpleRowSource;
import org.h2.upgrade.v1_1.util.FileUtils;
import org.h2.upgrade.v1_1.util.IOUtils;
import org.h2.upgrade.v1_1.util.JdbcUtils;
import org.h2.upgrade.v1_1.util.New;

public class Csv
implements SimpleRowSource {
    private String streamCharset = SysProperties.FILE_ENCODING;
    private String[] columnNames;
    private char fieldSeparatorRead = (char)44;
    private char commentLineStart = (char)35;
    private String fieldSeparatorWrite = ",";
    private String rowSeparatorWrite;
    private char fieldDelimiter = (char)34;
    private char escapeCharacter = (char)34;
    private String lineSeparator = SysProperties.LINE_SEPARATOR;
    private String nullString = "";
    private String fileName;
    private Reader input;
    private char[] inputBuffer;
    private int inputBufferPos;
    private int inputBufferStart = -1;
    private int inputBufferEnd;
    private Writer output;
    private boolean endOfLine;
    private boolean endOfFile;

    private Csv() {
    }

    public static Csv getInstance() {
        return new Csv();
    }

    private int writeResultSet(ResultSet resultSet) throws SQLException {
        try {
            int n;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = 0;
            int n3 = resultSetMetaData.getColumnCount();
            String[] stringArray = new String[n3];
            for (n = 0; n < n3; ++n) {
                stringArray[n] = resultSetMetaData.getColumnLabel(n + 1);
            }
            this.writeRow(stringArray);
            while (resultSet.next()) {
                for (n = 0; n < n3; ++n) {
                    stringArray[n] = resultSet.getString(n + 1);
                }
                this.writeRow(stringArray);
                ++n2;
            }
            this.output.close();
            n = n2;
            return n;
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
        finally {
            this.close();
            JdbcUtils.closeSilently(resultSet);
        }
    }

    public int write(Writer writer, ResultSet resultSet) throws SQLException {
        this.output = writer;
        return this.writeResultSet(resultSet);
    }

    public int write(String string, ResultSet resultSet, String string2) throws SQLException {
        this.init(string, string2);
        try {
            this.initWrite();
            return this.writeResultSet(resultSet);
        }
        catch (IOException iOException) {
            throw this.convertException("IOException writing " + string, iOException);
        }
    }

    public int write(Connection connection, String string, String string2, String string3) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        int n = this.write(string, resultSet, string3);
        statement.close();
        return n;
    }

    public ResultSet read(String string, String[] stringArray, String string2) throws SQLException {
        this.init(string, string2);
        try {
            return this.readResultSet(stringArray);
        }
        catch (IOException iOException) {
            throw this.convertException("IOException reading " + string, iOException);
        }
    }

    public ResultSet read(Reader reader, String[] stringArray) throws SQLException, IOException {
        this.init(null, null);
        this.input = reader;
        return this.readResultSet(stringArray);
    }

    private ResultSet readResultSet(String[] stringArray) throws SQLException, IOException {
        this.columnNames = stringArray;
        this.initRead();
        SimpleResultSet simpleResultSet = new SimpleResultSet(this);
        this.makeColumnNamesUnique();
        for (String string : this.columnNames) {
            simpleResultSet.addColumn(string, 12, Integer.MAX_VALUE, 0);
        }
        return simpleResultSet;
    }

    private void makeColumnNamesUnique() {
        for (int i = 0; i < this.columnNames.length; ++i) {
            String string = this.columnNames[i];
            if (string == null || string.length() == 0) {
                string = "C" + (i + 1);
            }
            for (int j = 0; j < i; ++j) {
                String string2 = this.columnNames[j];
                if (!string.equals(string2)) continue;
                string = string + "1";
                j = -1;
            }
            this.columnNames[i] = string;
        }
    }

    private void init(String string, String string2) {
        this.fileName = string;
        if (string2 != null) {
            this.streamCharset = string2;
        }
    }

    private void initWrite() throws IOException {
        if (this.output == null) {
            try {
                OutputStream outputStream = FileUtils.openFileOutputStream(this.fileName, false);
                outputStream = new BufferedOutputStream(outputStream, 4096);
                this.output = new BufferedWriter(new OutputStreamWriter(outputStream, this.streamCharset));
            }
            catch (SQLException sQLException) {
                this.close();
                throw Message.convertToIOException(sQLException);
            }
        }
    }

    private void writeRow(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (i > 0 && this.fieldSeparatorWrite != null) {
                this.output.write(this.fieldSeparatorWrite);
            }
            if ((string = stringArray[i]) != null) {
                if (this.escapeCharacter != '\u0000') {
                    if (this.fieldDelimiter != '\u0000') {
                        this.output.write(this.fieldDelimiter);
                    }
                    this.output.write(this.escape(string));
                    if (this.fieldDelimiter == '\u0000') continue;
                    this.output.write(this.fieldDelimiter);
                    continue;
                }
                this.output.write(string);
                continue;
            }
            if (this.nullString == null || this.nullString.length() <= 0) continue;
            this.output.write(this.nullString);
        }
        if (this.rowSeparatorWrite != null) {
            this.output.write(this.rowSeparatorWrite);
        }
        this.output.write(this.lineSeparator);
    }

    private String escape(String string) {
        if (string.indexOf(this.fieldDelimiter) < 0 && (this.escapeCharacter == this.fieldDelimiter || string.indexOf(this.escapeCharacter) < 0)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == this.fieldDelimiter || c == this.escapeCharacter) {
                stringBuilder.append(this.escapeCharacter);
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private void initRead() throws IOException {
        if (this.input == null) {
            try {
                InputStream inputStream = FileUtils.openFileInputStream(this.fileName);
                inputStream = new BufferedInputStream(inputStream, 4096);
                this.input = new InputStreamReader(inputStream, this.streamCharset);
            }
            catch (IOException iOException) {
                this.close();
                throw iOException;
            }
        }
        this.inputBuffer = new char[8192];
        if (this.columnNames == null) {
            this.readHeader();
        }
    }

    private void readHeader() throws IOException {
        ArrayList<String> arrayList = New.arrayList();
        while (true) {
            String string;
            if ((string = this.readValue()) == null) {
                if (this.endOfLine) {
                    if (!this.endOfFile && arrayList.size() <= 0) continue;
                    break;
                }
                string = "COLUMN" + arrayList.size();
                arrayList.add(string);
                continue;
            }
            if (string.length() == 0) {
                string = "COLUMN" + arrayList.size();
            } else if (this.isSimpleColumnName(string)) {
                string = string.toUpperCase();
            }
            arrayList.add(string);
            if (this.endOfLine) break;
        }
        this.columnNames = new String[arrayList.size()];
        arrayList.toArray(this.columnNames);
    }

    private boolean isSimpleColumnName(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!(i == 0 ? c != '_' && !Character.isLetter(c) : c != '_' && !Character.isLetterOrDigit(c))) continue;
            return false;
        }
        return string.length() != 0;
    }

    private void pushBack() {
        --this.inputBufferPos;
    }

    private int readChar() throws IOException {
        if (this.inputBufferPos >= this.inputBufferEnd) {
            return this.readBuffer();
        }
        return this.inputBuffer[this.inputBufferPos++];
    }

    private int readBuffer() throws IOException {
        int n;
        if (this.endOfFile) {
            return -1;
        }
        if (this.inputBufferStart >= 0) {
            n = this.inputBufferPos - this.inputBufferStart;
            if (n > 0) {
                char[] cArray = this.inputBuffer;
                if (n + 4096 > cArray.length) {
                    this.inputBuffer = new char[cArray.length * 2];
                }
                System.arraycopy(cArray, this.inputBufferStart, this.inputBuffer, 0, n);
            }
            this.inputBufferStart = 0;
        } else {
            n = 0;
        }
        this.inputBufferPos = n;
        int n2 = this.input.read(this.inputBuffer, n, 4096);
        if (n2 == -1) {
            this.inputBufferEnd = -1024;
            this.endOfFile = true;
            ++this.inputBufferPos;
            return -1;
        }
        this.inputBufferEnd = n + n2;
        return this.inputBuffer[this.inputBufferPos++];
    }

    private String readValue() throws IOException {
        int n;
        this.endOfLine = false;
        this.inputBufferStart = this.inputBufferPos;
        do {
            if ((n = this.readChar()) == this.fieldDelimiter) {
                int n2;
                boolean bl;
                block15: {
                    bl = false;
                    this.inputBufferStart = this.inputBufferPos;
                    while (true) {
                        if ((n = this.readChar()) == this.fieldDelimiter) {
                            n = this.readChar();
                            if (n != this.fieldDelimiter) {
                                n2 = 2;
                                break block15;
                            }
                            bl = true;
                            continue;
                        }
                        if (n == this.escapeCharacter) {
                            n = this.readChar();
                            if (n < 0) {
                                n2 = 1;
                                break block15;
                            }
                            bl = true;
                            continue;
                        }
                        if (n < 0) break;
                    }
                    n2 = 1;
                }
                String string = new String(this.inputBuffer, this.inputBufferStart, this.inputBufferPos - this.inputBufferStart - n2);
                if (bl) {
                    string = this.unEscape(string);
                }
                this.inputBufferStart = -1;
                while (n != this.fieldSeparatorRead) {
                    if (n == 10 || n < 0 || n == 13) {
                        this.endOfLine = true;
                        break;
                    }
                    if (n != 32 && n != 9) {
                        this.pushBack();
                        break;
                    }
                    n = this.readChar();
                }
                return string;
            }
            if (n == 10 || n < 0 || n == 13) {
                this.endOfLine = true;
                return null;
            }
            if (n != this.fieldSeparatorRead) continue;
            return null;
        } while (n <= 32);
        if (n == this.commentLineStart) {
            this.inputBufferStart = -1;
            while ((n = this.readChar()) != 10 && n >= 0 && n != 13) {
            }
            this.endOfLine = true;
            return null;
        }
        while ((n = this.readChar()) != this.fieldSeparatorRead) {
            if (n != 10 && n >= 0 && n != 13) continue;
            this.endOfLine = true;
            break;
        }
        String string = new String(this.inputBuffer, this.inputBufferStart, this.inputBufferPos - this.inputBufferStart - 1);
        this.inputBufferStart = -1;
        return this.readNull(string.trim());
    }

    private String readNull(String string) {
        return string.equals(this.nullString) ? null : string;
    }

    private String unEscape(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = 0;
        char[] cArray = null;
        while ((n = string.indexOf(this.escapeCharacter, n2)) >= 0 || (n = string.indexOf(this.fieldDelimiter, n2)) >= 0) {
            if (cArray == null) {
                cArray = string.toCharArray();
            }
            stringBuilder.append(cArray, n2, n - n2);
            if (n == string.length() - 1) {
                n2 = string.length();
                break;
            }
            stringBuilder.append(cArray[n + 1]);
            n2 = n + 2;
        }
        stringBuilder.append(string.substring(n2));
        return stringBuilder.toString();
    }

    public Object[] readRow() throws SQLException {
        if (this.input == null) {
            return null;
        }
        Object[] objectArray = new String[this.columnNames.length];
        try {
            int n = 0;
            while (true) {
                String string;
                if ((string = this.readValue()) == null && this.endOfLine) {
                    if (n == 0) {
                        if (!this.endOfFile) continue;
                        return null;
                    }
                    break;
                }
                if (n < objectArray.length) {
                    objectArray[n++] = string;
                }
                if (this.endOfLine) break;
            }
        }
        catch (IOException iOException) {
            throw this.convertException("IOException reading from " + this.fileName, iOException);
        }
        return objectArray;
    }

    private SQLException convertException(String string, Exception exception) {
        SQLException sQLException = new SQLException(string, "CSV");
        sQLException.initCause(exception);
        return sQLException;
    }

    public void close() {
        IOUtils.closeSilently(this.input);
        this.input = null;
        IOUtils.closeSilently(this.output);
        this.output = null;
    }

    public void reset() throws SQLException {
        throw new SQLException("Method is not supported", "CSV");
    }

    public void setFieldSeparatorWrite(String string) {
        this.fieldSeparatorWrite = string;
    }

    public String getFieldSeparatorWrite() {
        return this.fieldSeparatorWrite;
    }

    public void setFieldSeparatorRead(char c) {
        this.fieldSeparatorRead = c;
    }

    public char getFieldSeparatorRead() {
        return this.fieldSeparatorRead;
    }

    public String getRowSeparatorWrite() {
        return this.rowSeparatorWrite;
    }

    public void setRowSeparatorWrite(String string) {
        this.rowSeparatorWrite = string;
    }

    public void setFieldDelimiter(char c) {
        this.fieldDelimiter = c;
    }

    public char getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setEscapeCharacter(char c) {
        this.escapeCharacter = c;
    }

    public char getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public void setLineSeparator(String string) {
        this.lineSeparator = string;
    }

    public void setNullString(String string) {
        this.nullString = string;
    }
}

