/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.util;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.h2.upgrade.v1_1.message.InternalException;
import org.h2.upgrade.v1_1.util.FileUtils;
import org.h2.upgrade.v1_1.util.New;
import org.h2.upgrade.v1_1.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceCompiler {
    private static final Class<?> JAVAC_SUN;
    HashMap<String, String> sources = New.hashMap();
    HashMap<String, Class<?>> compiled = New.hashMap();
    private String compileDir = System.getProperty("java.io.tmpdir");

    public void setSource(String string, String string2) {
        this.sources.put(string, string2);
        this.compiled.clear();
    }

    private Class<?> getClass(String string) throws ClassNotFoundException {
        Class<?> clazz = this.compiled.get(string);
        if (clazz != null) {
            return clazz;
        }
        ClassLoader classLoader = new ClassLoader(this.getClass().getClassLoader()){

            @Override
            public Class<?> findClass(String string) throws ClassNotFoundException {
                Class<?> clazz = SourceCompiler.this.compiled.get(string);
                if (clazz == null) {
                    String string2;
                    String string3 = SourceCompiler.this.sources.get(string);
                    String string4 = null;
                    int n = string.lastIndexOf(46);
                    if (n >= 0) {
                        string4 = string.substring(0, n);
                        string2 = string.substring(n + 1);
                    } else {
                        string2 = string;
                    }
                    byte[] byArray = SourceCompiler.this.javacCompile(string4, string2, string3);
                    if (byArray == null) {
                        clazz = this.findSystemClass(string);
                    } else {
                        clazz = this.defineClass(string, byArray, 0, byArray.length);
                        SourceCompiler.this.compiled.put(string, clazz);
                    }
                }
                return clazz;
            }
        };
        return classLoader.loadClass(string);
    }

    public Method getMethod(String string) throws ClassNotFoundException {
        Method[] methodArray;
        Class<?> clazz = this.getClass(string);
        for (Method method : methodArray = clazz.getDeclaredMethods()) {
            int n = method.getModifiers();
            if (!Modifier.isPublic(n) || !Modifier.isStatic(n)) continue;
            return method;
        }
        return null;
    }

    byte[] javacCompile(String string, String string2, String string3) {
        File file = new File(this.compileDir);
        if (string != null) {
            file = new File(file, string.replace('.', '/'));
            try {
                FileUtils.mkdirs(file);
            }
            catch (IOException iOException) {
                throw new InternalException(iOException);
            }
        }
        File file2 = new File(file, string2 + ".java");
        File file3 = new File(file, string2 + ".class");
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
            file3.delete();
            int n = string3.indexOf("@CODE");
            String string4 = "import java.util.*;\nimport java.math.*;\nimport java.sql.*;\n";
            if (n >= 0) {
                string4 = string3.substring(0, n);
                string3 = string3.substring("@CODE".length() + n);
            }
            if (string != null) {
                printWriter.println("package " + string + ";");
            }
            printWriter.println(string4);
            printWriter.println("public class " + string2 + " {\n" + "    public static " + string3 + "\n" + "}\n");
            printWriter.close();
            if (JAVAC_SUN != null) {
                this.javacSun(file2);
            } else {
                this.javacProcess(file2);
            }
            byte[] byArray = new byte[(int)file3.length()];
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file3));
            dataInputStream.readFully(byArray);
            dataInputStream.close();
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            file2.delete();
            file3.delete();
        }
    }

    private void javacProcess(File file) {
        this.exec("javac", "-sourcepath", this.compileDir, "-d", this.compileDir, file.getAbsolutePath());
    }

    private int exec(String ... stringArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            this.copyInThread(process.getInputStream(), byteArrayOutputStream);
            this.copyInThread(process.getErrorStream(), byteArrayOutputStream);
            process.waitFor();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (byArray.length != 0) {
                throw new RuntimeException("Compile error: " + StringUtils.utf8Decode(byArray));
            }
            return process.exitValue();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void copyInThread(final InputStream inputStream, final OutputStream outputStream) {
        new Thread(){

            public void run() {
                try {
                    while (true) {
                        int n;
                        if ((n = inputStream.read()) < 0) {
                            return;
                        }
                        if (outputStream == null) continue;
                        outputStream.write(n);
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }.start();
    }

    private void javacSun(File file) {
        PrintStream printStream = System.err;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream2 = new PrintStream(byteArrayOutputStream);
        try {
            System.setErr(printStream2);
            Method method = JAVAC_SUN.getMethod("compile", String[].class);
            Object obj = JAVAC_SUN.newInstance();
            method.invoke(obj, new Object[]{new String[]{"-sourcepath", this.compileDir, "-d", this.compileDir, file.getAbsolutePath()}});
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (byArray.length != 0) {
                throw new RuntimeException("Compile error: " + StringUtils.utf8Decode(byArray));
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            System.setErr(printStream);
        }
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.sun.tools.javac.Main");
        }
        catch (Exception exception) {
            clazz = null;
        }
        JAVAC_SUN = clazz;
    }
}

