/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.upgrade.v1_1.util.ByteUtils;
import org.h2.upgrade.v1_1.util.MathUtils;
import org.h2.upgrade.v1_1.value.CompareMode;
import org.h2.upgrade.v1_1.value.Value;

abstract class ValueBytesBase
extends Value {
    private final byte[] value;
    private int hash;

    protected ValueBytesBase(byte[] byArray) {
        this.value = byArray;
    }

    public String getSQL() {
        return "X'" + this.getString() + "'";
    }

    public byte[] getBytesNoCopy() {
        return this.value;
    }

    public byte[] getBytes() {
        return ByteUtils.cloneByteArray(this.value);
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        byte[] byArray = ((ValueBytesBase)value).value;
        return ByteUtils.compareNotNull(this.value, byArray);
    }

    public String getString() {
        return ByteUtils.convertBytesToString(this.value);
    }

    public long getPrecision() {
        return this.value.length;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = ByteUtils.getByteArrayHash(this.value);
        }
        return this.hash;
    }

    public Object getObject() {
        return this.getBytes();
    }

    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setBytes(n, this.value);
    }

    public int getDisplaySize() {
        return MathUtils.convertLongToInt((long)this.value.length * 2L);
    }

    public int getMemory() {
        return this.value.length + 4;
    }

    public boolean equals(Object object) {
        return object instanceof ValueBytesBase && ByteUtils.compareNotNull(this.value, ((ValueBytesBase)object).value) == 0;
    }
}

