/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.value;

import org.h2.upgrade.v1_1.constant.SysProperties;
import org.h2.upgrade.v1_1.util.MathUtils;
import org.h2.upgrade.v1_1.util.StringCache;
import org.h2.upgrade.v1_1.value.CompareMode;
import org.h2.upgrade.v1_1.value.Value;
import org.h2.upgrade.v1_1.value.ValueStringBase;

public class ValueString
extends ValueStringBase {
    private static final ValueString EMPTY = new ValueString("");

    protected ValueString(String string) {
        super(string);
    }

    public int getType() {
        return 13;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueStringBase valueStringBase = (ValueStringBase)value;
        return compareMode.compareString(this.value, valueStringBase.value, false);
    }

    public boolean equals(Object object) {
        return object instanceof ValueStringBase && this.value.equals(((ValueStringBase)object).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public Value convertPrecision(long l) {
        if (l == 0L || (long)this.value.length() <= l) {
            return this;
        }
        int n = MathUtils.convertLongToInt(l);
        return ValueString.get(this.value.substring(0, n));
    }

    public static ValueString get(String string) {
        if (string.length() == 0) {
            return EMPTY;
        }
        ValueString valueString = new ValueString(StringCache.get(string));
        if (string.length() > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return valueString;
        }
        return (ValueString)Value.cache(valueString);
    }
}

