/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit;

import junit.framework.TestCase;
import org.dbunit.DefaultDatabaseTester;
import org.dbunit.IDatabaseTester;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.operation.DatabaseOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatabaseTestCase
extends TestCase {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$DatabaseTestCase == null ? (class$org$dbunit$DatabaseTestCase = DatabaseTestCase.class$("org.dbunit.DatabaseTestCase")) : class$org$dbunit$DatabaseTestCase));
    private IDatabaseTester tester;
    static /* synthetic */ Class class$org$dbunit$DatabaseTestCase;

    public DatabaseTestCase() {
    }

    public DatabaseTestCase(String name) {
        super(name);
    }

    protected abstract IDatabaseConnection getConnection() throws Exception;

    protected abstract IDataSet getDataSet() throws Exception;

    protected IDatabaseTester newDatabaseTester() throws Exception {
        logger.debug("newDatabaseTester() - start");
        IDatabaseConnection connection = this.getConnection();
        DefaultDatabaseTester tester = new DefaultDatabaseTester(connection);
        return tester;
    }

    protected IDatabaseTester getDatabaseTester() throws Exception {
        logger.debug("getDatabaseTester() - start");
        if (this.tester == null) {
            this.tester = this.newDatabaseTester();
        }
        return this.tester;
    }

    protected void closeConnection(IDatabaseConnection connection) throws Exception {
        logger.debug("closeConnection(connection=" + connection + ") - start");
        DatabaseTestCase.assertNotNull((String)"DatabaseTester is not set", (Object)this.getDatabaseTester());
        this.getDatabaseTester().closeConnection(connection);
    }

    protected DatabaseOperation getSetUpOperation() throws Exception {
        logger.debug("getSetUpOperation() - start");
        return DatabaseOperation.CLEAN_INSERT;
    }

    protected DatabaseOperation getTearDownOperation() throws Exception {
        logger.debug("getTearDownOperation() - start");
        return DatabaseOperation.NONE;
    }

    protected void setUp() throws Exception {
        logger.debug("setUp() - start");
        super.setUp();
        IDatabaseTester databaseTester = this.getDatabaseTester();
        DatabaseTestCase.assertNotNull((String)"DatabaseTester is not set", (Object)databaseTester);
        databaseTester.setSetUpOperation(this.getSetUpOperation());
        databaseTester.setDataSet(this.getDataSet());
        databaseTester.onSetup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        logger.debug("tearDown() - start");
        try {
            IDatabaseTester databaseTester = this.getDatabaseTester();
            DatabaseTestCase.assertNotNull((String)"DatabaseTester is not set", (Object)databaseTester);
            databaseTester.setTearDownOperation(this.getTearDownOperation());
            databaseTester.setDataSet(this.getDataSet());
            databaseTester.onTearDown();
            this.tester = null;
        }
        finally {
            super.tearDown();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

