/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.dbunit.AbstractDatabaseTester;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiDatabaseTester
extends AbstractDatabaseTester {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$JndiDatabaseTester == null ? (class$org$dbunit$JndiDatabaseTester = JndiDatabaseTester.class$("org.dbunit.JndiDatabaseTester")) : class$org$dbunit$JndiDatabaseTester));
    private DataSource dataSource;
    private Properties environment;
    private boolean initialized = false;
    private String lookupName;
    static /* synthetic */ Class class$org$dbunit$JndiDatabaseTester;
    static /* synthetic */ Class class$javax$sql$DataSource;

    public JndiDatabaseTester(Properties environment, String lookupName) {
        this.environment = environment;
        this.lookupName = lookupName;
    }

    public JndiDatabaseTester(String lookupName) {
        this(null, lookupName);
    }

    public IDatabaseConnection getConnection() throws Exception {
        logger.debug("getConnection() - start");
        if (!this.initialized) {
            this.initialize();
        }
        if (this.getSchema() != null) {
            return new DatabaseConnection(this.dataSource.getConnection(), this.getSchema());
        }
        return new DatabaseConnection(this.dataSource.getConnection());
    }

    private void initialize() throws NamingException {
        logger.debug("initialize() - start");
        InitialContext context = new InitialContext(this.environment);
        this.assertNotNullNorEmpty("lookupName", this.lookupName);
        Object obj = context.lookup(this.lookupName);
        this.assertTrue("JNDI object with [" + this.lookupName + "] not found", obj != null);
        this.assertTrue("Object [" + obj + "] at JNDI location [" + this.lookupName + "] is not of type [" + (class$javax$sql$DataSource == null ? (class$javax$sql$DataSource = JndiDatabaseTester.class$("javax.sql.DataSource")) : class$javax$sql$DataSource).getName() + "]", obj instanceof DataSource);
        this.dataSource = (DataSource)obj;
        this.assertTrue("DataSource is not set", this.dataSource != null);
        this.initialized = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

