/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.dbunit.database.CachedResultSetTable;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseDataSet;
import org.dbunit.database.DatabaseTableMetaData;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.statement.IStatementFactory;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabaseConnection
implements IDatabaseConnection {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$database$AbstractDatabaseConnection == null ? (class$org$dbunit$database$AbstractDatabaseConnection = AbstractDatabaseConnection.class$("org.dbunit.database.AbstractDatabaseConnection")) : class$org$dbunit$database$AbstractDatabaseConnection));
    private IDataSet _dataSet = null;
    private DatabaseConfig _databaseConfig = new DatabaseConfig();
    static /* synthetic */ Class class$org$dbunit$database$AbstractDatabaseConnection;

    public IDataSet createDataSet() throws SQLException {
        logger.debug("createDataSet() - start");
        if (this._dataSet == null) {
            this._dataSet = new DatabaseDataSet(this);
        }
        return this._dataSet;
    }

    public IDataSet createDataSet(String[] tableNames) throws SQLException {
        logger.debug("createDataSet(tableNames=" + tableNames + ") - start");
        return new FilteredDataSet(tableNames, this.createDataSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITable createQueryTable(String resultName, String sql) throws DataSetException, SQLException {
        logger.debug("createQueryTable(resultName=" + resultName + ", sql=" + sql + ") - start");
        Statement statement = this.getConnection().createStatement();
        try {
            CachedResultSetTable cachedResultSetTable;
            ResultSet resultSet = statement.executeQuery(sql);
            try {
                IDataTypeFactory typeFactory = (IDataTypeFactory)this._databaseConfig.getProperty("http://www.dbunit.org/properties/datatypeFactory");
                ITableMetaData metaData = DatabaseTableMetaData.createMetaData(resultName, resultSet, typeFactory);
                cachedResultSetTable = new CachedResultSetTable(metaData, resultSet);
            }
            catch (Throwable throwable) {
                resultSet.close();
                throw throwable;
            }
            resultSet.close();
            return cachedResultSetTable;
        }
        finally {
            statement.close();
        }
    }

    public int getRowCount(String tableName) throws SQLException {
        logger.debug("getRowCount(tableName=" + tableName + ") - start");
        return this.getRowCount(tableName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount(String tableName, String whereClause) throws SQLException {
        logger.debug("getRowCount(tableName=" + tableName + ", whereClause=" + whereClause + ") - start");
        StringBuffer sqlBuffer = new StringBuffer(128);
        sqlBuffer.append("select count(*) from ");
        sqlBuffer.append(tableName);
        if (whereClause != null) {
            sqlBuffer.append(" ");
            sqlBuffer.append(whereClause);
        }
        Statement statement = this.getConnection().createStatement();
        try {
            int n;
            ResultSet resultSet = statement.executeQuery(sqlBuffer.toString());
            try {
                resultSet.next();
                n = resultSet.getInt(1);
            }
            catch (Throwable throwable) {
                resultSet.close();
                throw throwable;
            }
            resultSet.close();
            return n;
        }
        finally {
            statement.close();
        }
    }

    public DatabaseConfig getConfig() {
        logger.debug("getConfig() - start");
        return this._databaseConfig;
    }

    public IStatementFactory getStatementFactory() {
        logger.debug("getStatementFactory() - start");
        return (IStatementFactory)this._databaseConfig.getProperty("http://www.dbunit.org/properties/statementFactory");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

