/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.SQLException;
import java.util.List;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.IResultSetTable;
import org.dbunit.database.IResultSetTableFactory;
import org.dbunit.database.QueryDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryTableIterator
implements ITableIterator {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$database$QueryTableIterator == null ? (class$org$dbunit$database$QueryTableIterator = QueryTableIterator.class$("org.dbunit.database.QueryTableIterator")) : class$org$dbunit$database$QueryTableIterator));
    private final List _tableEntries;
    private final IDatabaseConnection _connection;
    private IResultSetTable _currentTable;
    private int _index = -1;
    static /* synthetic */ Class class$org$dbunit$database$QueryTableIterator;

    public QueryTableIterator(List tableEntries, IDatabaseConnection connection) {
        this._tableEntries = tableEntries;
        this._connection = connection;
        this._currentTable = null;
    }

    public boolean next() throws DataSetException {
        logger.debug("next() - start");
        ++this._index;
        if (this._currentTable != null) {
            this._currentTable.close();
            this._currentTable = null;
        }
        return this._index < this._tableEntries.size();
    }

    public ITableMetaData getTableMetaData() throws DataSetException {
        logger.debug("getTableMetaData() - start");
        QueryDataSet.TableEntry entry = (QueryDataSet.TableEntry)this._tableEntries.get(this._index);
        if (entry.getQuery() == null) {
            try {
                IDataSet dataSet = this._connection.createDataSet();
                return dataSet.getTableMetaData(entry.getTableName());
            }
            catch (SQLException e) {
                throw new DataSetException(e);
            }
        }
        return this.getTable().getTableMetaData();
    }

    public ITable getTable() throws DataSetException {
        logger.debug("getTable() - start");
        if (this._currentTable == null) {
            try {
                QueryDataSet.TableEntry entry = (QueryDataSet.TableEntry)this._tableEntries.get(this._index);
                if (entry.getQuery() == null) {
                    IDataSet dataSet = this._connection.createDataSet();
                    this._currentTable = (IResultSetTable)dataSet.getTable(entry.getTableName());
                } else {
                    DatabaseConfig config = this._connection.getConfig();
                    IResultSetTableFactory factory = (IResultSetTableFactory)config.getProperty("http://www.dbunit.org/properties/resultSetTableFactory");
                    this._currentTable = factory.createTable(entry.getTableName(), entry.getQuery(), this._connection);
                }
            }
            catch (SQLException e) {
                throw new DataSetException(e);
            }
        }
        return this._currentTable;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

