/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampDataType
extends AbstractDataType {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$datatype$TimestampDataType == null ? (class$org$dbunit$dataset$datatype$TimestampDataType = TimestampDataType.class$("org.dbunit.dataset.datatype.TimestampDataType")) : class$org$dbunit$dataset$datatype$TimestampDataType));
    static /* synthetic */ Class class$org$dbunit$dataset$datatype$TimestampDataType;
    static /* synthetic */ Class class$java$sql$Timestamp;

    TimestampDataType() {
        super("TIMESTAMP", 93, class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = TimestampDataType.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, false);
    }

    public Object typeCast(Object value) throws TypeCastException {
        logger.debug("typeCast(value=" + value + ") - start");
        if (value == null || value == ITable.NO_VALUE) {
            return null;
        }
        if (value instanceof Timestamp) {
            return value;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return new Timestamp(date.getTime());
        }
        if (value instanceof Long) {
            Long date = (Long)value;
            return new Timestamp(date);
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue.length() == 10) {
                try {
                    long time = java.sql.Date.valueOf(stringValue).getTime();
                    return new Timestamp(time);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            try {
                return Timestamp.valueOf(stringValue);
            }
            catch (IllegalArgumentException e) {
                throw new TypeCastException(value, this, e);
            }
        }
        throw new TypeCastException(value, this);
    }

    public boolean isDateTime() {
        logger.debug("isDateTime() - start");
        return true;
    }

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        logger.debug("getSqlValue(column=" + column + ", resultSet=" + resultSet + ") - start");
        Timestamp value = resultSet.getTimestamp(column);
        if (value == null || resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        logger.debug("setSqlValue(value=" + value + ", column=" + column + ", statement=" + statement + ") - start");
        statement.setTimestamp(column, (Timestamp)this.typeCast(value));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

