/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.mssql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.filter.IColumnFilter;
import org.dbunit.operation.AbstractOperation;
import org.dbunit.operation.CompositeOperation;
import org.dbunit.operation.DatabaseOperation;
import org.dbunit.operation.ExclusiveTransactionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertIdentityOperation
extends AbstractOperation {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$ext$mssql$InsertIdentityOperation == null ? (class$org$dbunit$ext$mssql$InsertIdentityOperation = InsertIdentityOperation.class$("org.dbunit.ext.mssql.InsertIdentityOperation")) : class$org$dbunit$ext$mssql$InsertIdentityOperation));
    public static final String PROPERTY_IDENTITY_COLUMN_FILTER = "http://www.dbunit.org/properties/mssql/identityColumnFilter";
    public static final DatabaseOperation INSERT = new InsertIdentityOperation(DatabaseOperation.INSERT);
    public static final DatabaseOperation CLEAN_INSERT = new CompositeOperation(DatabaseOperation.DELETE_ALL, new InsertIdentityOperation(DatabaseOperation.INSERT));
    public static final DatabaseOperation REFRESH = new InsertIdentityOperation(DatabaseOperation.REFRESH);
    private static final IColumnFilter DEFAULT_IDENTITY_FILTER = new IColumnFilter(){

        public boolean accept(String tableName, Column column) {
            logger.debug("accept(tableName=" + tableName + ", column=" + column + ") - start");
            return column.getSqlTypeName().endsWith("identity");
        }
    };
    private final DatabaseOperation _operation;
    static /* synthetic */ Class class$org$dbunit$ext$mssql$InsertIdentityOperation;

    public InsertIdentityOperation(DatabaseOperation operation) {
        this._operation = operation;
    }

    private boolean hasIdentityColumn(ITableMetaData metaData, IDatabaseConnection connection) throws DataSetException {
        logger.debug("hasIdentityColumn(metaData=" + metaData + ", connection=" + connection + ") - start");
        DatabaseConfig config = connection.getConfig();
        IColumnFilter identityFilter = (IColumnFilter)config.getProperty(PROPERTY_IDENTITY_COLUMN_FILTER);
        if (identityFilter == null) {
            identityFilter = DEFAULT_IDENTITY_FILTER;
        }
        Column[] columns = metaData.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (!identityFilter.accept(metaData.getTableName(), columns[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IDatabaseConnection connection, IDataSet dataSet) throws DatabaseUnitException, SQLException {
        logger.debug("execute(connection=" + connection + ", dataSet) - start");
        Connection jdbcConnection = connection.getConnection();
        Statement statement = jdbcConnection.createStatement();
        try {
            IDataSet databaseDataSet = connection.createDataSet();
            if (!jdbcConnection.getAutoCommit()) {
                throw new ExclusiveTransactionException();
            }
            jdbcConnection.setAutoCommit(false);
            ITableIterator iterator = dataSet.iterator();
            while (iterator.next()) {
                StringBuffer sqlBuffer;
                ITable table = iterator.getTable();
                String tableName = table.getTableMetaData().getTableName();
                ITableMetaData metaData = databaseDataSet.getTableMetaData(tableName);
                boolean hasIdentityColumn = this.hasIdentityColumn(metaData, connection);
                if (hasIdentityColumn) {
                    sqlBuffer = new StringBuffer(128);
                    sqlBuffer.append("SET IDENTITY_INSERT ");
                    sqlBuffer.append(this.getQualifiedName(connection.getSchema(), metaData.getTableName(), connection));
                    sqlBuffer.append(" ON");
                    statement.execute(sqlBuffer.toString());
                }
                try {
                    this._operation.execute(connection, new DefaultDataSet(table));
                }
                finally {
                    if (hasIdentityColumn) {
                        sqlBuffer = new StringBuffer(128);
                        sqlBuffer.append("SET IDENTITY_INSERT ");
                        sqlBuffer.append(this.getQualifiedName(connection.getSchema(), metaData.getTableName(), connection));
                        sqlBuffer.append(" OFF");
                        statement.execute(sqlBuffer.toString());
                    }
                    jdbcConnection.commit();
                }
            }
        }
        finally {
            jdbcConnection.setAutoCommit(true);
            statement.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

