/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.oracle;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.datatype.ClobDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleClobDataType
extends ClobDataType {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$ext$oracle$OracleClobDataType == null ? (class$org$dbunit$ext$oracle$OracleClobDataType = OracleClobDataType.class$("org.dbunit.ext.oracle.OracleClobDataType")) : class$org$dbunit$ext$oracle$OracleClobDataType));
    private static final Integer DURATION_SESSION = new Integer(1);
    private static final Integer MODE_READWRITE = new Integer(1);
    static /* synthetic */ Class class$org$dbunit$ext$oracle$OracleClobDataType;
    static /* synthetic */ Class class$java$sql$Connection;

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        logger.debug("getSqlValue(column=" + column + ", resultSet=" + resultSet + ") - start");
        return this.typeCast(resultSet.getClob(column));
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        logger.debug("setSqlValue(value=" + value + ", column=" + column + ", statement=" + statement + ") - start");
        statement.setObject(column, this.getClob(value, statement.getConnection()));
    }

    protected Object getClob(Object value, Connection connection) throws TypeCastException {
        logger.debug("getClob(value=" + value + ", connection=" + connection + ") - start");
        Object tempClob = null;
        try {
            Class<?> aClobClass = Class.forName("oracle.sql.CLOB");
            Method createTemporaryMethod = aClobClass.getMethod("createTemporary", class$java$sql$Connection == null ? (class$java$sql$Connection = OracleClobDataType.class$("java.sql.Connection")) : class$java$sql$Connection, Boolean.TYPE, Integer.TYPE);
            tempClob = createTemporaryMethod.invoke(null, connection, Boolean.TRUE, DURATION_SESSION);
            Method openMethod = aClobClass.getMethod("open", Integer.TYPE);
            openMethod.invoke(tempClob, MODE_READWRITE);
            Method getCharacterOutputStreamMethod = tempClob.getClass().getMethod("getCharacterOutputStream", new Class[0]);
            Writer tempClobWriter = (Writer)getCharacterOutputStreamMethod.invoke(tempClob, new Object[0]);
            tempClobWriter.write((String)this.typeCast(value));
            tempClobWriter.flush();
            tempClobWriter.close();
            Method closeMethod = tempClob.getClass().getMethod("close", new Class[0]);
            closeMethod.invoke(tempClob, new Object[0]);
        }
        catch (IllegalAccessException e) {
            this.freeTemporaryClob(tempClob);
            throw new TypeCastException(value, this, e);
        }
        catch (NoSuchMethodException e) {
            this.freeTemporaryClob(tempClob);
            throw new TypeCastException(value, this, e);
        }
        catch (IOException e) {
            this.freeTemporaryClob(tempClob);
            throw new TypeCastException(value, this, e);
        }
        catch (InvocationTargetException e) {
            this.freeTemporaryClob(tempClob);
            throw new TypeCastException(value, this, e.getTargetException());
        }
        catch (ClassNotFoundException e) {
            this.freeTemporaryClob(tempClob);
            throw new TypeCastException(value, this, e);
        }
        return tempClob;
    }

    protected void freeTemporaryClob(Object tempClob) throws TypeCastException {
        logger.debug("freeTemporaryClob(tempClob=" + tempClob + ") - start");
        if (tempClob == null) {
            return;
        }
        try {
            Method freeTemporaryMethod = tempClob.getClass().getMethod("freeTemporary", new Class[0]);
            freeTemporaryMethod.invoke(tempClob, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new TypeCastException("Error freeing Oracle CLOB", e);
        }
        catch (IllegalAccessException e) {
            throw new TypeCastException("Error freeing Oracle CLOB", e);
        }
        catch (InvocationTargetException e) {
            throw new TypeCastException("Error freeing Oracle CLOB", e.getTargetException());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

