/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util.xml;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlWriter {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$util$xml$XmlWriter == null ? (class$org$dbunit$util$xml$XmlWriter = XmlWriter.class$("org.dbunit.util.xml.XmlWriter")) : class$org$dbunit$util$xml$XmlWriter));
    private Writer out;
    private String encoding;
    private Stack stack = new Stack();
    private StringBuffer attrs;
    private boolean empty;
    private boolean closed = true;
    private boolean pretty = true;
    private boolean wroteText = false;
    private String indent = "  ";
    private String newline = "\n";
    static /* synthetic */ Class class$org$dbunit$util$xml$XmlWriter;

    public XmlWriter(Writer writer) {
        this(writer, null);
    }

    public XmlWriter(Writer writer, String encoding) {
        this.setWriter(writer, encoding);
    }

    public void enablePrettyPrint(boolean enable) {
        logger.debug("enablePrettyPrint(enable=" + enable + ") - start");
        this.pretty = enable;
    }

    public void setIndent(String indent) {
        logger.debug("setIndent(indent=" + indent + ") - start");
        this.indent = indent;
    }

    public void setNewline(String newline) {
        logger.debug("setNewline(newline=" + newline + ") - start");
        this.newline = newline;
    }

    public XmlWriter writeElementWithText(String name, String text) throws IOException {
        logger.debug("writeElementWithText(name=" + name + ", text=" + text + ") - start");
        this.writeElement(name);
        this.writeText(text);
        return this.endElement();
    }

    public XmlWriter writeEmptyElement(String name) throws IOException {
        logger.debug("writeEmptyElement(name=" + name + ") - start");
        this.writeElement(name);
        return this.endElement();
    }

    public XmlWriter writeElement(String name) throws IOException {
        logger.debug("writeElement(name=" + name + ") - start");
        return this.openElement(name);
    }

    private XmlWriter openElement(String name) throws IOException {
        logger.debug("openElement(name=" + name + ") - start");
        boolean wasClosed = this.closed;
        this.closeOpeningTag();
        this.closed = false;
        if (this.pretty) {
            if (!wasClosed || this.wroteText) {
                this.out.write(this.newline);
            }
            for (int i = 0; i < this.stack.size(); ++i) {
                this.out.write(this.indent);
            }
        }
        this.out.write("<");
        this.out.write(name);
        this.stack.add(name);
        this.empty = true;
        this.wroteText = false;
        return this;
    }

    private void closeOpeningTag() throws IOException {
        logger.debug("closeOpeningTag() - start");
        if (!this.closed) {
            this.writeAttributes();
            this.closed = true;
            this.out.write(">");
        }
    }

    private void writeAttributes() throws IOException {
        logger.debug("writeAttributes() - start");
        if (this.attrs != null) {
            this.out.write(this.attrs.toString());
            this.attrs.setLength(0);
            this.empty = false;
        }
    }

    public XmlWriter writeAttribute(String attr, String value) throws IOException {
        logger.debug("writeAttribute(attr=" + attr + ", value=" + value + ") - start");
        if (this.attrs == null) {
            this.attrs = new StringBuffer();
        }
        this.attrs.append(" ");
        this.attrs.append(attr);
        this.attrs.append("=\"");
        this.attrs.append(this.escapeXml(value));
        this.attrs.append("\"");
        return this;
    }

    public XmlWriter endElement() throws IOException {
        logger.debug("endElement() - start");
        if (this.stack.empty()) {
            throw new IOException("Called endElement too many times. ");
        }
        String name = (String)this.stack.pop();
        if (name != null) {
            if (this.empty) {
                this.writeAttributes();
                this.out.write("/>");
            } else {
                if (this.pretty && !this.wroteText) {
                    for (int i = 0; i < this.stack.size(); ++i) {
                        this.out.write(this.indent);
                    }
                }
                this.out.write("</");
                this.out.write(name);
                this.out.write(">");
            }
            if (this.pretty) {
                this.out.write(this.newline);
            }
            this.empty = false;
            this.closed = true;
            this.wroteText = false;
        }
        return this;
    }

    public void close() throws IOException {
        logger.debug("close() - start");
        this.out.flush();
        if (!this.stack.empty()) {
            throw new IOException("Tags are not all closed. Possibly, " + this.stack.pop() + " is unclosed. ");
        }
    }

    public XmlWriter writeText(String text) throws IOException {
        logger.debug("writeText(text=" + text + ") - start");
        this.closeOpeningTag();
        this.empty = false;
        this.wroteText = true;
        this.out.write(this.escapeXml(text));
        return this;
    }

    public XmlWriter writeCData(String cdata) throws IOException {
        logger.debug("writeCData(cdata=" + cdata + ") - start");
        this.closeOpeningTag();
        this.empty = false;
        this.wroteText = true;
        this.out.write("<![CDATA[");
        this.out.write(cdata);
        this.out.write("]]>");
        return this;
    }

    public XmlWriter writeComment(String comment) throws IOException {
        logger.debug("writeComment(comment=" + comment + ") - start");
        this.writeChunk("<!-- " + comment + " -->");
        return this;
    }

    private void writeChunk(String data) throws IOException {
        logger.debug("writeChunk(data=" + data + ") - start");
        this.closeOpeningTag();
        this.empty = false;
        if (this.pretty && !this.wroteText) {
            for (int i = 0; i < this.stack.size(); ++i) {
                this.out.write(this.indent);
            }
        }
        this.out.write(data);
        if (this.pretty) {
            this.out.write(this.newline);
        }
    }

    public static void main(String[] args) throws IOException {
        logger.debug("main(args=" + args + ") - start");
        XmlWriter.test1();
        XmlWriter.test2();
    }

    public static void test1() throws IOException {
        logger.debug("test1() - start");
        StringWriter writer = new StringWriter();
        XmlWriter xmlwriter = new XmlWriter(writer);
        xmlwriter.writeElement("person").writeAttribute("name", "fred").writeAttribute("age", "12").writeElement("phone").writeText("4254343").endElement().writeElement("friends").writeElement("bob").endElement().writeElement("jim").endElement().endElement().endElement();
        xmlwriter.close();
        System.err.println(((Object)writer).toString());
    }

    public static void test2() throws IOException {
        logger.debug("test2() - start");
        StringWriter writer = new StringWriter();
        XmlWriter xmlwriter = new XmlWriter(writer);
        xmlwriter.writeComment("Example of XmlWriter running");
        xmlwriter.writeElement("person");
        xmlwriter.writeAttribute("name", "fred");
        xmlwriter.writeAttribute("age", "12");
        xmlwriter.writeElement("phone");
        xmlwriter.writeText("4254343");
        xmlwriter.endElement();
        xmlwriter.writeComment("Examples of empty tags");
        xmlwriter.writeElement("friends");
        xmlwriter.writeEmptyElement("bob");
        xmlwriter.writeEmptyElement("jim");
        xmlwriter.endElement();
        xmlwriter.writeElementWithText("foo", "This is an example.");
        xmlwriter.endElement();
        xmlwriter.close();
        System.err.println(((Object)writer).toString());
    }

    private String escapeXml(String str) {
        logger.debug("escapeXml(str=" + str + ") - start");
        str = this.replace(str, "&", "&amp;");
        str = this.replace(str, "<", "&lt;");
        str = this.replace(str, ">", "&gt;");
        str = this.replace(str, "\"", "&quot;");
        str = this.replace(str, "'", "&apos;");
        str = this.replace(str, "\t", "&#09;");
        return str;
    }

    private String replace(String value, String original, String replacement) {
        logger.debug("replace(value=" + value + ", original=" + original + ", replacement=" + replacement + ") - start");
        StringBuffer buffer = null;
        int startIndex = 0;
        int lastEndIndex = 0;
        while (true) {
            if ((startIndex = value.indexOf(original, lastEndIndex)) == -1) {
                if (buffer == null) break;
                buffer.append(value.substring(lastEndIndex));
                break;
            }
            if (buffer == null) {
                buffer = new StringBuffer((int)((double)original.length() * 1.5));
            }
            buffer.append(value.substring(lastEndIndex, startIndex));
            buffer.append(replacement);
            lastEndIndex = startIndex + original.length();
        }
        return buffer == null ? value : buffer.toString();
    }

    private void setEncoding(String encoding) {
        logger.debug("setEncoding(encoding=" + encoding + ") - start");
        if (encoding == null && this.out instanceof OutputStreamWriter) {
            encoding = ((OutputStreamWriter)this.out).getEncoding();
        }
        if (encoding != null) {
            if ("UTF8".equals(encoding = encoding.toUpperCase())) {
                encoding = "UTF-8";
            } else if ("US-ASCII".equals(encoding) || "ASCII".equals(encoding)) {
                encoding = "US-ASCII";
            } else if ("ISO-8859-1".equals(encoding) || "8859_1".equals(encoding) || "ISO8859_1".equals(encoding)) {
                encoding = "ISO-8859-1";
            } else if ("UNICODE".equals(encoding) || "UNICODE-BIG".equals(encoding) || "UNICODE-LITTLE".equals(encoding)) {
                encoding = "UTF-16";
            }
        }
        this.encoding = encoding;
    }

    public final void setWriter(Writer writer, String encoding) {
        logger.debug("setWriter(writer=" + writer + ", encoding=" + encoding + ") - start");
        if (this.out != null) {
            throw new IllegalStateException("can't change stream in mid course");
        }
        this.out = writer;
        if (this.out != null) {
            this.setEncoding(encoding);
        }
    }

    public XmlWriter writeDeclaration() throws IOException {
        logger.debug("writeDeclaration() - start");
        if (this.encoding != null) {
            this.out.write("<?xml version='1.0'");
            this.out.write(" encoding='" + this.encoding + "'");
            this.out.write("?>");
            this.out.write(this.newline);
        }
        return this;
    }

    public XmlWriter writeDoctype(String systemId, String publicId) throws IOException {
        logger.debug("writeDoctype(systemId=" + systemId + ", publicId=" + publicId + ") - start");
        if (systemId != null || publicId != null) {
            this.out.write("<!DOCTYPE dataset");
            if (systemId != null) {
                this.out.write(" SYSTEM \"");
                this.out.write(systemId);
                this.out.write("\"");
            }
            if (publicId != null) {
                this.out.write(" PUBLIC \"");
                this.out.write(publicId);
                this.out.write("\"");
            }
            this.out.write(">");
            this.out.write(this.newline);
        }
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

