/*
 * Decompiled with CFR 0.152.
 */
package marubinotto.piggydb.standalone;

import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SplashScreen;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.servlet.UnavailableException;
import javax.swing.JOptionPane;
import marubinotto.piggydb.standalone.PiggydbSplashScreen;
import marubinotto.piggydb.standalone.Settings;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;

public class PiggydbServer {
    private static Log logger = LogFactory.getLog(PiggydbServer.class);
    static final String SERVER_NAME = "Piggydb";
    static final String URL_PREFIX = "http://localhost";
    static ResourceBundle messages;
    static PiggydbSplashScreen splashScreen;
    static Settings settings;
    static Server server;
    static WebAppContext webapp;
    static TrayIcon trayIcon;
    static final String DEFAULT_ERRMSG = "An unexpected error occurred. Check the log file for the error.";
    static final String WEBAPP_DIR = "webapp";
    static final String APP_SETTINGS_FILE_NAME = "application.properties";
    static final String APP_SETTINGS_FILE_PATH = "webapp/WEB-INF/config/application.properties";

    public static void main(String[] args) {
        try {
            PiggydbServer.launch();
        }
        catch (Throwable e) {
            splashScreen.close();
            JOptionPane.showMessageDialog(null, PiggydbServer.getSystemErrorMessage(), "Piggydb Error", 0);
            logger.error((Object)e.toString(), e);
            System.exit(1);
        }
    }

    static String getSystemErrorMessage() {
        if (messages == null) {
            return DEFAULT_ERRMSG;
        }
        return messages.getString("system-error");
    }

    static void launch() throws Throwable {
        messages = ResourceBundle.getBundle("messages");
        PiggydbServer.initSplashScreen();
        splashScreen.message("Loading launcher.properties ...");
        PiggydbServer.loadSettings();
        splashScreen.message("Initializing the server ...");
        PiggydbServer.initServer();
        splashScreen.message("Starting the server ...");
        server.start();
        logger.debug((Object)"The server has been started.");
        PiggydbServer.ensureWebappAvailable();
        PiggydbServer.setupTrayIcon();
        if (settings.isLaunchBrowserWhenStartup()) {
            splashScreen.message("Opening the home page ...");
            PiggydbServer.launchBrowser();
        }
        splashScreen.close();
        splashScreen = null;
        server.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initSplashScreen() throws Exception {
        String version = null;
        InputStream input = PiggydbServer.class.getResourceAsStream("VERSION");
        try {
            version = IOUtils.toString((InputStream)input);
        }
        finally {
            input.close();
        }
        SplashScreen s = SplashScreen.getSplashScreen();
        if (s != null) {
            splashScreen = new PiggydbSplashScreen(s, version);
        }
    }

    static void loadSettings() throws Exception {
        File baseDir = new File(System.getProperty("user.dir"));
        logger.info((Object)("baseDir: " + baseDir.getAbsolutePath()));
        settings = new Settings(baseDir);
    }

    static void initServer() throws IOException {
        server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(settings.getPort());
        server.addConnector((Connector)connector);
        File resourceBase = settings.getResourcePath(WEBAPP_DIR);
        File descriptor = settings.getResourcePath("webapp/WEB-INF/web.xml");
        if (!resourceBase.isDirectory()) {
            throw new FileNotFoundException(resourceBase.getAbsolutePath());
        }
        if (!descriptor.isFile()) {
            throw new FileNotFoundException(descriptor.getAbsolutePath());
        }
        File appSettingsSrc = settings.getResourcePath(APP_SETTINGS_FILE_NAME);
        if (appSettingsSrc.isFile()) {
            File appSettingsDest = settings.getResourcePath(APP_SETTINGS_FILE_PATH);
            FileUtils.copyFile((File)appSettingsSrc, (File)appSettingsDest);
        }
        webapp = new WebAppContext();
        webapp.setContextPath("/");
        webapp.setResourceBase(resourceBase.getAbsolutePath());
        webapp.setDescriptor(descriptor.getAbsolutePath());
        webapp.setParentLoaderPriority(true);
        server.setHandler((Handler)webapp);
    }

    static void ensureWebappAvailable() throws Throwable {
        Throwable webappError = webapp.getUnavailableException();
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Server started {");
            logger.info((Object)("  isAvailable: " + webapp.isAvailable()));
            logger.info((Object)("  getUnavailableException: " + webappError));
            logger.info((Object)"}");
        }
        if (webappError != null) {
            throw webappError;
        }
        for (ServletHolder holder : webapp.getServletHandler().getServlets()) {
            boolean servletAvailable = holder.isAvailable();
            UnavailableException servletError = holder.getUnavailableException();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Servlet: [" + holder.getName() + "] {"));
                logger.info((Object)("  isAvailable: " + servletAvailable));
                logger.info((Object)("  getUnavailableException: " + servletError));
                logger.info((Object)"}");
            }
            if (servletError == null) continue;
            throw servletError;
        }
    }

    static void setupTrayIcon() throws IOException, AWTException {
        logger.debug((Object)"Loading the tray icon ...");
        trayIcon = new TrayIcon(ImageIO.read(PiggydbServer.class.getResourceAsStream("tray-icon.png")), SERVER_NAME);
        PopupMenu menu = new PopupMenu();
        menu.add(PiggydbServer.createMenuItem(messages.getString("home"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    PiggydbServer.launchBrowser();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }));
        menu.add(PiggydbServer.createMenuItem(messages.getString("info"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                trayIcon.displayMessage(PiggydbServer.SERVER_NAME, "Piggydb server is running on port " + settings.getPort(), TrayIcon.MessageType.INFO);
            }
        }));
        menu.add(PiggydbServer.createMenuItem(messages.getString("shutdown"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    server.stop();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                System.exit(0);
            }
        }));
        trayIcon.setPopupMenu(menu);
        logger.debug((Object)"Adding the icon to the system tray ...");
        SystemTray.getSystemTray().add(trayIcon);
        logger.debug((Object)"Done setupTrayIcon()");
    }

    static MenuItem createMenuItem(String label, ActionListener listener) {
        MenuItem item = new MenuItem(label);
        item.addActionListener(listener);
        return item;
    }

    static void launchBrowser() throws IOException, URISyntaxException {
        String url = URL_PREFIX;
        if (settings.getPort() != 80) {
            url = url + ":" + settings.getPort();
        }
        Desktop.getDesktop().browse(new URI(url));
    }

    static {
        splashScreen = PiggydbSplashScreen.NULL;
    }
}

