using System;
using System.Collections;
using System.Collections.Specialized;
using System.Text;
using System.Web;

namespace tenpay
{
	/// <summary>
	/// ResponseHandler ժҪ˵
	/// </summary>
	public class ResponseHandler
	{
		/** Կ */
		private string key;
		
		/** ӦĲ */
		protected Hashtable parameters;
		
		/** debugϢ */
		private string debugInfo;

		protected HttpContext httpContext;

		//ȡ֪ͨݷʽвȡ
		public ResponseHandler(HttpContext httpContext)
		{
			parameters = new Hashtable();

			this.httpContext = httpContext;
			NameValueCollection collection;
			if(this.httpContext.Request.HttpMethod == "POST")
			{
				collection = this.httpContext.Request.Form;
			}
			else
			{
				collection = this.httpContext.Request.QueryString;
			}

			foreach(string k in collection)
			{
				string v = (string)collection[k];
				this.setParameter(k, v);
			}
		}	

		/** ȡԿ */
		public string getKey() 
		{ return key;}

		/** Կ */
		public void setKey(string key) 
		{ this.key = key;}

		/** ȡֵ */
		public string getParameter(string parameter) 
		{
			string s = (string)parameters[parameter];
			return (null == s) ? "" : s;
		}

		/** òֵ */
		public void setParameter(string parameter,string parameterValue) 
		{
			if(parameter != null && parameter != "")
			{
				if(parameters.Contains(parameter))
				{
					parameters.Remove(parameter);
				}
	
				parameters.Add(parameter,parameterValue);		
			}
		}

		/** ǷƸͨǩ,:a-z,ֵĲμǩ 
		 * @return boolean */
		public virtual Boolean isTenpaySign() 
		{
			StringBuilder sb = new StringBuilder();

			ArrayList akeys=new ArrayList(parameters.Keys); 
			akeys.Sort();

			foreach(string k in akeys)
			{
				string v = (string)parameters[k];
				if(null != v && "".CompareTo(v) != 0
					&& "sign".CompareTo(k) != 0 && "key".CompareTo(k) != 0) 
				{
					sb.Append(k + "=" + v + "&");
				}
			}

			sb.Append("key=" + this.getKey());
			string sign = MD5Util.GetMD5(sb.ToString(),getCharset()).ToLower();
			
			//debugϢ
			this.setDebugInfo(sb.ToString() + " => sign:" + sign);
			return getParameter("sign").ToLower().Equals(sign); 
		}

		/**
		* ʾ
		* @param show_url ʾurlַ,urlַʽ(http://www.xxx.com/xxx.aspx)
		* @throws IOException 
		*/
		public void doShow(string show_url) 
		{
			string strHtml = "<html><head>\r\n" +
				"<meta name=\"TENCENT_ONLINE_PAYMENT\" content=\"China TENCENT\">\r\n" +
				"<script language=\"javascript\">\r\n" +
				"window.location.href='" + show_url + "';\r\n" +
				"</script>\r\n" +
				"</head><body></body></html>";

			this.httpContext.Response.Write(strHtml);

			this.httpContext.Response.End();		
		}

		/** ȡdebugϢ */
		public string getDebugInfo() 
		{ return debugInfo;}
				
		/** debugϢ */
		protected void setDebugInfo(String debugInfo)
		{ this.debugInfo = debugInfo;}

		protected virtual string getCharset()
		{
			return this.httpContext.Request.ContentEncoding.BodyName;
			
		}

		/** ǷƸͨǩ,:a-z,ֵĲμǩ 
		 * @return boolean */
		public virtual Boolean _isTenpaySign(ArrayList akeys) 
		{
			StringBuilder sb = new StringBuilder();

			foreach(string k in akeys)
			{
				string v = (string)parameters[k];
				if(null != v && "".CompareTo(v) != 0
					&& "sign".CompareTo(k) != 0 && "key".CompareTo(k) != 0) 
				{
					sb.Append(k + "=" + v + "&");
				}
			}

			sb.Append("key=" + this.getKey());
			string sign = MD5Util.GetMD5(sb.ToString(),getCharset()).ToLower();
			
			//debugϢ
			this.setDebugInfo(sb.ToString() + " => sign:" + sign);
			return getParameter("sign").ToLower().Equals(sign); 
		}
	}
}
