<!--#include file="../inc/config.asp" -->
<%
dim s_key
s_key=request.QueryString("key")
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"> 
<html DIR="LTR"> 
<head> 
  <meta http-equiv="content-type" content="text/html; charset=UTF-8" /> 
  <title>Google Maps JavaScript API v3 示例：Place Search</title> 
  <script type="text/javascript" src="http://maps.google.com/maps/api/js?sensor=true&amp;libraries=places,geometry"></script> 
 
  <style type="text/css">
    #map {
      height:400px;
      width:600px;
      border: thin solid #333;
      margin-top:0.6em;
    }
  </style>
 
  <script type="text/javascript">
 
    var map;
    var service;
    var infowindow;
 		
		google.maps.LatLng.prototype.distanceFrom = function(latlng) {
			var lat = [this.lat(), latlng.lat()]
			var lng = [this.lng(), latlng.lng()]
			var R = 6378137;
			var dLat = (lat[1]-lat[0]) * Math.PI / 180;
			var dLng = (lng[1]-lng[0]) * Math.PI / 180;
			var a = Math.sin(dLat/2) * Math.sin(dLat/2) +
			Math.cos(lat[0] * Math.PI / 180 ) * Math.cos(lat[1] * Math.PI / 180 ) *
			Math.sin(dLng/2) * Math.sin(dLng/2);
			var c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1-a));
			var d = R * c;
			return Math.round(d);
		}

    function initialize() { 
      var pyrmont = new google.maps.LatLng(-33.8665433,151.1956316);
 
      map = new google.maps.Map(document.getElementById('map'), {
        mapTypeId: google.maps.MapTypeId.ROADMAP,
        center: pyrmont,
				streetViewControl: false,     
				streetViewControlOptions: {         
					position: google.maps.ControlPosition.LEFT_TOP     
				},
        zoom: 15
      });
      var request = {
        location: pyrmont,
        radius: '500'        
      };
      infowindow = new google.maps.InfoWindow();
      service = new google.maps.places.PlacesService(map);
      service.search(request, callback);
    }
 
    function callback(results, status) {
      if (status == google.maps.places.PlacesServiceStatus.OK) {
        for (var i = 0; i < results.length; i++) {
          var place = results[i];
          createMarker(results[i]); 
        }
      }
    }
 
    function createMarker(place) {
      var placeLoc = place.geometry.location;
			var cicon = new google.maps.MarkerImage(place.icon,new google.maps.Size(50,50));
      var marker = new google.maps.Marker({
        map: map,
				icon:cicon,
        position: new google.maps.LatLng(placeLoc.lat(), placeLoc.lng())
      });
			var loc1 = new google.maps.LatLng(-33.867114, 151.1957);
			var loc2 = new google.maps.LatLng(placeLoc.lat(), placeLoc.lng());
			var dist = loc2.distanceFrom(loc1);
			var aa=google.maps.geometry.spherical.computeDistanceBetween(loc1,loc2);
      google.maps.event.addListener(marker, 'click', function() {
        infowindow.setContent(place.name+"<img src='"+place.icon+"' /><br>Types:"+place.types+"<br>"+place.vicinity+"<br>"+"Dis:"+dist+"M"+aa );
        infowindow.open(map, this);
      });
    }
 
  </script> 
</head> 
<body onload="initialize()"> 
  <div id="map"></div>
  <div id="text">
    <pre>
var request = {
  bounds: new google.maps.LatLngBounds(
      new google.maps.LatLng(-33.867114, 151.1957),
      new google.maps.LatLng(-33.866755, 151.196138)),
  types: ['political']
};
    </pre>
</body> 
</html> 

