
/*
 * Set content type for HTTP header before sending request
 */
oAjax.prototype.SetContentType = function( type ) {
    this.ContentType = type;
}

oAjax.prototype.createXMLHttpRequest = function() {

    try { return new ActiveXObject("Msxml2.XMLHTTP");    } catch(e) {}
    try { return new ActiveXObject("Microsoft.XMLHTTP"); } catch(e) {}
    try { return new XMLHttpRequest();                   } catch(e) {}
    return null;
}

/*
 * Debug information for testing
 */
oAjax.prototype._debug = function(message) {

    if ( this.Debug )
    {
        alert(message);
    }
}

/*
 * Process message and data from lodo_server
 */
oAjax._OnReadyStateChange = function( xreq, callback ){
	
    if ( xreq == null )
    {
        return;    }
   
    /*Status is completed, then process result */
    if ( xreq.readyState == 4)
    {
        // OK       
		
        if ( xreq.status == 200 )
        {
			//alert(xreq.responseText);
			// document.write(xreq.responseText)
          	callback (this.ArrayValue(xreq.responseXML) );                     
        }else{
//			alert('˴');
//			document.write (xreq.responseText);
		}
    } else {
        // Others
    }
}

oAjax.prototype._SendRequest = function(HttpMethod, data){

    this._debug( 'Send Request ' + HttpMethod + data );
    
    if ( this.HttpRequest != null )
    {
		
        this.HttpRequest.open(HttpMethod, this.Url, true);
		
        if ( this.ContentType != null )
        {
            //  <FORM> MIME type: application/x-www-form-urlencoded
            this.HttpRequest.setRequestHeader("Content-Type", this.ContentType);
        }
        this.HttpRequest.send(data);
		
        return true;
    }
    return false;
}

/* Send GET request to server */
oAjax.prototype._get = function () {

    this._debug( 'GET' );
    return this._SendRequest("GET", null);
}

/* Send POST request and data to server */
oAjax.prototype._post = function (data) {

    this._debug( 'POST' );
    return this._SendRequest("POST", data);
}

oAjax.ArrayValue = function ( xmlobj ) {
    var array = new Array();
    var i = 0;
	
    var response = xmlobj.getElementsByTagName('response')[0];
	var element = response.firstChild;
	
	array[i] = element.firstChild.nodeValue;
	
	while ( element = element.nextSibling )
	{
		
		i ++;
		array[i] = element.firstChild.nodeValue;
		}
	return array;
}