function rateBar(){
	this.top = -1;
	this.left = -1;
	this.width = 250;
	this.height = 25;
	this.color = 'blue';
	this.bgcolor = 'lightGrey'
	this.zIndex = 999999999;
	
	var that = this;
	var time = null;
	var rate = null;
	var oBar = null;
	var oTop = null;
	var oMid = null;
	var oBox = null;
	var oBot = null;
	
	var _init = function(){
		// rateBar
		oBar = document.createElement('div');
		oBar.id = 'rateBar';
		oBar.style.position = 'absolute';
		oBar.style.padding = '20px';
		oBar.style.top = that.top+'px';
		oBar.style.left = that.left+'px';
		oBar.style.fontSize = '12px';
		oBar.style.background = that.bgcolor;
		oBar.style.zIndex = that.zIndex;
		// rateTop
		oTop = document.createElement('div');
		oTop.id = 'rateTop';
		oTop.innerHTML = '&nbsp;';
		oBar.appendChild(oTop);
		// rateMid
		oMid = document.createElement('div');
		oMid.id = 'rateMid';
		oMid.style.margin = '7px 0px';
		oMid.style.width = that.width+'px';
		oMid.style.border = that.color+' 1px solid';
		oBar.appendChild(oMid);
		// rateBox
		oBox = document.createElement('div');
		oBox.id = 'rateBox';
		oBox.style.width = '0px';
		oBox.style.height = that.height+'px';
		oBox.style.background = that.color;
		oMid.appendChild(oBox);
		// rateBot
		oBot = document.createElement('div');
		oBot.id = 'rateBot';
		oBot.style.width = that.width+'px';
		oBot.style.wordWrap = 'break-word';
		oBot.style.wordBreak = 'break-all';
		oBot.innerHTML = '&nbsp;';
		oBar.appendChild(oBot);
		
		document.body.appendChild(oBar);
	}
	
	this.show = function(dx, dy){
		if(this.top<0){
			var _bh = document.body.scrollHeight;
			var _dh = document.documentElement.scrollHeight;
			this.top = (Math.max(_bh, _dh)- this.height)/2 - 20;
		}
		if(this.left<0){
			var _bw = document.body.scrollWidth;
			var _dw = document.documentElement.scrollWidth;
			this.left = (Math.max(_bw, _dw) - this.width)/2 - 20;
		}
		if(typeof(dx)=='undefined') dx = 0;
		if(typeof(dy)=='undefined') dy = 0;
		this.top += dx;
		this.left += dy;
		var now = new Date();
		time = now.getTime();
		rate = 0;
		_init();
	}
	
	this.step = function(r){
		rate = parseFloat(r);
		if(rate<0) rate = 0;
		if(rate>1) rate = 1;
		var _w = Math.round(this.width*rate);
		try{oBox.style.width = _w+'px';}catch(e){};
	}
	
	this.hide = function(){
		if(oTop){oBar.removeChild(oTop); oTop = null;}
		if(oBox){oMid.removeChild(oBox); oBox = null;}
		if(oMid){oBar.removeChild(oMid); oMid = null;}
		if(oBot){oBar.removeChild(oBot); oBot = null;}
		if(oBar){document.body.removeChild(oBar); oBar = null;}
	}
	
	this.comp = function(){
		var r = Math.round(rate*10000)/100;
		var t = Math.round(this.time()/100)/10;
		if(t>60){
			var m = Math.floor(t/60);
			if(m>60){
				var h = Math.floor(t/60);
				m = h+'h'+m%60;
			}
			t = m+'m'+Math.round(t%60);
		}
		this.tips('Completed '+ r +'% Remaining '+ t +'s');
	}
	
	this.time = function(){
		if(rate>0){
			var t = this.cost();
			return (t/rate-t);
		}
		return 0
	}
	
	this.cost = function(){
		var now = new Date();
		return (now.getTime() - time);
	}
	
	this.tips = function(t){
		if(oTop) oTop.innerHTML = t;
	}
	
	this.text = function(t){
		if(oBot) oBot.innerHTML = t;
	}
}