var browser = new CBrowser();
var system = {'version':'0.1.0', 'popmenu':[], 'zIndex':713}

function createElement(tag, css, htm){
	if(typeof(tag)=='undefined') tag = 'div';
	if(typeof(css)=='undefined') css = '';
	if(typeof(htm)=='undefined') htm = '';
	var elem = document.createElement(tag);
	elem.style.cssText = css;
	elem.innerHTML = htm;
	return elem;
}

function removeElement(elem){
	var node = elem.lastChild;
	while(node!=null){
		removeElement(node);
		elem.removeChild(node);
		node = elem.lastChild;
	}
}

function CMask(){
	var _ol = false;
	var _bw = document.body.scrollWidth;
	var _bh = document.body.scrollHeight;
	var _dw = document.documentElement.scrollWidth;
	var _dh = document.documentElement.scrollHeight;
	var css = 'position:absolute;top:0;left:0;background-color:gray;filter:Alpha(opacity=60);display:none;';
	this.Frame = createElement('div', css);
	this.Frame.style.width = Math.max(_bw, _dw)+'px';
	this.Frame.style.height = Math.max(_bh, _dh)+'px';
	this.Frame.style.zIndex = 523;
	this.init = function(){if(_ol==false){document.body.appendChild(this.Frame);_ol = true;}}
	this.show = function(){this.Frame.style.display = 'block'; if(_ol==false) this.init();}
	this.hide = function(){this.Frame.style.display = 'none';}
	this.exit = function(){document.body.removeChild(this.Frame);}
}

function CRect(x,y,w,h)
{
	initialize();
	this.top = y;
	this.left = x;
	this.width = w;
	this.height = h;
	function initialize(){
		var _sw = document.documentElement.scrollWidth;
		var _cw = document.documentElement.clientWidth;
		var _sh = document.documentElement.scrollHeight;
		var _ch = document.documentElement.clientHeight;
		if(typeof(w)=='undefined') w = 200;
		if(typeof(h)=='undefined') h = 200;
		if(typeof(x)=='undefined' || x<0) x = (Math.max(_sw,_cw)-w)/2;
		if(typeof(y)=='undefined' || y<0) y = (Math.max(_sh,_ch)-h)/2;
	}
}

function CMenusBar(){
	var cssText = 'padding-top:5px;height:20px;font-size:12px;background:gainsboro;overflow:hidden;cursor:default;';
	this.Frame = createElement('div', cssText);
	this.Menus = null;
	this.appendMenu = function(name, comm, css, menu){
		var MenusBar = createElement('div', css);
		MenusBar.style.padding = '3px';
		MenusBar.style.display = 'inline';
		MenusBar.style.whiteSpace = 'nowrap';
		MenusBar.onmouseover = function(){this.style.background = 'silver';}
		MenusBar.onmouseout = function(){this.style.background = 'gainsboro';}
		MenusBar.innerHTML = name;
		MenusBar.onclick = comm;
		this.Frame.appendChild(MenusBar);
		this.Menus = menu ? menu : null;
		return MenusBar;
	}
}

function CTitleBar(){
	var cssCtrl = 'float:right;margin:3px 2px;width:12px;height:12px;';
	cssCtrl += 'text-align:center;font-size:10px;background:snow;';
	var cssText = 'height:20px;background:steelblue;overflow:hidden;cursor:default;';
	this.Frame = createElement('div', cssText);
	cssText = 'float:left;padding:3px;height:20px;font-size:12px;';
	this.Icon = createElement('div', cssText + 'width:20px;color:red;', '&#x40A;');
	this.Title = createElement('div', cssText + 'width:100px;color:white;');
	this.Close = createElement('div', cssCtrl, '&#x2573;');
	this.Close.onmouseover = function(){this.style.background = 'pink';}
	this.Close.onmousedown = function(){this.style.background = 'pink';}
	this.Close.onmouseout = function(){this.style.background = 'snow';}
	this.Close.onmouseup = function(){this.style.background = 'snow';}
	this.Maxiz = createElement('div', cssCtrl, '&#x56D7;');
	this.Maxiz.onmouseover = function(){this.style.background = 'pink';}
	this.Maxiz.onmousedown = function(){this.style.background = 'pink';}
	this.Maxiz.onmouseout = function(){this.style.background = 'snow';}
	this.Maxiz.onmouseup = function(){this.style.background = 'snow';}
	this.Miniz = createElement('div', cssCtrl, '&#x2500;');
	this.Miniz.onmouseover = function(){this.style.background = 'pink';}
	this.Miniz.onmousedown = function(){this.style.background = 'pink';}
	this.Miniz.onmouseout = function(){this.style.background = 'snow';}
	this.Miniz.onmouseup = function(){this.style.background = 'snow';}
	this.Frame.appendChild(this.Icon);
	this.Frame.appendChild(this.Title);
	this.Frame.appendChild(this.Close);
	this.Frame.appendChild(this.Maxiz);
	this.Frame.appendChild(this.Miniz);
}

function CWindow()
{
	var eventD, eventX, eventY;
	var mouseD, mouseX, mouseY, mouseZ;
	
	this.style = 0;
	this.Rect = new CRect();
	this.WinForm = createElement('div', 'position:absolute;margin:2px;border:silver 1px solid;overflow:hidden;');
	this.WinLeft = createElement('div', 'float:left;width:2px;background:silver;cursor:e-resize;');
	this.WinBody = createElement('div', 'float:left;background:gainsboro;cursor:default;');
	this.WinRight = createElement('div', 'float:right;width:2px;background:silver;cursor:e-resize;');
	this.TitleBar = new CTitleBar();
	this.WinFrame = createElement('div');
	this.MenusBar = new CMenusBar();
	this.ToolsBar = createElement('div', 'height:30px;background:gainsboro;overflow:hidden;display:none;');
	this.Workspace = createElement('div', 'padding:3px;font-size:12px;background:white;overflow:scroll;');
	this.StatusBar = createElement('div', 'height:20px;background:snow;overflow:hidden;');
	
	this.initWinForm = function(){
		var that = this;
		this.WinForm.onmousedown = function(evt){
			evt = evt ? evt : window.event;
			if(evt.preventDefault){       
				evt.preventDefault();
				evt.stopPropagation();
			}else{  
				evt.cancelBubble=true;
				evt.returnValue = false;
			}
			if(mouseZ==1) this.style.cursor = 'nw-resize';
			if(mouseZ==2) this.style.cursor = 'n-resize';
			if(mouseZ==3) this.style.cursor = 'w-resize';
			if(mouseZ>0){
				mouseD = true;
				mouseX = evt.clientX - that.Rect.width;
				mouseY = evt.clientY - that.Rect.height;
				if(evt.srcElement)that.WinForm.setCapture();
			}
		}   
		this.WinForm.onmousemove = function(evt){
			evt = evt ? evt : window.event;
			if(evt.preventDefault){       
				evt.preventDefault();
				evt.stopPropagation();
			}else{  
				evt.cancelBubble=true;
				evt.returnValue = false;
			}
			if(eventD) return ;
			var evtX = evt.layerX ? evt.layerX : evt.offsetX;
			var evtY = evt.layerY ? evt.layerY : evt.offsetY;
			evtX = Math.abs(that.Rect.width - evtX);
			evtY = Math.abs(that.Rect.height - evtY);
			if(evtY<5 && evtX<5){
				this.style.cursor = 'nw-resize';
				mouseZ = 1;
			}else if(evtY<3){
				this.style.cursor = 'n-resize';
				mouseZ = 2;
			}else if(evtX<3){
				this.style.cursor = 'w-resize';
				mouseZ = 3;
			}else{
				this.style.cursor = '';
			}
			
			if(mouseD && (evt.button==1 || evt.button==0)){
				if(mouseZ==1){
					that.Rect.width = evt.clientX - mouseX;
					that.Rect.height = evt.clientY - mouseY;
					that.resizeWindow();
				}
				if(mouseZ==2){
					this.style.cursor = 'n-resize';
					that.Rect.height = evt.clientY - mouseY;
					that.resizeWindow();
				}
				if(mouseZ==3){
					this.style.cursor = 'e-resize';
					that.Rect.width = evt.clientX - mouseX;
					that.resizeWindow();
				}
			}
		}
		this.WinForm.onmouseup = function(evt){
			evt = evt ? evt : window.event;
			if(evt.srcElement)that.WinForm.releaseCapture();
			mouseD = false; mouseX = 0; mouseY = 0; mouseZ = 0; 
			this.style.cursor = '';
		}
		this.WinForm.onmouseout = function(evt){
			this.style.cursor = '';
		}
	}

	this.initTitleBar = function(){
		var that = this;
		this.TitleBar.Close.onclick = function(){ that.exitWindow(); }
		this.TitleBar.Maxiz.onclick = function(){
			that.WinFrame.style.display = 'block';
			that.WinForm.style.height = that.Rect.height + 'px';
			that.style = 0;
		}
		this.TitleBar.Miniz.onclick = function(){
			that.WinFrame.style.display = 'none';
			that.WinForm.style.height = 20 + 'px';
			that.style = 1;
		}
		this.TitleBar.Title.onmousedown = function(evt){
			eventD = true;
			evt = evt ? evt : window.event;
			if(evt.preventDefault){       
				evt.preventDefault();
				evt.stopPropagation();
			}else{  
				evt.cancelBubble=true;
				evt.returnValue = false;
			}
			eventX = evt.layerX ? evt.layerX : evt.offsetX;
			eventY = evt.layerY ? evt.layerY : evt.offsetY;
			that.WinForm.style.zIndex = 2010;
			if(evt.srcElement){
				that.WinForm.releaseCapture();
				this.setCapture();
			}
		}
		this.TitleBar.Title.onmousemove = function(evt){
			if(eventD){
				evt = evt ? evt : window.event;
				if(evt.preventDefault){       
					evt.preventDefault();
					evt.stopPropagation();
				}else{  
					evt.cancelBubble=true;
					evt.returnValue = false;
				}
				var rectTop = document.body.scrollTop;
				var rectLeft = document.body.scrollLeft;
				rectTop += (evt.y ? (evt.y - 4) : evt.clientY) - eventY;
				rectLeft += (evt.x ? (evt.x - 25) : evt.clientX) - eventX;
				that.Rect.top = rectTop;
				that.Rect.left =  rectLeft;
				that.resizeWindow();
			}
		}
		this.TitleBar.Title.onmouseup = function(evt){
			eventD = false;
			evt = evt ? evt : window.event;
			if(evt.srcElement)this.releaseCapture();
			that.WinForm.style.zIndex = system.zIndex ++;
		}
	}
	
	this.initTitleBar();
	this.initWinForm();
	
	this.hideWindow = function(){
		this.WinForm.style.display = 'none';
	}
	
	this.showWindow = function(){
		this.WinForm.style.display = 'block';
	}
	
	this.exitWindow = function(){
		this.destroyWindow();
	}
	
	this.destroyWindow = function(){
		removeElement(this.WinForm);
		document.body.removeChild(this.WinForm);
		CollectGarbage();
		setTimeout('CollectGarbage();',1);
	}
	
	this.resizeWindow = function(){
		if(this.Rect.top<0) this.Rect.top = 0;
		if(this.Rect.left<0) this.Rect.left = 0;
		if(this.Rect.width<100) this.Rect.width = 100;
		if(this.Rect.height<100) this.Rect.height = 100;
		this.WinForm.style.top = this.Rect.top + 'px';
		this.WinForm.style.left = this.Rect.left + 'px';
		this.WinForm.style.width = this.Rect.width + 'px';
		this.TitleBar.Frame.style.width = this.Rect.width + 'px';
		this.TitleBar.Title.style.width = this.Rect.width - 85 + 'px';
		this.WinFrame.style.width = this.Rect.width + 'px';
		this.MenusBar.Frame.style.width = this.Rect.width + 'px';
		this.Workspace.style.width = this.Rect.width + 'px';
		this.StatusBar.style.width = this.Rect.width + 'px';
		if(this.style==0){
			this.WinForm.style.height = this.Rect.height + 'px';
			this.WinFrame.style.height = this.Rect.height - 20 + 'px';
			this.Workspace.style.height = this.Rect.height - 65 + 'px';
		}
	}
	
	this.createWindow = function(){
		this.resizeWindow();
		this.MenusBar.appendMenu('About', function(){alert('xWindow Version 0.1.1');});
		this.WinForm.appendChild(this.TitleBar.Frame);
		this.WinFrame.appendChild(this.MenusBar.Frame);
		this.WinFrame.appendChild(this.ToolsBar);
		this.WinFrame.appendChild(this.Workspace);
		this.WinFrame.appendChild(this.StatusBar);
		this.WinForm.appendChild(this.WinFrame);
		document.body.appendChild(this.WinForm);
		this.WinForm.style.zIndex = system.zIndex ++;
	}
}